/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.io.payloads;

import java.io.Serializable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;

@Internal
@Experimental(value=Experimental.Kind.SCHEMAS)
public interface PayloadSerializer
extends Serializable {
    public static final long serialVersionUID = 5645783967169L;

    public byte[] serialize(Row var1);

    public Row deserialize(byte[] var1);

    public static PayloadSerializer of(final SerializableFunction<Row, byte[]> serializeFn, final SerializableFunction<byte[], Row> deserializeFn) {
        return new PayloadSerializer(){

            @Override
            public byte[] serialize(Row row) {
                return (byte[])serializeFn.apply(row);
            }

            @Override
            public Row deserialize(byte[] bytes) {
                return (Row)deserializeFn.apply(bytes);
            }
        };
    }
}

