/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.utils.ByteBuddyUtils;
import org.apache.beam.sdk.schemas.utils.FieldValueTypeSupplier;
import org.apache.beam.sdk.schemas.utils.JavaBeanUtils;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.ByteBuddy;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.NamingStrategy;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.asm.AsmVisitorWrapper;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.method.MethodDescription;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.method.MethodList;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.type.TypeDefinition;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.type.TypeDescription;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.dynamic.DynamicType;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.dynamic.scaffold.InstrumentedType;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.Implementation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.Duplication;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.Removal;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.TypeCreation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.collection.ArrayAccess;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.member.MethodReturn;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.matcher.ElementMatcher;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.matcher.ElementMatchers;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class AutoValueUtils {
    private static final ByteBuddy BYTE_BUDDY = new ByteBuddy();

    public static Class getBaseAutoValueClass(Class<?> clazz) {
        int lastDot = clazz.getName().lastIndexOf(46);
        String baseName = clazz.getName().substring(lastDot + 1, clazz.getName().length());
        return baseName.startsWith("AutoValue_") ? clazz.getSuperclass() : clazz;
    }

    private static Class getAutoValueGenerated(Class<?> clazz) {
        String generatedClassName = AutoValueUtils.getAutoValueGeneratedName(clazz.getName());
        try {
            return Class.forName(generatedClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("AutoValue generated class not found: " + generatedClassName);
        }
    }

    private static @Nullable Class getAutoValueGeneratedBuilder(Class<?> clazz) {
        String builderName = AutoValueUtils.getAutoValueGeneratedName(clazz.getName()) + "$Builder";
        try {
            return Class.forName(builderName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static String getAutoValueGeneratedName(String baseClass) {
        int lastDot = baseClass.lastIndexOf(46);
        String packageName = baseClass.substring(0, lastDot);
        String baseName = baseClass.substring(lastDot + 1, baseClass.length());
        baseName = baseName.replace('$', '_');
        return packageName + ".AutoValue_" + baseName;
    }

    public static @Nullable SchemaUserTypeCreator getConstructorCreator(Class<?> clazz, Schema schema, FieldValueTypeSupplier fieldValueTypeSupplier) {
        Class generatedClass = AutoValueUtils.getAutoValueGenerated(clazz);
        List<FieldValueTypeInformation> schemaTypes = fieldValueTypeSupplier.get(clazz, schema);
        Optional<Constructor> constructor = Arrays.stream(generatedClass.getDeclaredConstructors()).filter(c -> !Modifier.isPrivate(c.getModifiers())).filter(c -> AutoValueUtils.matchConstructor(c, schemaTypes)).findAny();
        return constructor.map(c -> JavaBeanUtils.getConstructorCreator(generatedClass, c, schema, fieldValueTypeSupplier, new ByteBuddyUtils.DefaultTypeConversionsFactory())).orElse(null);
    }

    private static boolean matchConstructor(Constructor<?> constructor, List<FieldValueTypeInformation> getterTypes) {
        if (constructor.getParameters().length != getterTypes.size()) {
            return false;
        }
        Map typeMap = getterTypes.stream().collect(Collectors.toMap(f -> ReflectUtils.stripGetterPrefix(f.getMethod().getName()), Function.identity()));
        for (Parameter parameter : constructor.getParameters()) {
            FieldValueTypeInformation type = typeMap.getOrDefault(parameter.getName(), null);
            if (type != null && type.getRawType() == parameter.getType()) continue;
            return false;
        }
        return true;
    }

    public static @Nullable SchemaUserTypeCreator getBuilderCreator(Class<?> clazz, Schema schema, FieldValueTypeSupplier fieldValueTypeSupplier) {
        Class builderClass = AutoValueUtils.getAutoValueGeneratedBuilder(clazz);
        if (builderClass == null) {
            return null;
        }
        Map setterTypes = ReflectUtils.getMethods(builderClass).stream().filter(ReflectUtils::isSetter).map(FieldValueTypeInformation::forSetter).collect(Collectors.toMap(FieldValueTypeInformation::getName, Function.identity()));
        ArrayList setterMethods = Lists.newArrayList();
        List<FieldValueTypeInformation> schemaTypes = fieldValueTypeSupplier.get(clazz, schema);
        for (FieldValueTypeInformation type : schemaTypes) {
            String autoValueFieldName = ReflectUtils.stripGetterPrefix(type.getMethod().getName());
            FieldValueTypeInformation setterType = (FieldValueTypeInformation)setterTypes.get(autoValueFieldName);
            if (setterType == null) {
                throw new RuntimeException("AutoValue builder class " + builderClass + " did not contain a setter for " + autoValueFieldName);
            }
            setterMethods.add(setterType);
        }
        Method buildMethod = ReflectUtils.getMethods(builderClass).stream().filter(m -> m.getName().equals("build")).findAny().orElseThrow(() -> new RuntimeException("No build method in builder"));
        return AutoValueUtils.createBuilderCreator(builderClass, setterMethods, buildMethod, schema, schemaTypes);
    }

    static SchemaUserTypeCreator createBuilderCreator(Class<?> builderClass, List<FieldValueTypeInformation> setterMethods, Method buildMethod, Schema schema, List<FieldValueTypeInformation> types) {
        try {
            DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = BYTE_BUDDY.with((NamingStrategy)new ByteBuddyUtils.InjectPackageStrategy(builderClass)).subclass(SchemaUserTypeCreator.class).method((ElementMatcher)ElementMatchers.named((String)"create")).intercept((Implementation)new BuilderCreateInstruction(types, setterMethods, builderClass, buildMethod));
            return (SchemaUserTypeCreator)builder.visit((AsmVisitorWrapper)new AsmVisitorWrapper.ForDeclaredMethods().writerFlags(2)).make().load(ReflectHelpers.findClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to generate a creator for class " + builderClass + " with schema " + schema);
        }
    }

    static class BuilderCreateInstruction
    implements Implementation {
        private final List<FieldValueTypeInformation> setters;
        private final Class<?> builderClass;
        private final Method buildMethod;

        BuilderCreateInstruction(List<FieldValueTypeInformation> types, List<FieldValueTypeInformation> setters, Class<?> builderClass, Method buildMethod) {
            this.setters = setters;
            this.builderClass = builderClass;
            this.buildMethod = buildMethod;
        }

        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            ByteBuddyUtils.DefaultTypeConversionsFactory typeConversionsFactory = new ByteBuddyUtils.DefaultTypeConversionsFactory();
            TypeDescription.ForLoadedType loadedBuilder = new TypeDescription.ForLoadedType(this.builderClass);
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                int numLocals = 1 + instrumentedMethod.getParameters().size();
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(new StackManipulation[]{TypeCreation.of((TypeDescription)loadedBuilder), Duplication.SINGLE, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)loadedBuilder.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.isConstructor().and((ElementMatcher)ElementMatchers.takesArguments((int)0)))).getOnly()))});
                ByteBuddyUtils.TypeConversion<Type> convertType = typeConversionsFactory.createTypeConversion(true);
                for (int i = 0; i < this.setters.size(); ++i) {
                    Method setterMethod = (Method)Preconditions.checkNotNull((Object)this.setters.get(i).getMethod());
                    Parameter parameter = setterMethod.getParameters()[0];
                    TypeDescription.ForLoadedType convertedType = new TypeDescription.ForLoadedType((Class)convertType.convert(TypeDescriptor.of(parameter.getParameterizedType())));
                    StackManipulation.Compound readParameter = new StackManipulation.Compound(new StackManipulation[]{MethodVariableAccess.REFERENCE.loadFrom(1), IntegerConstant.forValue((int)i), ArrayAccess.REFERENCE.load(), TypeCasting.to((TypeDefinition)convertedType)});
                    stackManipulation = new StackManipulation.Compound(new StackManipulation[]{stackManipulation, Duplication.SINGLE, typeConversionsFactory.createSetterConversions((StackManipulation)readParameter).convert(TypeDescriptor.of(parameter.getType())), MethodInvocation.invoke((MethodDescription.InDefinedShape)new MethodDescription.ForLoadedMethod(setterMethod)), Removal.SINGLE});
                }
                stackManipulation = new StackManipulation.Compound(new StackManipulation[]{stackManipulation, MethodInvocation.invoke((MethodDescription.InDefinedShape)new MethodDescription.ForLoadedMethod(this.buildMethod)), MethodReturn.REFERENCE});
                StackManipulation.Size size = stackManipulation.apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), numLocals);
            };
        }
    }
}

