/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.schemas.utils.FieldValueTypeSupplier;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.joda.time.ReadableInstant;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class StaticSchemaInference {
    private static final Map<Class, Schema.FieldType> PRIMITIVE_TYPES = ImmutableMap.builder().put(Byte.class, (Object)Schema.FieldType.BYTE).put(Byte.TYPE, (Object)Schema.FieldType.BYTE).put(Short.class, (Object)Schema.FieldType.INT16).put(Short.TYPE, (Object)Schema.FieldType.INT16).put(Integer.class, (Object)Schema.FieldType.INT32).put(Integer.TYPE, (Object)Schema.FieldType.INT32).put(Long.class, (Object)Schema.FieldType.INT64).put(Long.TYPE, (Object)Schema.FieldType.INT64).put(Float.class, (Object)Schema.FieldType.FLOAT).put(Float.TYPE, (Object)Schema.FieldType.FLOAT).put(Double.class, (Object)Schema.FieldType.DOUBLE).put(Double.TYPE, (Object)Schema.FieldType.DOUBLE).put(Boolean.class, (Object)Schema.FieldType.BOOLEAN).put(Boolean.TYPE, (Object)Schema.FieldType.BOOLEAN).put(BigDecimal.class, (Object)Schema.FieldType.DECIMAL).build();

    public static List<FieldValueTypeInformation> sortBySchema(List<FieldValueTypeInformation> types, Schema schema) {
        Map typeMap = types.stream().collect(Collectors.toMap(FieldValueTypeInformation::getName, Function.identity()));
        return schema.getFields().stream().map(f -> (FieldValueTypeInformation)typeMap.get(f.getName())).collect(Collectors.toList());
    }

    public static Schema schemaFromClass(Class<?> clazz, FieldValueTypeSupplier fieldValueTypeSupplier) {
        Schema.Builder builder = Schema.builder();
        for (FieldValueTypeInformation type : fieldValueTypeSupplier.get(clazz)) {
            Schema.FieldType fieldType = StaticSchemaInference.fieldFromType(type.getType(), fieldValueTypeSupplier);
            if (type.isNullable()) {
                builder.addNullableField(type.getName(), fieldType);
                continue;
            }
            builder.addField(type.getName(), fieldType);
        }
        return builder.build();
    }

    public static Schema.FieldType fieldFromType(TypeDescriptor type, FieldValueTypeSupplier fieldValueTypeSupplier) {
        Schema.FieldType primitiveType = PRIMITIVE_TYPES.get(type.getRawType());
        if (primitiveType != null) {
            return primitiveType;
        }
        if (type.getRawType().isEnum()) {
            Map<String, Integer> enumValues = Arrays.stream(type.getRawType().getEnumConstants()).map(Enum.class::cast).collect(Collectors.toMap(Enum::toString, Enum::ordinal));
            return Schema.FieldType.logicalType(EnumerationType.create(enumValues));
        }
        if (type.isArray()) {
            TypeDescriptor<?> component = type.getComponentType();
            if (component.getRawType().equals(Byte.TYPE)) {
                return Schema.FieldType.BYTES;
            }
            return Schema.FieldType.array(StaticSchemaInference.fieldFromType(component, fieldValueTypeSupplier));
        }
        if (type.isSubtypeOf(TypeDescriptor.of(Map.class))) {
            TypeDescriptor<Map> map = type.getSupertype(Map.class);
            if (map.getType() instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)map.getType();
                Type[] params = ptype.getActualTypeArguments();
                Preconditions.checkArgument((params.length == 2 ? 1 : 0) != 0);
                Schema.FieldType keyType = StaticSchemaInference.fieldFromType(TypeDescriptor.of(params[0]), fieldValueTypeSupplier);
                Schema.FieldType valueType = StaticSchemaInference.fieldFromType(TypeDescriptor.of(params[1]), fieldValueTypeSupplier);
                Preconditions.checkArgument((boolean)keyType.getTypeName().isPrimitiveType(), (Object)("Only primitive types can be map keys. type: " + (Object)((Object)keyType.getTypeName())));
                return Schema.FieldType.map(keyType, valueType);
            }
            throw new RuntimeException("Cannot infer schema from unparameterized map.");
        }
        if (type.isSubtypeOf(TypeDescriptor.of(CharSequence.class))) {
            return Schema.FieldType.STRING;
        }
        if (type.isSubtypeOf(TypeDescriptor.of(ReadableInstant.class))) {
            return Schema.FieldType.DATETIME;
        }
        if (type.isSubtypeOf(TypeDescriptor.of(ByteBuffer.class))) {
            return Schema.FieldType.BYTES;
        }
        if (type.isSubtypeOf(TypeDescriptor.of(Iterable.class))) {
            TypeDescriptor<Iterable> iterable = type.getSupertype(Iterable.class);
            if (iterable.getType() instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)iterable.getType();
                Type[] params = ptype.getActualTypeArguments();
                Preconditions.checkArgument((params.length == 1 ? 1 : 0) != 0);
                if (type.isSubtypeOf(TypeDescriptor.of(Collection.class))) {
                    return Schema.FieldType.array(StaticSchemaInference.fieldFromType(TypeDescriptor.of(params[0]), fieldValueTypeSupplier));
                }
                return Schema.FieldType.iterable(StaticSchemaInference.fieldFromType(TypeDescriptor.of(params[0]), fieldValueTypeSupplier));
            }
            throw new RuntimeException("Cannot infer schema from unparameterized collection.");
        }
        return Schema.FieldType.row(StaticSchemaInference.schemaFromClass(type.getRawType(), fieldValueTypeSupplier));
    }

    static enum MethodType {
        GETTER,
        SETTER;

    }
}

