/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.state.StateContext;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.CombineWithContext;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.CombineContextFactory;

@Internal
public class CombineFnUtil {
    public static <K, InputT, AccumT, OutputT> Combine.CombineFn<InputT, AccumT, OutputT> bindContext(CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn, StateContext<?> stateContext) {
        CombineWithContext.Context context = CombineContextFactory.createFromStateContext(stateContext);
        return new NonSerializableBoundedCombineFn(combineFn, context);
    }

    public static <InputT, AccumT, OutputT> CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> toFnWithContext(CombineFnBase.GlobalCombineFn<InputT, AccumT, OutputT> globalCombineFn) {
        if (globalCombineFn instanceof CombineWithContext.CombineFnWithContext) {
            CombineWithContext.CombineFnWithContext combineFnWithContext = (CombineWithContext.CombineFnWithContext)globalCombineFn;
            return combineFnWithContext;
        }
        final Combine.CombineFn combineFn = (Combine.CombineFn)globalCombineFn;
        return new CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT>(){

            @Override
            public AccumT createAccumulator(CombineWithContext.Context c) {
                return combineFn.createAccumulator();
            }

            @Override
            public AccumT addInput(AccumT accumulator, InputT input, CombineWithContext.Context c) {
                return combineFn.addInput(accumulator, input);
            }

            @Override
            public AccumT mergeAccumulators(Iterable<AccumT> accumulators, CombineWithContext.Context c) {
                return combineFn.mergeAccumulators(accumulators);
            }

            @Override
            public OutputT extractOutput(AccumT accumulator, CombineWithContext.Context c) {
                return combineFn.extractOutput(accumulator);
            }

            @Override
            public AccumT compact(AccumT accumulator, CombineWithContext.Context c) {
                return combineFn.compact(accumulator);
            }

            @Override
            public OutputT defaultValue() {
                return combineFn.defaultValue();
            }

            @Override
            public Coder<AccumT> getAccumulatorCoder(CoderRegistry registry, Coder<InputT> inputCoder) throws CannotProvideCoderException {
                return combineFn.getAccumulatorCoder(registry, inputCoder);
            }

            @Override
            public Coder<OutputT> getDefaultOutputCoder(CoderRegistry registry, Coder<InputT> inputCoder) throws CannotProvideCoderException {
                return combineFn.getDefaultOutputCoder(registry, inputCoder);
            }

            @Override
            public void populateDisplayData(DisplayData.Builder builder) {
                super.populateDisplayData(builder);
                combineFn.populateDisplayData(builder);
            }
        };
    }

    private static class NonSerializableBoundedCombineFn<InputT, AccumT, OutputT>
    extends Combine.CombineFn<InputT, AccumT, OutputT> {
        private final CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn;
        @SuppressFBWarnings(value={"SE_BAD_FIELD"})
        private final CombineWithContext.Context context;

        private NonSerializableBoundedCombineFn(CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn, CombineWithContext.Context context) {
            this.combineFn = combineFn;
            this.context = context;
        }

        @Override
        public AccumT createAccumulator() {
            return this.combineFn.createAccumulator(this.context);
        }

        @Override
        public AccumT addInput(AccumT accumulator, InputT value) {
            return this.combineFn.addInput(accumulator, value, this.context);
        }

        @Override
        public AccumT mergeAccumulators(Iterable<AccumT> accumulators) {
            return this.combineFn.mergeAccumulators(accumulators, this.context);
        }

        @Override
        public OutputT extractOutput(AccumT accumulator) {
            return this.combineFn.extractOutput(accumulator, this.context);
        }

        @Override
        public AccumT compact(AccumT accumulator) {
            return this.combineFn.compact(accumulator, this.context);
        }

        @Override
        public Coder<AccumT> getAccumulatorCoder(CoderRegistry registry, Coder<InputT> inputCoder) throws CannotProvideCoderException {
            return this.combineFn.getAccumulatorCoder(registry, (Coder)inputCoder);
        }

        @Override
        public Coder<OutputT> getDefaultOutputCoder(CoderRegistry registry, Coder<InputT> inputCoder) throws CannotProvideCoderException {
            return this.combineFn.getDefaultOutputCoder(registry, (Coder)inputCoder);
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            this.combineFn.populateDisplayData(builder);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw new NotSerializableException("Cannot serialize the CombineFn resulting from CombineFnUtil.bindContext.");
        }
    }
}

