/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;

public class TypeDescriptors {
    public static TypeDescriptor<Boolean> booleans() {
        return new TypeDescriptor<Boolean>(){};
    }

    public static TypeDescriptor<Double> doubles() {
        return new TypeDescriptor<Double>(){};
    }

    public static TypeDescriptor<Float> floats() {
        return new TypeDescriptor<Float>(){};
    }

    public static TypeDescriptor<Integer> integers() {
        return new TypeDescriptor<Integer>(){};
    }

    public static TypeDescriptor<Long> longs() {
        return new TypeDescriptor<Long>(){};
    }

    public static TypeDescriptor<Short> shorts() {
        return new TypeDescriptor<Short>(){};
    }

    public static TypeDescriptor<BigDecimal> bigdecimals() {
        return new TypeDescriptor<BigDecimal>(){};
    }

    public static TypeDescriptor<BigInteger> bigintegers() {
        return new TypeDescriptor<BigInteger>(){};
    }

    public static TypeDescriptor<Row> rows() {
        return new TypeDescriptor<Row>(){};
    }

    public static TypeDescriptor<String> strings() {
        return new TypeDescriptor<String>(){};
    }

    public static TypeDescriptor<Character> characters() {
        return new TypeDescriptor<Character>(){};
    }

    public static TypeDescriptor<Byte> bytes() {
        return new TypeDescriptor<Byte>(){};
    }

    public static TypeDescriptor<Void> nulls() {
        return new TypeDescriptor<Void>(){};
    }

    public static <K, V> TypeDescriptor<KV<K, V>> kvs(TypeDescriptor<K> key, TypeDescriptor<V> value) {
        return new TypeDescriptor<KV<K, V>>(){}.where(new TypeParameter<K>(){}, key).where(new TypeParameter<V>(){}, value);
    }

    public static <T> TypeDescriptor<Set<T>> sets(TypeDescriptor<T> element) {
        return new TypeDescriptor<Set<T>>(){}.where(new TypeParameter<T>(){}, element);
    }

    public static <K, V> TypeDescriptor<Map<K, V>> maps(TypeDescriptor<K> keyType, TypeDescriptor<V> valueType) {
        return new TypeDescriptor<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType);
    }

    public static <T> TypeDescriptor<List<T>> lists(TypeDescriptor<T> element) {
        return new TypeDescriptor<List<T>>(){}.where(new TypeParameter<T>(){}, element);
    }

    public static <T> TypeDescriptor<Iterable<T>> iterables(TypeDescriptor<T> iterable) {
        return new TypeDescriptor<Iterable<T>>(){}.where(new TypeParameter<T>(){}, iterable);
    }

    public static TypeDescriptor<Void> voids() {
        return new TypeDescriptor<Void>(){};
    }

    public static <T, V> TypeDescriptor<V> extractFromTypeParameters(T instance, Class<? super T> supertype, TypeVariableExtractor<T, V> extractor) {
        return TypeDescriptors.extractFromTypeParameters(TypeDescriptor.of(instance.getClass()), supertype, extractor);
    }

    public static <T, V> TypeDescriptor<V> extractFromTypeParameters(TypeDescriptor<T> type, Class<? super T> supertype, TypeVariableExtractor<T, V> extractor) {
        TypeDescriptor<TypeVariableExtractor> extractorSupertype = TypeDescriptor.of(extractor.getClass()).getSupertype(TypeVariableExtractor.class);
        Type inputT = ((ParameterizedType)extractorSupertype.getType()).getActualTypeArguments()[0];
        TypeDescriptor<T> supertypeDescriptor = type.getSupertype(supertype);
        TypeDescriptor<TypeVariableExtractor> extractorT = extractorSupertype.where(inputT, supertypeDescriptor.getType());
        Type outputT = ((ParameterizedType)extractorT.getType()).getActualTypeArguments()[1];
        return TypeDescriptor.of(outputT);
    }

    public static <InputT, OutputT> TypeDescriptor<InputT> inputOf(ProcessFunction<InputT, OutputT> fn) {
        return TypeDescriptors.extractFromTypeParameters(fn, ProcessFunction.class, new TypeVariableExtractor<ProcessFunction<InputT, OutputT>, InputT>(){});
    }

    public static <InputT, OutputT> TypeDescriptor<InputT> inputOf(SerializableFunction<InputT, OutputT> fn) {
        return TypeDescriptors.inputOf(fn);
    }

    public static <InputT, OutputT> TypeDescriptor<OutputT> outputOf(ProcessFunction<InputT, OutputT> fn) {
        return TypeDescriptors.extractFromTypeParameters(fn, ProcessFunction.class, new TypeVariableExtractor<ProcessFunction<InputT, OutputT>, OutputT>(){});
    }

    public static <InputT, OutputT> TypeDescriptor<OutputT> outputOf(SerializableFunction<InputT, OutputT> fn) {
        return TypeDescriptors.outputOf(fn);
    }

    public static <InputT, OutputT> TypeDescriptor<InputT> inputOf(Contextful.Fn<InputT, OutputT> fn) {
        return TypeDescriptors.extractFromTypeParameters(fn, Contextful.Fn.class, new TypeVariableExtractor<Contextful.Fn<InputT, OutputT>, InputT>(){});
    }

    public static <InputT, OutputT> TypeDescriptor<OutputT> outputOf(Contextful.Fn<InputT, OutputT> fn) {
        return TypeDescriptors.extractFromTypeParameters(fn, Contextful.Fn.class, new TypeVariableExtractor<Contextful.Fn<InputT, OutputT>, OutputT>(){});
    }

    public static interface TypeVariableExtractor<InputT, OutputT> {
    }
}

