/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.truncatetables;

import java.util.Arrays;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.apache.hop.workflow.actions.truncatetables.ActionTruncateTables;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ActionTruncateTablesDialog
extends ActionDialog
implements IActionDialog {
    private static final Class<?> PKG = ActionTruncateTables.class;
    private Shell shell;
    private Button wbTable;
    private Text wName;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private ActionTruncateTables action;
    private boolean changed;
    private Label wlFields;
    private TableView wFields;
    private Button wbdTablename;
    private Button wPrevious;

    public ActionTruncateTablesDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = (ActionTruncateTables)action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionTruncateTables.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        int nrRows;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionTruncateTables.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionTruncateTables.Name.Label", (String[])new String[0]));
        this.props.setLook((Control)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wName, this.action.getDatabase(), lsMod);
        Label wlPrevious = new Label((Composite)this.shell, 131072);
        wlPrevious.setText(BaseMessages.getString(PKG, (String)"ActionTruncateTables.Previous.Label", (String[])new String[0]));
        this.props.setLook((Control)wlPrevious);
        FormData fdlPrevious = new FormData();
        fdlPrevious.left = new FormAttachment(0, 0);
        fdlPrevious.top = new FormAttachment(this.wConnection, margin);
        fdlPrevious.right = new FormAttachment(middle, -margin);
        wlPrevious.setLayoutData((Object)fdlPrevious);
        this.wPrevious = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wPrevious);
        this.wPrevious.setToolTipText(BaseMessages.getString(PKG, (String)"ActionTruncateTables.Previous.Tooltip", (String[])new String[0]));
        FormData fdPrevious = new FormData();
        fdPrevious.left = new FormAttachment(middle, 0);
        fdPrevious.top = new FormAttachment((Control)wlPrevious, 0, 0x1000000);
        fdPrevious.right = new FormAttachment(100, 0);
        this.wPrevious.setLayoutData((Object)fdPrevious);
        this.wPrevious.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionTruncateTablesDialog.this.setPrevious();
                ActionTruncateTablesDialog.this.action.setChanged();
            }
        });
        this.wbTable = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbTable);
        this.wbTable.setText(BaseMessages.getString(PKG, (String)"ActionTruncateTables.GetTablenamesList.Auto", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.left = new FormAttachment(0, margin);
        fdbTable.right = new FormAttachment(100, -margin);
        fdbTable.top = new FormAttachment((Control)wlPrevious, 2 * margin);
        this.wbTable.setLayoutData((Object)fdbTable);
        this.wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionTruncateTablesDialog.this.getTableName();
            }
        });
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"ActionTruncateTables.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.right = new FormAttachment(middle, -margin);
        fdlFields.top = new FormAttachment((Control)this.wbTable, 2 * margin);
        this.wlFields.setLayoutData((Object)fdlFields);
        this.wbdTablename = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbdTablename);
        this.wbdTablename.setText(BaseMessages.getString(PKG, (String)"ActionTruncateTables.TableDelete.Button", (String[])new String[0]));
        this.wbdTablename.setToolTipText(BaseMessages.getString(PKG, (String)"ActionTruncateTables.TableDelete.Tooltip", (String[])new String[0]));
        FormData fdbdTablename = new FormData();
        fdbdTablename.right = new FormAttachment(100, 0);
        fdbdTablename.top = new FormAttachment((Control)this.wlFields, margin);
        this.wbdTablename.setLayoutData((Object)fdbdTablename);
        this.wbdTablename.addListener(13, e -> {
            int[] idx = this.wFields.getSelectionIndices();
            this.wFields.remove(idx);
            this.wFields.removeEmptyRows();
            this.wFields.setRowNums();
        });
        int nrFieldsRows = nrRows = this.action.getTableNames() == null ? 1 : this.action.getTableNames().length;
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionTruncateTables.Fields.Table.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionTruncateTables.Fields.Schema.Label", (String[])new String[0]), 1, false)};
        columns[0].setUsingVariables(true);
        columns[0].setToolTip(BaseMessages.getString(PKG, (String)"ActionTruncateTables.Fields.Table.Tooltip", (String[])new String[0]));
        columns[1].setUsingVariables(true);
        columns[1].setToolTip(BaseMessages.getString(PKG, (String)"ActionTruncateTables.Fields.Schema.Tooltip", (String[])new String[0]));
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, columns, nrFieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        fdFields.right = new FormAttachment((Control)this.wbdTablename, -margin);
        fdFields.bottom = new FormAttachment((Control)wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.wbdTablename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] idx = ActionTruncateTablesDialog.this.wFields.getSelectionIndices();
                ActionTruncateTablesDialog.this.wFields.remove(idx);
                ActionTruncateTablesDialog.this.wFields.removeEmptyRows();
                ActionTruncateTablesDialog.this.wFields.setRowNums();
            }
        });
        this.getData();
        this.setPrevious();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    private void setPrevious() {
        this.wlFields.setEnabled(!this.wPrevious.getSelection());
        this.wFields.setEnabled(!this.wPrevious.getSelection());
        this.wbdTablename.setEnabled(!this.wPrevious.getSelection());
        this.wbTable.setEnabled(!this.wPrevious.getSelection());
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        if (this.action.getDatabase() != null) {
            this.wConnection.setText(this.action.getDatabase().getName());
        }
        String[] tableNames = this.action.getTableNames();
        String[] schemaNames = this.action.getSchemaNames();
        if (tableNames != null) {
            for (int i = 0; i < tableNames.length; ++i) {
                TableItem ti = this.wFields.table.getItem(i);
                if (tableNames[i] != null) {
                    ti.setText(1, tableNames[i]);
                }
                if (schemaNames[i] == null) continue;
                ti.setText(2, schemaNames[i]);
            }
            this.wFields.removeEmptyRows();
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
        this.wPrevious.setSelection(this.action.isArgFromPrevious());
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setDatabase(this.getWorkflowMeta().findDatabase(this.wConnection.getText()));
        this.action.setArgFromPrevious(this.wPrevious.getSelection());
        int nrItems = this.wFields.nrNonEmpty();
        int nr = 0;
        for (int i = 0; i < nrItems; ++i) {
            String arg = this.wFields.getNonEmpty(i).getText(1);
            if (arg == null || arg.length() == 0) continue;
            ++nr;
        }
        String[] tables = new String[nr];
        String[] schemas = new String[nr];
        nr = 0;
        for (int i = 0; i < nrItems; ++i) {
            String arg = this.wFields.getNonEmpty(i).getText(1);
            String wild = this.wFields.getNonEmpty(i).getText(2);
            if (arg == null || arg.length() == 0) continue;
            tables[nr] = arg;
            schemas[nr] = wild;
            ++nr;
        }
        this.action.setTableNames(tables);
        this.action.setSchemaNames(schemas);
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTableName() {
        DatabaseMeta databaseMeta = this.getWorkflowMeta().findDatabase(this.wConnection.getText());
        if (databaseMeta != null) {
            Database database = new Database(loggingObject, this.variables, databaseMeta);
            try {
                database.connect();
                Object[] tableNames = database.getTablenames();
                Arrays.sort(tableNames);
                EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, (String[])tableNames, BaseMessages.getString(PKG, (String)"ActionTruncateTables.SelectTables.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionTruncateTables.SelectTables.Message", (String[])new String[0]));
                dialog.setMulti(true);
                dialog.setAvoidQuickSearch();
                if (dialog.open() != null) {
                    int[] idx = dialog.getSelectionIndeces();
                    for (int i = 0; i < idx.length; ++i) {
                        TableItem tableItem = new TableItem(this.wFields.table, 0);
                        tableItem.setText(1, (String)tableNames[idx[i]]);
                    }
                }
            }
            catch (HopDatabaseException e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionTruncateTables.ConnectionError.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
            }
            finally {
                database.disconnect();
            }
            this.wFields.removeEmptyRows();
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
    }
}

