/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.googledrive.ui;

import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.util.SwtSvgImageUtil;
import org.apache.hop.vfs.googledrive.util.CustomLocalServerReceiver;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GoogleAuthorizationDialog
extends Dialog {
    protected int width = 620;
    protected int height = 650;
    protected Browser browser;
    protected Shell dialog;
    protected Display display;
    private static final int OPTIONS = 67680;
    private static final Image LOGO = GuiResource.getInstance().getImageHopUi();
    private VerificationCodeReceiver receiver;

    public GoogleAuthorizationDialog(Shell shell, VerificationCodeReceiver receiver) {
        super(shell);
        this.receiver = receiver;
    }

    public void open(String url) {
        this.createDialog("Google Drive", url, 67680, LOGO);
        if (this.receiver != null) {
            ((CustomLocalServerReceiver)this.receiver).setUrl(url);
        }
        while (!this.dialog.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    private void createDialog(String title, String url, int options, Image logo) {
        Shell parent = this.getParent();
        this.display = parent.getDisplay();
        this.dialog = new Shell(parent, options);
        this.dialog.setText(title);
        this.dialog.setImage(logo);
        PropsUi props = PropsUi.getInstance();
        props.setLook((Control)this.dialog);
        this.dialog.setSize(this.width, this.height);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.dialog.setLayout((Layout)formLayout);
        try {
            Label helpButton = new Label((Composite)this.dialog, 0);
            helpButton.setImage(new Image((Device)this.display, GoogleAuthorizationDialog.class.getResourceAsStream("/images/help.png")));
            FormData helpButtonFormData = new FormData();
            helpButtonFormData.left = new FormAttachment(0, 15);
            helpButtonFormData.bottom = new FormAttachment(100, -24);
            helpButton.setLayoutData((Object)helpButtonFormData);
            Text helpLabel = new Text((Composite)this.dialog, 0);
            helpLabel.setText("Help");
            helpLabel.setEditable(false);
            props.setLook((Control)helpLabel);
            helpLabel.setFont(new Font((Device)this.display, "Open Sans Regular", 11, 0));
            helpLabel.setForeground(new Color((Device)this.display, props.contrastColor(0, 94, 170)));
            FormData helpLabelFormData = new FormData();
            helpLabelFormData.left = new FormAttachment(0, 40);
            helpLabelFormData.bottom = new FormAttachment(100, -27);
            helpLabel.setLayoutData((Object)helpLabelFormData);
            helpLabel.addListener(4, event -> {});
            helpLabel.addListener(6, event -> {
                helpLabel.setForeground(new Color((Device)this.display, PropsUi.getInstance().contrastColor(0, 0, 0)));
                helpLabel.setCursor(new Cursor((Device)this.display, 21));
            });
            helpLabel.addListener(7, event -> helpLabel.setForeground(new Color((Device)this.display, props.contrastColor(0, 94, 170))));
            final Label cancelButton = new Label((Composite)this.dialog, 0);
            Image closeImage = SwtSvgImageUtil.getImage((Display)this.display, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"/ui/images/close.svg", (int)16, (int)16);
            cancelButton.setImage(closeImage);
            FormData cancelButtonFormData = new FormData();
            cancelButtonFormData.right = new FormAttachment(100, -15);
            cancelButtonFormData.bottom = new FormAttachment(100, -15);
            cancelButton.setLayoutData((Object)cancelButtonFormData);
            cancelButton.addListener(4, event -> {
                this.browser.dispose();
                this.dialog.close();
                this.dialog.dispose();
            });
            cancelButton.addListener(6, new Listener(){

                public void handleEvent(Event event) {
                    Image closeImage = SwtSvgImageUtil.getImage((Display)GoogleAuthorizationDialog.this.display, (ClassLoader)this.getClass().getClassLoader(), (String)"/ui/images/close.svg", (int)16, (int)16);
                    cancelButton.setImage(new Image((Device)GoogleAuthorizationDialog.this.display, GoogleAuthorizationDialog.class.getResourceAsStream("/images/close-button-hover.png")));
                    cancelButton.setCursor(new Cursor((Device)GoogleAuthorizationDialog.this.display, 21));
                }
            });
            cancelButton.addListener(7, event -> cancelButton.setImage(new Image((Device)this.display, GoogleAuthorizationDialog.class.getResourceAsStream("/images/close-button.png"))));
            Label separator = new Label((Composite)this.dialog, 258);
            FormData separatorFormData = new FormData();
            separatorFormData.left = new FormAttachment(0, 15);
            separatorFormData.right = new FormAttachment(100, -15);
            separatorFormData.bottom = new FormAttachment((Control)cancelButton, -15);
            separator.setLayoutData((Object)separatorFormData);
            this.browser = new Browser((Composite)this.dialog, 0);
            this.browser.setUrl(url);
            FormData browserFormData = new FormData();
            browserFormData.top = new FormAttachment(0, 5);
            browserFormData.bottom = new FormAttachment((Control)separator, -5);
            browserFormData.left = new FormAttachment(0, 5);
            browserFormData.right = new FormAttachment(100, -5);
            this.browser.setLayoutData((Object)browserFormData);
            this.browser.addCloseWindowListener(event -> {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.close();
            });
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.dialog, 33);
            messageBox.setMessage("Browser cannot be initialized.");
            messageBox.setText("Exit");
            messageBox.open();
        }
        this.setPosition();
        this.dialog.open();
    }

    private void setPosition() {
        Rectangle shellBounds = this.getParent().getBounds();
        Point dialogSize = this.dialog.getSize();
        this.dialog.setLocation(shellBounds.x + (shellBounds.width - dialogSize.x) / 2, shellBounds.y + (shellBounds.height - dialogSize.y) / 2);
    }
}

