/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.HashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.trans.IndependentContext;
import net.sf.saxon.trans.XPathException;

public class ExecutableFunctionLibrary
implements FunctionLibrary {
    private Configuration config;
    private HashMap functions = new HashMap(20);

    public ExecutableFunctionLibrary(Configuration configuration) {
        this.config = configuration;
    }

    public void addFunction(UserFunction userFunction) {
        long l = (long)userFunction.getNumberOfArguments() << 32 | (long)(userFunction.getFunctionNameCode() & 0xFFFFF);
        this.functions.put(new Long(l), userFunction);
    }

    public boolean isAvailable(int n, String string, String string2, int n2) {
        if (n2 == -1) {
            for (int i = 0; i <= 20; ++i) {
                if (!this.isAvailable(n, string, string2, i)) continue;
                return true;
            }
            return false;
        }
        long l = (long)n2 << 32 | (long)n;
        return this.functions.get(new Long(l)) != null;
    }

    public Expression bind(int n, String string, String string2, Expression[] expressionArray) throws XPathException {
        long l = (long)expressionArray.length << 32 | (long)(n & 0xFFFFF);
        UserFunction userFunction = (UserFunction)this.functions.get(new Long(l));
        if (userFunction == null) {
            return null;
        }
        IndependentContext independentContext = new IndependentContext(this.config);
        UserFunctionCall userFunctionCall = new UserFunctionCall();
        userFunctionCall.setFunctionNameCode(n);
        userFunctionCall.setArguments(expressionArray);
        userFunctionCall.setFunction(userFunction, independentContext);
        userFunctionCall.checkFunctionCall(userFunction, independentContext);
        userFunctionCall.setStaticType(userFunction.getResultType());
        return userFunctionCall;
    }

    public FunctionLibrary copy() {
        ExecutableFunctionLibrary executableFunctionLibrary = new ExecutableFunctionLibrary(this.config);
        executableFunctionLibrary.functions = new HashMap(this.functions);
        return executableFunctionLibrary;
    }
}

