/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.tinytree.CharSlice;
import net.sf.saxon.tinytree.CompressedWhitespace;

public final class FastStringBuffer
implements CharSequence,
Serializable {
    private char[] array;
    private int used = 0;

    public FastStringBuffer(int n) {
        this.array = new char[n];
    }

    public void append(String string) {
        int n = string.length();
        this.ensureCapacity(n);
        string.getChars(0, n, this.array, this.used);
        this.used += n;
    }

    public void append(CharSlice charSlice) {
        int n = charSlice.length();
        this.ensureCapacity(n);
        charSlice.copyTo(this.array, this.used);
        this.used += n;
    }

    public void append(FastStringBuffer fastStringBuffer) {
        int n = fastStringBuffer.length();
        this.ensureCapacity(n);
        fastStringBuffer.getChars(0, n, this.array, this.used);
        this.used += n;
    }

    public void append(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        this.ensureCapacity(n);
        stringBuffer.getChars(0, n, this.array, this.used);
        this.used += n;
    }

    public void append(CharSequence charSequence) {
        int n = charSequence.length();
        this.ensureCapacity(n);
        if (charSequence instanceof CharSlice) {
            ((CharSlice)charSequence).copyTo(this.array, this.used);
        } else if (charSequence instanceof String) {
            ((String)charSequence).getChars(0, n, this.array, this.used);
        } else if (charSequence instanceof FastStringBuffer) {
            ((FastStringBuffer)charSequence).getChars(0, n, this.array, this.used);
        } else {
            if (charSequence instanceof CompressedWhitespace) {
                ((CompressedWhitespace)charSequence).uncompress(this);
                return;
            }
            ((Object)charSequence).toString().getChars(0, n, this.array, this.used);
        }
        this.used += n;
    }

    public void append(char[] cArray, int n, int n2) {
        this.ensureCapacity(n2);
        System.arraycopy(cArray, n, this.array, this.used, n2);
        this.used += n2;
    }

    public void append(char[] cArray) {
        int n = cArray.length;
        this.ensureCapacity(n);
        System.arraycopy(cArray, 0, this.array, this.used, n);
        this.used += n;
    }

    public void append(char c) {
        this.ensureCapacity(1);
        this.array[this.used++] = c;
    }

    public void appendWideChar(int n) {
        if (n > 65535) {
            this.append(XMLChar.highSurrogate(n));
            this.append(XMLChar.lowSurrogate(n));
        } else {
            this.append((char)n);
        }
    }

    public int length() {
        return this.used;
    }

    public char charAt(int n) {
        if (n >= this.used) {
            throw new IndexOutOfBoundsException("" + n);
        }
        return this.array[n];
    }

    public CharSequence subSequence(int n, int n2) {
        return new CharSlice(this.array, n, n2 - n);
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.used) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        System.arraycopy(this.array, n, cArray, n3, n2 - n);
    }

    public int indexOf(char c) {
        for (int i = 0; i < this.used; ++i) {
            if (this.array[i] != c) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        this.condense();
        return new String(this.array, 0, this.used);
    }

    public void setCharAt(int n, char c) {
        if (n < 0 || n > this.used) {
            throw new IndexOutOfBoundsException("" + n);
        }
        this.array[n] = c;
    }

    public void insertCharAt(int n, char c) {
        if (n < 0 || n > this.used) {
            throw new IndexOutOfBoundsException("" + n);
        }
        this.ensureCapacity(1);
        for (int i = this.used; i > n; --i) {
            this.array[i] = this.array[i - 1];
        }
        ++this.used;
        this.array[n] = c;
    }

    public void removeCharAt(int n) {
        if (n < 0 || n > this.used) {
            throw new IndexOutOfBoundsException("" + n);
        }
        --this.used;
        for (int i = n; i < this.used; ++i) {
            this.array[i] = this.array[i + 1];
        }
    }

    public void setLength(int n) {
        if (n < 0 || n > this.used) {
            return;
        }
        this.used = n;
    }

    public void ensureCapacity(int n) {
        if (this.used + n > this.array.length) {
            int n2 = this.array.length * 2;
            if (n2 < this.used + n) {
                n2 = this.used + n * 2;
            }
            char[] cArray = new char[n2];
            System.arraycopy(this.array, 0, cArray, 0, this.used);
            this.array = cArray;
        }
    }

    public CharSequence condense() {
        if (this.array.length - this.used > 256 || this.array.length > this.used * 2) {
            char[] cArray = new char[this.used];
            System.arraycopy(this.array, 0, cArray, 0, this.used);
            this.array = cArray;
        }
        return this;
    }

    public void write(Writer writer) throws IOException {
        writer.write(this.array, 0, this.used);
    }

    public static String diagnosticPrint(CharSequence charSequence) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length() * 2);
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c > ' ' && c < '\u007f') {
                fastStringBuffer.append(c);
                continue;
            }
            fastStringBuffer.append("\\u");
            for (int j = 12; j >= 0; j -= 4) {
                fastStringBuffer.append("0123456789abcdef".charAt(c >> j & 0xF));
            }
        }
        return fastStringBuffer.toString();
    }
}

