/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.FileStagingOptions;
import org.apache.beam.sdk.options.Hidden;
import org.checkerframework.checker.nullness.qual.Nullable;

@Description(value="Options that are used to configure the Dataflow pipeline worker pool.")
public interface DataflowPipelineWorkerPoolOptions
extends GcpOptions,
FileStagingOptions {
    @Description(value="Number of workers to use when executing the Dataflow job. Note that selection of an autoscaling algorithm other then \"NONE\" will affect the size of the worker pool. If left unspecified, the Dataflow service will determine the number of workers.")
    public int getNumWorkers();

    public void setNumWorkers(int var1);

    @Description(value="[Experimental] The autoscaling algorithm to use for the workerpool. NONE: does not change the size of the worker pool. BASIC (deprecated): autoscale the worker pool size up to maxNumWorkers until the job completes. THROUGHPUT_BASED: autoscale the workerpool based on throughput (up to maxNumWorkers).")
    @Experimental(value=Experimental.Kind.AUTOSCALING)
    public AutoscalingAlgorithmType getAutoscalingAlgorithm();

    public void setAutoscalingAlgorithm(AutoscalingAlgorithmType var1);

    @Description(value="The maximum number of workers to use for the workerpool. This options limits the size of the workerpool for the lifetime of the job, including pipeline updates. If left unspecified, the Dataflow service will compute a ceiling.")
    public int getMaxNumWorkers();

    public void setMaxNumWorkers(int var1);

    @Description(value="Remote worker disk size, in gigabytes, or 0 to use the default size.")
    public int getDiskSizeGb();

    public void setDiskSizeGb(int var1);

    @Description(value="Container image used to configure a Dataflow worker. Can only be used for official Dataflow container images. Prefer using sdkContainerImage instead.")
    @Deprecated
    @Hidden
    public String getWorkerHarnessContainerImage();

    @Deprecated
    @Hidden
    public void setWorkerHarnessContainerImage(String var1);

    @Description(value="Container image used to configure the SDK execution environment of pipeline code on a worker. For non-portable pipelines, can only be used for official Dataflow container images.")
    public String getSdkContainerImage();

    public void setSdkContainerImage(String var1);

    @Description(value="GCE network for launching workers. For more information, see the reference documentation https://cloud.google.com/compute/docs/networking. Default is up to the Dataflow service.")
    public String getNetwork();

    public void setNetwork(String var1);

    @Description(value="GCE subnetwork for launching workers. For more information, see the reference documentation https://cloud.google.com/compute/docs/networking. Default is up to the Dataflow service.")
    public String getSubnetwork();

    public void setSubnetwork(String var1);

    @Description(value="Machine type to create Dataflow worker VMs as. See https://cloud.google.com/compute/docs/machine-types for a list of valid options. If unset, the Dataflow service will choose a reasonable default.")
    public String getWorkerMachineType();

    public void setWorkerMachineType(String var1);

    @Description(value="Specifies what type of persistent disk is used. The value is a full URL of a disk type resource, e.g., compute.googleapis.com/projects//zones//diskTypes/pd-ssd. For more information, see the API reference documentation for DiskTypes: https://cloud.google.com/compute/docs/reference/latest/diskTypes")
    public String getWorkerDiskType();

    public void setWorkerDiskType(String var1);

    @Description(value="Specifies whether worker pools should be started with public IP addresses. WARNING:This feature is experimental. You must be allowlisted to use it.")
    @JsonIgnore
    @Experimental
    public @Nullable Boolean getUsePublicIps();

    public void setUsePublicIps(@Nullable Boolean var1);

    @Description(value="GCE minimum CPU platform. Default is determined by GCP.")
    public @Nullable String getMinCpuPlatform();

    public void setMinCpuPlatform(String var1);

    @Experimental(value=Experimental.Kind.AUTOSCALING)
    public static enum AutoscalingAlgorithmType {
        NONE("AUTOSCALING_ALGORITHM_NONE"),
        BASIC("AUTOSCALING_ALGORITHM_BASIC"),
        THROUGHPUT_BASED("AUTOSCALING_ALGORITHM_BASIC");

        private final String algorithm;

        private AutoscalingAlgorithmType(String algorithm) {
            this.algorithm = algorithm;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }
    }
}

