/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.shuffle.BlockFetchingListener;
import org.apache.spark.network.shuffle.ErrorHandler;
import org.apache.spark.network.shuffle.protocol.PushBlockStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneForOneBlockPusher {
    private static final Logger logger = LoggerFactory.getLogger(OneForOneBlockPusher.class);
    private static final ErrorHandler PUSH_ERROR_HANDLER = new ErrorHandler.BlockPushErrorHandler();
    public static final String SHUFFLE_PUSH_BLOCK_PREFIX = "shufflePush";
    private final TransportClient client;
    private final String appId;
    private final String[] blockIds;
    private final BlockFetchingListener listener;
    private final Map<String, ManagedBuffer> buffers;

    public OneForOneBlockPusher(TransportClient client, String appId, String[] blockIds, BlockFetchingListener listener, Map<String, ManagedBuffer> buffers) {
        this.client = client;
        this.appId = appId;
        this.blockIds = blockIds;
        this.listener = listener;
        this.buffers = buffers;
    }

    private void failRemainingBlocks(String[] failedBlockIds, Throwable e) {
        for (String blockId : failedBlockIds) {
            try {
                this.listener.onBlockFetchFailure(blockId, e);
            }
            catch (Exception e2) {
                logger.error("Error in block push failure callback", (Throwable)e2);
            }
        }
    }

    public void start() {
        logger.debug("Start pushing {} blocks", (Object)this.blockIds.length);
        for (int i = 0; i < this.blockIds.length; ++i) {
            assert (this.buffers.containsKey(this.blockIds[i])) : "Could not find the block buffer for block " + this.blockIds[i];
            String[] blockIdParts = this.blockIds[i].split("_");
            if (blockIdParts.length != 4 || !blockIdParts[0].equals(SHUFFLE_PUSH_BLOCK_PREFIX)) {
                throw new IllegalArgumentException("Unexpected shuffle push block id format: " + this.blockIds[i]);
            }
            ByteBuffer header = new PushBlockStream(this.appId, Integer.parseInt(blockIdParts[1]), Integer.parseInt(blockIdParts[2]), Integer.parseInt(blockIdParts[3]), i).toByteBuffer();
            this.client.uploadStream((ManagedBuffer)new NioManagedBuffer(header), this.buffers.get(this.blockIds[i]), (RpcResponseCallback)new BlockPushCallback(i, this.blockIds[i]));
        }
    }

    private class BlockPushCallback
    implements RpcResponseCallback {
        private int index;
        private String blockId;

        BlockPushCallback(int index, String blockId) {
            this.index = index;
            this.blockId = blockId;
        }

        public void onSuccess(ByteBuffer response) {
            OneForOneBlockPusher.this.listener.onBlockFetchSuccess(this.blockId, (ManagedBuffer)new NioManagedBuffer(ByteBuffer.allocate(0)));
        }

        public void onFailure(Throwable e) {
            if (PUSH_ERROR_HANDLER.shouldRetryError(e)) {
                String[] targetBlockId = Arrays.copyOfRange(OneForOneBlockPusher.this.blockIds, this.index, this.index + 1);
                OneForOneBlockPusher.this.failRemainingBlocks(targetBlockId, e);
            } else {
                String[] targetBlockId = Arrays.copyOfRange(OneForOneBlockPusher.this.blockIds, this.index, OneForOneBlockPusher.this.blockIds.length);
                OneForOneBlockPusher.this.failRemainingBlocks(targetBlockId, e);
            }
        }
    }
}

