/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.messages;

import java.io.IOException;
import org.apache.flink.runtime.rpc.messages.Message;

public interface RpcInvocation
extends Message {
    public String getMethodName() throws IOException, ClassNotFoundException;

    public Class<?>[] getParameterTypes() throws IOException, ClassNotFoundException;

    public Object[] getArgs() throws IOException, ClassNotFoundException;

    public static String convertRpcToString(String declaringClassName, String methodName, Class<?>[] parameterTypes) {
        StringBuilder paramTypeStringBuilder = new StringBuilder(parameterTypes.length * 5);
        if (parameterTypes.length > 0) {
            paramTypeStringBuilder.append(parameterTypes[0].getSimpleName());
            for (int i = 1; i < parameterTypes.length; ++i) {
                paramTypeStringBuilder.append(", ").append(parameterTypes[i].getSimpleName());
            }
        }
        return declaringClassName + '.' + methodName + '(' + paramTypeStringBuilder + ')';
    }
}

