/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.getxmldata;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.IRunnableWithProgress;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.xml.Dom4JUtil;
import org.apache.hop.pipeline.transforms.xml.getxmldata.GetXmlDataField;
import org.apache.hop.pipeline.transforms.xml.getxmldata.GetXmlDataMeta;
import org.apache.hop.pipeline.transforms.xml.getxmldata.IgnoreDtdEntityResolver;
import org.apache.hop.pipeline.transforms.xml.getxmldata.PdOption;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.ProgressMonitorDialog;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.EntityResolver;

public class XmlInputFieldsImportProgressDialog {
    private static final Class<?> PKG = GetXmlDataMeta.class;
    private static final String VALUE_NAME = "Name";
    private static final String VALUE_PATH = "Path";
    private static final String VALUE_ELEMENT = "Element";
    private static final String VALUE_RESULT = "result";
    private static final String VALUE_TYPE = "Type";
    private static final String VALUE_FORMAT = "Format";
    private Shell shell;
    private String filename;
    private String encoding;
    private int nr;
    private String loopXPath;
    private HashSet<String> list;
    private List<RowMetaAndData> fieldsList;
    private RowMetaAndData[] fields;
    private String xml;
    private String url;
    private PdOption option;

    public XmlInputFieldsImportProgressDialog(Shell shell, String xmlSource, String loopXPath, PdOption option) {
        this.shell = shell;
        this.option = option;
        this.loopXPath = loopXPath;
        if (option.isXmlSourceIsFile()) {
            this.filename = xmlSource;
            this.xml = null;
            this.url = null;
        } else if (option.isUseUrl()) {
            this.filename = null;
            this.xml = null;
            this.url = xmlSource;
        } else {
            this.filename = null;
            this.xml = xmlSource;
            this.url = null;
        }
        this.encoding = option.getEncoding();
        this.nr = 0;
        this.list = new HashSet();
        this.fieldsList = new ArrayList<RowMetaAndData>();
        this.fields = null;
    }

    public RowMetaAndData[] open() {
        IRunnableWithProgress op = monitor -> {
            try {
                this.fields = this.doScan(monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InvocationTargetException(e, BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Exception.ErrorScanningFile", (String[])new String[]{this.filename, e.toString()}));
            }
        };
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            pmd.run(true, op);
        }
        catch (InterruptedException | InvocationTargetException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.ErrorScanningFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.ErrorScanningFile.Message", (String[])new String[0]), e);
        }
        return this.fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RowMetaAndData[] doScan(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.ScanningFile", (String[])new String[]{this.filename}), 1);
        SAXReader reader = Dom4JUtil.getSAXReader();
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return null;
        }
        if (this.option.isValidating()) {
            reader.setValidation(true);
            reader.setFeature("http://apache.org/xml/features/validation/schema", true);
        } else {
            reader.setEntityResolver((EntityResolver)new IgnoreDtdEntityResolver());
        }
        monitor.worked(1);
        monitor.beginTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.ReadingDocument", (String[])new String[0]), 1);
        if (monitor.isCanceled()) {
            return null;
        }
        InputStream is = null;
        try {
            Document document = null;
            if (!Utils.isEmpty((CharSequence)this.filename)) {
                is = HopVfs.getInputStream((String)this.filename);
                document = reader.read(is, this.encoding);
            } else {
                document = !Utils.isEmpty((CharSequence)this.xml) ? reader.read((Reader)new StringReader(this.xml)) : reader.read(new URL(this.url));
            }
            monitor.worked(1);
            monitor.beginTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.DocumentOpened", (String[])new String[0]), 1);
            monitor.worked(1);
            monitor.beginTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.ReadingNode", (String[])new String[0]), 1);
            if (monitor.isCanceled()) {
                RowMetaAndData[] rowMetaAndDataArray = null;
                return rowMetaAndDataArray;
            }
            List nodes = document.selectNodes(this.loopXPath);
            monitor.worked(1);
            monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.FetchNodes", (String[])new String[0]));
            if (monitor.isCanceled()) {
                RowMetaAndData[] rowMetaAndDataArray = null;
                return rowMetaAndDataArray;
            }
            for (Node node : nodes) {
                if (monitor.isCanceled()) {
                    RowMetaAndData[] rowMetaAndDataArray = null;
                    return rowMetaAndDataArray;
                }
                ++this.nr;
                monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.FetchNodes", (String[])new String[]{String.valueOf(this.nr)}));
                monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.FetchNodes", (String[])new String[]{node.getPath()}));
                this.setNodeField(node, monitor);
                this.childNode(node, monitor);
            }
            monitor.worked(1);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        RowMetaAndData[] listFields = this.fieldsList.toArray(new RowMetaAndData[this.fieldsList.size()]);
        monitor.setTaskName(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.NodesReturned", (String[])new String[0]));
        monitor.done();
        return listFields;
    }

    private void setNodeField(Node node, IProgressMonitor monitor) {
        Element e = (Element)node;
        List lista = e.attributes();
        for (Attribute attribute : lista) {
            this.setAttributeField(attribute, monitor);
        }
        String nodename = node.getName();
        String nodenametxt = this.cleanString(node.getPath());
        if (!Utils.isEmpty((CharSequence)nodenametxt) && !this.list.contains(nodenametxt)) {
            ++this.nr;
            monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDataXMLInputFieldsImportProgressDialog.Task.FetchFields", (String[])new String[]{String.valueOf(this.nr)}));
            monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDataXMLInputFieldsImportProgressDialog.Task.AddingField", (String[])new String[]{nodename}));
            RowMetaAndData row = new RowMetaAndData();
            row.addValue(VALUE_NAME, 2, (Object)nodename);
            row.addValue(VALUE_PATH, 2, (Object)nodenametxt);
            row.addValue(VALUE_ELEMENT, 2, (Object)GetXmlDataField.ElementTypeDesc[0]);
            row.addValue(VALUE_RESULT, 2, (Object)GetXmlDataField.ResultTypeDesc[0]);
            String valueNode = node.getText();
            if (this.isDate(valueNode)) {
                row.addValue(VALUE_TYPE, 2, (Object)"Date");
                row.addValue(VALUE_FORMAT, 2, (Object)"yyyy/MM/dd");
            } else if (this.isInteger(valueNode)) {
                row.addValue(VALUE_TYPE, 2, (Object)"Integer");
                row.addValue(VALUE_FORMAT, 2, null);
            } else if (this.isNumber(valueNode)) {
                row.addValue(VALUE_TYPE, 2, (Object)"Number");
                row.addValue(VALUE_FORMAT, 2, null);
            } else {
                row.addValue(VALUE_TYPE, 2, (Object)"String");
                row.addValue(VALUE_FORMAT, 2, null);
            }
            this.fieldsList.add(row);
            this.list.add(nodenametxt);
        }
    }

    private void setAttributeField(Attribute attribute, IProgressMonitor monitor) {
        String attributname = attribute.getName();
        String attributnametxt = this.cleanString(attribute.getPath());
        if (!Utils.isEmpty((CharSequence)attributnametxt) && !this.list.contains(attribute.getPath())) {
            ++this.nr;
            monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDataXMLInputFieldsImportProgressDialog.Task.FetchFields", (String[])new String[]{String.valueOf(this.nr)}));
            monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDataXMLInputFieldsImportProgressDialog.Task.AddingField", (String[])new String[]{attributname}));
            RowMetaAndData row = new RowMetaAndData();
            row.addValue(VALUE_NAME, 2, (Object)attributname);
            row.addValue(VALUE_PATH, 2, (Object)attributnametxt);
            row.addValue(VALUE_ELEMENT, 2, (Object)GetXmlDataField.ElementTypeDesc[1]);
            row.addValue(VALUE_RESULT, 2, (Object)GetXmlDataField.ResultTypeDesc[0]);
            String valueAttr = attribute.getText();
            if (this.isDate(valueAttr)) {
                row.addValue(VALUE_TYPE, 2, (Object)"Date");
                row.addValue(VALUE_FORMAT, 2, (Object)"yyyy/MM/dd");
            } else if (this.isInteger(valueAttr)) {
                row.addValue(VALUE_TYPE, 2, (Object)"Integer");
                row.addValue(VALUE_FORMAT, 2, null);
            } else if (this.isNumber(valueAttr)) {
                row.addValue(VALUE_TYPE, 2, (Object)"Number");
                row.addValue(VALUE_FORMAT, 2, null);
            } else {
                row.addValue(VALUE_TYPE, 2, (Object)"String");
                row.addValue(VALUE_FORMAT, 2, null);
            }
            this.list.add(attribute.getPath());
        }
    }

    private String cleanString(String inputstring) {
        String retval = inputstring;
        retval = retval.replace(this.loopXPath, "");
        while (retval.startsWith("/")) {
            retval = retval.substring(1, retval.length());
        }
        return retval;
    }

    private boolean isDate(String str) {
        try {
            SimpleDateFormat fdate = new SimpleDateFormat("yyyy/MM/dd");
            fdate.setLenient(false);
            fdate.parse(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private boolean isNumber(String str) {
        try {
            Float.parseFloat(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean childNode(Node node, IProgressMonitor monitor) {
        boolean rc = false;
        Element ce = (Element)node;
        for (int j = 0; j < ce.nodeCount(); ++j) {
            Node cnode = ce.node(j);
            if (Utils.isEmpty((CharSequence)cnode.getName())) continue;
            Element cce = (Element)cnode;
            if (cce.nodeCount() > 1) {
                if (this.childNode(cnode, monitor)) continue;
                this.setNodeField(cnode, monitor);
                rc = true;
                continue;
            }
            this.setNodeField(cnode, monitor);
            rc = true;
        }
        return rc;
    }
}

