/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.update;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.DbCache;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.update.UpdateField;
import org.apache.hop.pipeline.transforms.update.UpdateKeyField;
import org.apache.hop.pipeline.transforms.update.UpdateMeta;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.database.dialog.SqlEditor;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class UpdateDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = UpdateMeta.class;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private TableView wKey;
    private TextVar wSchema;
    private TextVar wTable;
    private TableView wReturn;
    private TextVar wCommit;
    private Button wBatch;
    private Label wlErrorIgnored;
    private Button wErrorIgnored;
    private Label wlIgnoreFlagField;
    private Text wIgnoreFlagField;
    private final UpdateMeta input;
    private ColumnInfo[] ciKey;
    private ColumnInfo[] ciReturn;
    private final Map<String, Integer> inputFields;
    private Button wSkipLookup;
    private final List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();

    public UpdateDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.input = (UpdateMeta)((Object)in);
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        ModifyListener lsTableMod = arg0 -> {
            this.input.setChanged();
            this.setTableFieldCombo();
        };
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateDialog.this.input.setChanged();
                UpdateDialog.this.setTableFieldCombo();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        DatabaseMeta dbm = this.pipelineMeta.findDatabase(this.input.getConnection(), this.variables);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wTransformName, dbm, lsMod);
        this.wConnection.addSelectionListener((SelectionListener)lsSelection);
        Label wlSchema = new Label((Composite)this.shell, 131072);
        wlSchema.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.TargetSchema.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSchema);
        FormData fdlSchema = new FormData();
        fdlSchema.left = new FormAttachment(0, 0);
        fdlSchema.right = new FormAttachment(middle, -margin);
        fdlSchema.top = new FormAttachment(this.wConnection, margin * 2);
        wlSchema.setLayoutData((Object)fdlSchema);
        Button wbSchema = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)wbSchema);
        wbSchema.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbSchema = new FormData();
        fdbSchema.top = new FormAttachment(this.wConnection, 2 * margin);
        fdbSchema.right = new FormAttachment(100, 0);
        wbSchema.setLayoutData((Object)fdbSchema);
        this.wSchema = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSchema);
        this.wSchema.addModifyListener(lsTableMod);
        FormData fdSchema = new FormData();
        fdSchema.left = new FormAttachment(middle, 0);
        fdSchema.top = new FormAttachment(this.wConnection, margin * 2);
        fdSchema.right = new FormAttachment((Control)wbSchema, -margin);
        this.wSchema.setLayoutData((Object)fdSchema);
        Label wlTable = new Label((Composite)this.shell, 131072);
        wlTable.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.TargetTable.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTable);
        FormData fdlTable = new FormData();
        fdlTable.left = new FormAttachment(0, 0);
        fdlTable.right = new FormAttachment(middle, -margin);
        fdlTable.top = new FormAttachment((Control)wbSchema, margin);
        wlTable.setLayoutData((Object)fdlTable);
        Button wbTable = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)wbTable);
        wbTable.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.Browse.Button", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)wbSchema, margin);
        wbTable.setLayoutData((Object)fdbTable);
        this.wTable = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTable);
        this.wTable.addModifyListener(lsTableMod);
        FormData fdTable = new FormData();
        fdTable.left = new FormAttachment(middle, 0);
        fdTable.top = new FormAttachment((Control)wbSchema, margin);
        fdTable.right = new FormAttachment((Control)wbTable, -margin);
        this.wTable.setLayoutData((Object)fdTable);
        Label wlCommit = new Label((Composite)this.shell, 131072);
        wlCommit.setText(BaseMessages.getString(PKG, (String)"UpdateDialog..Commit.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCommit);
        FormData fdlCommit = new FormData();
        fdlCommit.left = new FormAttachment(0, 0);
        fdlCommit.top = new FormAttachment((Control)this.wTable, margin);
        fdlCommit.right = new FormAttachment(middle, -margin);
        wlCommit.setLayoutData((Object)fdlCommit);
        this.wCommit = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wCommit);
        this.wCommit.addModifyListener(lsMod);
        FormData fdCommit = new FormData();
        fdCommit.left = new FormAttachment(middle, 0);
        fdCommit.top = new FormAttachment((Control)this.wTable, margin);
        fdCommit.right = new FormAttachment(100, 0);
        this.wCommit.setLayoutData((Object)fdCommit);
        Label wlBatch = new Label((Composite)this.shell, 131072);
        wlBatch.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.Batch.Label", (String[])new String[0]));
        this.props.setLook((Control)wlBatch);
        FormData fdlBatch = new FormData();
        fdlBatch.left = new FormAttachment(0, 0);
        fdlBatch.top = new FormAttachment((Control)this.wCommit, margin);
        fdlBatch.right = new FormAttachment(middle, -margin);
        wlBatch.setLayoutData((Object)fdlBatch);
        this.wBatch = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wBatch);
        FormData fdBatch = new FormData();
        fdBatch.left = new FormAttachment(middle, 0);
        fdBatch.top = new FormAttachment((Control)wlBatch, 0, 0x1000000);
        fdBatch.right = new FormAttachment(100, 0);
        this.wBatch.setLayoutData((Object)fdBatch);
        this.wBatch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                UpdateDialog.this.setFlags();
                UpdateDialog.this.input.setChanged();
            }
        });
        Label wlSkipLookup = new Label((Composite)this.shell, 131072);
        wlSkipLookup.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.SkipLookup.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSkipLookup);
        FormData fdlSkipLookup = new FormData();
        fdlSkipLookup.left = new FormAttachment(0, 0);
        fdlSkipLookup.top = new FormAttachment((Control)this.wBatch, margin);
        fdlSkipLookup.right = new FormAttachment(middle, -margin);
        wlSkipLookup.setLayoutData((Object)fdlSkipLookup);
        this.wSkipLookup = new Button((Composite)this.shell, 32);
        this.wSkipLookup.setToolTipText(BaseMessages.getString(PKG, (String)"UpdateDialog.SkipLookup.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wSkipLookup);
        FormData fdSkipLookup = new FormData();
        fdSkipLookup.left = new FormAttachment(middle, 0);
        fdSkipLookup.top = new FormAttachment((Control)wlSkipLookup, 0, 0x1000000);
        fdSkipLookup.right = new FormAttachment(100, 0);
        this.wSkipLookup.setLayoutData((Object)fdSkipLookup);
        this.wSkipLookup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateDialog.this.input.setChanged();
                UpdateDialog.this.setActiveIgnoreLookup();
            }
        });
        this.wlErrorIgnored = new Label((Composite)this.shell, 131072);
        this.wlErrorIgnored.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.ErrorIgnored.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlErrorIgnored);
        FormData fdlErrorIgnored = new FormData();
        fdlErrorIgnored.left = new FormAttachment(0, 0);
        fdlErrorIgnored.top = new FormAttachment((Control)this.wSkipLookup, margin);
        fdlErrorIgnored.right = new FormAttachment(middle, -margin);
        this.wlErrorIgnored.setLayoutData((Object)fdlErrorIgnored);
        this.wErrorIgnored = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wErrorIgnored);
        this.wErrorIgnored.setToolTipText(BaseMessages.getString(PKG, (String)"UpdateDialog.ErrorIgnored.ToolTip", (String[])new String[0]));
        FormData fdErrorIgnored = new FormData();
        fdErrorIgnored.left = new FormAttachment(middle, 0);
        fdErrorIgnored.top = new FormAttachment((Control)this.wlErrorIgnored, 0, 0x1000000);
        this.wErrorIgnored.setLayoutData((Object)fdErrorIgnored);
        this.wErrorIgnored.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateDialog.this.input.setChanged();
                UpdateDialog.this.setFlags();
            }
        });
        this.wlIgnoreFlagField = new Label((Composite)this.shell, 16384);
        this.wlIgnoreFlagField.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.FlagField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlIgnoreFlagField);
        FormData fdlIgnoreFlagField = new FormData();
        fdlIgnoreFlagField.left = new FormAttachment((Control)this.wErrorIgnored, margin);
        fdlIgnoreFlagField.top = new FormAttachment((Control)this.wSkipLookup, margin);
        this.wlIgnoreFlagField.setLayoutData((Object)fdlIgnoreFlagField);
        this.wIgnoreFlagField = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wIgnoreFlagField);
        this.wIgnoreFlagField.addModifyListener(lsMod);
        FormData fdIgnoreFlagField = new FormData();
        fdIgnoreFlagField.left = new FormAttachment((Control)this.wlIgnoreFlagField, margin);
        fdIgnoreFlagField.top = new FormAttachment((Control)this.wSkipLookup, margin);
        fdIgnoreFlagField.right = new FormAttachment(100, 0);
        this.wIgnoreFlagField.setLayoutData((Object)fdIgnoreFlagField);
        Label wlKey = new Label((Composite)this.shell, 0);
        wlKey.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.Key.Label", (String[])new String[0]));
        this.props.setLook((Control)wlKey);
        FormData fdlKey = new FormData();
        fdlKey.left = new FormAttachment(0, 0);
        fdlKey.top = new FormAttachment((Control)this.wIgnoreFlagField, margin);
        wlKey.setLayoutData((Object)fdlKey);
        int nrKeyCols = 4;
        int nrKeyRows = this.input.getLookupField().getLookupKeys() != null ? this.input.getLookupField().getLookupKeys().size() : 1;
        this.ciKey = new ColumnInfo[nrKeyCols];
        this.ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"UpdateDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciKey[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"UpdateDialog.ColumnInfo.Comparator", (String[])new String[0]), 2, new String[]{"=", "= ~NULL", "<>", "<", "<=", ">", ">=", "LIKE", "BETWEEN", "IS NULL", "IS NOT NULL"});
        this.ciKey[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"UpdateDialog.ColumnInfo.StreamField1", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciKey[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"UpdateDialog.ColumnInfo.StreamField2", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(this.ciKey[0]);
        this.wKey = new TableView(this.variables, (Composite)this.shell, 68354, this.ciKey, nrKeyRows, lsMod, this.props);
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.GetFields.Button", (String[])new String[0]));
        this.fdGet = new FormData();
        this.fdGet.right = new FormAttachment(100, 0);
        this.fdGet.top = new FormAttachment((Control)wlKey, margin);
        this.wGet.setLayoutData((Object)this.fdGet);
        FormData fdKey = new FormData();
        fdKey.left = new FormAttachment(0, 0);
        fdKey.top = new FormAttachment((Control)wlKey, margin);
        fdKey.right = new FormAttachment((Control)this.wGet, -margin);
        fdKey.bottom = new FormAttachment((Control)wlKey, 190);
        this.wKey.setLayoutData((Object)fdKey);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wSql = new Button((Composite)this.shell, 8);
        this.wSql.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.SQL.Button", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wSql, this.wCancel}, margin, null);
        Label wlReturn = new Label((Composite)this.shell, 0);
        wlReturn.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.Return.Label", (String[])new String[0]));
        this.props.setLook((Control)wlReturn);
        FormData fdlReturn = new FormData();
        fdlReturn.left = new FormAttachment(0, 0);
        fdlReturn.top = new FormAttachment((Control)this.wKey, margin);
        wlReturn.setLayoutData((Object)fdlReturn);
        int upInsCols = 2;
        int upInsRows = this.input.getLookupField().getUpdateFields() != null ? this.input.getLookupField().getUpdateFields().size() : 1;
        this.ciReturn = new ColumnInfo[upInsCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"UpdateDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"UpdateDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(this.ciReturn[0]);
        this.wReturn = new TableView(this.variables, (Composite)this.shell, 68354, this.ciReturn, upInsRows, lsMod, this.props);
        Button wGetLU = new Button((Composite)this.shell, 8);
        wGetLU.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.GetAndUpdateFields", (String[])new String[0]));
        FormData fdGetLU = new FormData();
        fdGetLU.top = new FormAttachment((Control)wlReturn, margin);
        fdGetLU.right = new FormAttachment(100, 0);
        wGetLU.setLayoutData((Object)fdGetLU);
        FormData fdReturn = new FormData();
        fdReturn.left = new FormAttachment(0, 0);
        fdReturn.top = new FormAttachment((Control)wlReturn, margin);
        fdReturn.right = new FormAttachment((Control)wGetLU, -margin);
        fdReturn.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wReturn.setLayoutData((Object)fdReturn);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.put(row.getValueMeta(i).getName(), i);
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.wOk.addListener(13, e -> this.ok());
        this.wGet.addListener(13, e -> this.get());
        wGetLU.addListener(13, e -> this.getUpdate());
        this.wSql.addListener(13, e -> this.create());
        this.wCancel.addListener(13, e -> this.cancel());
        wbSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateDialog.this.getSchemaNames();
            }
        });
        wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateDialog.this.getTableName();
            }
        });
        this.getData();
        this.setActiveIgnoreLookup();
        this.setTableFieldCombo();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void setActiveIgnoreLookup() {
        if (this.wSkipLookup.getSelection()) {
            this.wErrorIgnored.setSelection(false);
            this.wIgnoreFlagField.setText("");
        }
        this.wErrorIgnored.setEnabled(!this.wSkipLookup.getSelection());
        this.wlErrorIgnored.setEnabled(!this.wSkipLookup.getSelection());
        this.wlIgnoreFlagField.setEnabled(!this.wSkipLookup.getSelection() && this.wErrorIgnored.getSelection());
        this.wIgnoreFlagField.setEnabled(!this.wSkipLookup.getSelection() && this.wErrorIgnored.getSelection());
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciKey[2].setComboValues(fieldNames);
        this.ciKey[3].setComboValues(fieldNames);
        this.ciReturn[1].setComboValues(fieldNames);
    }

    public void setFlags() {
        this.wlIgnoreFlagField.setEnabled(this.wErrorIgnored.getSelection());
        this.wIgnoreFlagField.setEnabled(this.wErrorIgnored.getSelection());
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        boolean hasErrorHandling = this.pipelineMeta.findTransform(this.transformName).isDoingErrorHandling();
        boolean enableBatch = this.wBatch.getSelection();
        enableBatch = enableBatch && (databaseMeta == null || !databaseMeta.supportsErrorHandlingOnBatchUpdates() || !hasErrorHandling);
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = () -> {
            if (!(this.wTable.isDisposed() || this.wConnection.isDisposed() || this.wSchema.isDisposed())) {
                DatabaseMeta databaseMeta;
                String tableName = this.wTable.getText();
                String connectionName = this.wConnection.getText();
                String schemaName = this.wSchema.getText();
                for (ColumnInfo colInfo : this.tableFieldColumns) {
                    colInfo.setComboValues(new String[0]);
                }
                if (!Utils.isEmpty((CharSequence)tableName) && (databaseMeta = this.pipelineMeta.findDatabase(connectionName, this.variables)) != null) {
                    Database db = new Database(loggingObject, this.variables, databaseMeta);
                    try {
                        String[] fieldNames;
                        db.connect();
                        IRowMeta r = db.getTableFieldsMeta(this.variables.resolve(schemaName), this.variables.resolve(tableName));
                        if (null != r && null != (fieldNames = r.getFieldNames())) {
                            for (ColumnInfo colInfo : this.tableFieldColumns) {
                                colInfo.setComboValues(fieldNames);
                            }
                        }
                    }
                    catch (Exception e) {
                        for (ColumnInfo colInfo : this.tableFieldColumns) {
                            colInfo.setComboValues(new String[0]);
                        }
                    }
                    finally {
                        try {
                            if (db != null) {
                                db.disconnect();
                            }
                        }
                        catch (Exception ignored) {
                            db = null;
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    public void getData() {
        TableItem item;
        int i;
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"UpdateDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        this.wCommit.setText(this.input.getCommitSizeVar());
        this.wBatch.setSelection(this.input.isUseBatchUpdate());
        this.wSkipLookup.setSelection(this.input.isSkipLookup());
        this.wErrorIgnored.setSelection(this.input.isErrorIgnored());
        if (this.input.getIgnoreFlagField() != null) {
            this.wIgnoreFlagField.setText(this.input.getIgnoreFlagField());
        }
        this.wKey.table.clearAll();
        if (this.input.getLookupField().getLookupKeys() != null && this.input.getLookupField().getLookupKeys().size() > 0) {
            for (i = 0; i < this.input.getLookupField().getLookupKeys().size(); ++i) {
                UpdateKeyField keyField = this.input.getLookupField().getLookupKeys().get(i);
                item = this.wKey.table.getItem(i);
                if (keyField.getKeyLookup() != null) {
                    item.setText(1, keyField.getKeyLookup());
                }
                if (keyField.getKeyCondition() != null) {
                    item.setText(2, keyField.getKeyCondition());
                }
                if (keyField.getKeyStream() != null) {
                    item.setText(3, keyField.getKeyStream());
                }
                if (keyField.getKeyStream2() == null) continue;
                item.setText(4, keyField.getKeyStream2());
            }
        }
        if (this.input.getLookupField().getUpdateFields() != null && this.input.getLookupField().getUpdateFields().size() > 0) {
            this.wReturn.table.clearAll();
            for (i = 0; i < this.input.getLookupField().getUpdateFields().size(); ++i) {
                UpdateField fieldItem = this.input.getLookupField().getUpdateFields().get(i);
                item = this.wReturn.table.getItem(i);
                if (fieldItem.getUpdateLookup() != null) {
                    item.setText(1, fieldItem.getUpdateLookup());
                }
                if (fieldItem.getUpdateStream() == null) continue;
                item.setText(2, fieldItem.getUpdateStream());
            }
        }
        if (this.input.getLookupField().getSchemaName() != null) {
            this.wSchema.setText(this.input.getLookupField().getSchemaName());
        }
        if (this.input.getLookupField().getTableName() != null) {
            this.wTable.setText(this.input.getLookupField().getTableName());
        }
        if (this.input.getConnection() != null) {
            this.wConnection.setText(this.input.getConnection());
        }
        this.wKey.setRowNums();
        this.wKey.optWidth(true);
        this.wReturn.setRowNums();
        this.wReturn.optWidth(true);
        this.setFlags();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(UpdateMeta inf) {
        TableItem item;
        int i;
        int nrkeys = this.wKey.nrNonEmpty();
        int nrFields = this.wReturn.nrNonEmpty();
        inf.setConnection(this.wConnection.getText());
        inf.setCommitSize(this.wCommit.getText());
        inf.setUseBatchUpdate(this.wBatch.getSelection());
        inf.setSkipLookup(this.wSkipLookup.getSelection());
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"UpdateDialog.Log.FoundKeys", (String[])new String[]{"" + nrkeys}));
        }
        inf.getLookupField().getLookupKeys().clear();
        for (i = 0; i < nrkeys; ++i) {
            item = this.wKey.getNonEmpty(i);
            UpdateKeyField keyItem = new UpdateKeyField(item.getText(3), item.getText(1), item.getText(2), item.getText(4));
            inf.getLookupField().getLookupKeys().add(keyItem);
        }
        this.logDebug(BaseMessages.getString(PKG, (String)"UpdateDialog.Log.FoundFields", (String[])new String[]{"" + nrFields}));
        inf.getLookupField().getUpdateFields().clear();
        for (i = 0; i < nrFields; ++i) {
            item = this.wReturn.getNonEmpty(i);
            UpdateField fieldItem = new UpdateField(item.getText(1), item.getText(2));
            inf.getLookupField().getUpdateFields().add(fieldItem);
        }
        inf.getLookupField().setSchemaName(this.wSchema.getText());
        inf.getLookupField().setTableName(this.wTable.getText());
        inf.setErrorIgnored(this.wErrorIgnored.getSelection());
        inf.setIgnoreFlagField(this.wIgnoreFlagField.getText());
        this.transformName = this.wTransformName.getText();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.input.getConnection(), this.variables);
        if (databaseMeta == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"UpdateDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
            return;
        }
        this.dispose();
    }

    private void getTableName() {
        String connectionName = this.wConnection.getText();
        if (StringUtils.isEmpty((String)connectionName)) {
            return;
        }
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(connectionName, this.variables);
        if (databaseMeta != null) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"UpdateDialog.Log.LookingAtConnection", (String[])new String[0]) + databaseMeta.toString());
            }
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, databaseMeta, this.pipelineMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
                this.setTableFieldCombo();
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"UpdateDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                ITableItemInsertListener listener = (tableItem, v) -> {
                    tableItem.setText(2, "=");
                    return true;
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wKey, (int)1, (int[])new int[]{1, 3}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"UpdateDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"UpdateDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getUpdate() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wReturn, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"UpdateDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"UpdateDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void create() {
        try {
            DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.input.getConnection(), this.variables);
            UpdateMeta info = new UpdateMeta();
            this.getInfo(info);
            String name = this.transformName;
            TransformMeta transforminfo = new TransformMeta(BaseMessages.getString(PKG, (String)"UpdateDialog.TransformMeta.Title", (String[])new String[0]), name, (ITransformMeta)info);
            IRowMeta prev = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            SqlStatement sql = info.getSqlStatements(this.variables, this.pipelineMeta, transforminfo, prev, this.metadataProvider);
            if (!sql.hasError()) {
                if (sql.hasSql()) {
                    SqlEditor sqledit = new SqlEditor(this.shell, 0, this.variables, databaseMeta, DbCache.getInstance(), sql.getSql());
                    sqledit.open();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"UpdateDialog.NoSQLNeeds.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.NoSQLNeeds.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.SQLError.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"UpdateDialog.CouldNotBuildSQL.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"UpdateDialog.CouldNotBuildSQL.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSchemaNames() {
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        if (databaseMeta != null) {
            Database database = new Database(loggingObject, this.variables, databaseMeta);
            try {
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"UpdateDialog.AvailableSchemas.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"UpdateDialog.AvailableSchemas.Message", (String[])new String[]{this.wConnection.getText()}));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchema.setText(Const.NVL((String)d, (String)""));
                        this.setTableFieldCombo();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"UpdateDialog.NoSchema.Error", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"UpdateDialog.GetSchemas.Error", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"UpdateDialog.ErrorGettingSchemas", (String[])new String[0]), e);
            }
            finally {
                database.disconnect();
            }
        }
    }
}

