/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.gui;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiRegistry;
import org.apache.hop.core.gui.plugin.key.KeyboardShortcut;
import org.apache.hop.core.gui.plugin.menu.GuiMenuItem;
import org.apache.hop.ui.core.gui.BaseGuiWidgets;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class GuiMenuWidgets
extends BaseGuiWidgets {
    private Map<String, MenuItem> menuItemMap = new HashMap<String, MenuItem>();
    private Map<String, KeyboardShortcut> shortcutMap = new HashMap<String, KeyboardShortcut>();

    public GuiMenuWidgets() {
        super(UUID.randomUUID().toString());
    }

    public void createMenuWidgets(String root, Shell shell, Menu parent) {
        GuiRegistry registry = GuiRegistry.getInstance();
        List guiMenuItems = registry.findChildGuiMenuItems(root, root);
        if (guiMenuItems.isEmpty()) {
            System.err.println("Create menu widgets: no GUI menu items found for root: " + root);
            return;
        }
        Collections.sort(guiMenuItems);
        for (GuiMenuItem guiMenuItem : guiMenuItems) {
            this.addMenuWidgets(root, shell, parent, guiMenuItem);
        }
    }

    private void addMenuWidgets(String root, Shell shell, Menu parentMenu, GuiMenuItem guiMenuItem) {
        if (guiMenuItem.isIgnored()) {
            return;
        }
        List children = GuiRegistry.getInstance().findChildGuiMenuItems(root, guiMenuItem.getId());
        if (children.isEmpty()) {
            if (guiMenuItem.isAddingSeparator()) {
                new MenuItem(parentMenu, 2);
            }
            MenuItem menuItem = new MenuItem(parentMenu, 8);
            menuItem.setText(guiMenuItem.getLabel());
            if (StringUtils.isNotEmpty((String)guiMenuItem.getImage())) {
                menuItem.setImage(GuiResource.getInstance().getImage(guiMenuItem.getImage(), guiMenuItem.getClassLoader(), 16, 16));
            }
            this.setMenuItemKeyboardShortcut(menuItem, guiMenuItem);
            if (StringUtils.isNotEmpty((String)guiMenuItem.getToolTip()) && !EnvironmentUtils.getInstance().isWeb()) {
                menuItem.setToolTipText(guiMenuItem.getToolTip());
            }
            menuItem.addListener(13, e -> {
                try {
                    Object singleton = this.findGuiPluginInstance(guiMenuItem.getClassLoader(), guiMenuItem.getListenerClassName());
                    Method menuMethod = singleton.getClass().getMethod(guiMenuItem.getListenerMethod(), new Class[0]);
                    if (menuMethod == null) {
                        throw new HopException("Unable to find method " + guiMenuItem.getListenerMethod() + " in singleton " + guiMenuItem.getListenerClassName());
                    }
                    menuMethod.invoke(singleton, new Object[0]);
                }
                catch (Exception ex) {
                    System.err.println("Unable to call method " + guiMenuItem.getListenerMethod() + " in singleton " + guiMenuItem.getListenerClassName() + " : " + ex.getMessage());
                    ex.printStackTrace(System.err);
                }
            });
            this.menuItemMap.put(guiMenuItem.getId(), menuItem);
        } else {
            Menu menu = parentMenu;
            if (guiMenuItem.getId() != null) {
                MenuItem menuItem = new MenuItem(parentMenu, 64);
                menuItem.setText(Const.NVL((String)guiMenuItem.getLabel(), (String)""));
                this.setMenuItemKeyboardShortcut(menuItem, guiMenuItem);
                if (StringUtils.isNotEmpty((String)guiMenuItem.getToolTip()) && !EnvironmentUtils.getInstance().isWeb()) {
                    menuItem.setToolTipText(guiMenuItem.getToolTip());
                }
                menu = new Menu((Decorations)shell, 4);
                menuItem.setMenu(menu);
                this.menuItemMap.put(guiMenuItem.getId(), menuItem);
            }
            Collections.sort(children);
            for (GuiMenuItem child : children) {
                this.addMenuWidgets(root, shell, menu, child);
            }
        }
    }

    private void setMenuItemKeyboardShortcut(MenuItem menuItem, GuiMenuItem guiMenuItem) {
        KeyboardShortcut shortcut = GuiRegistry.getInstance().findKeyboardShortcut(guiMenuItem.getListenerClassName(), guiMenuItem.getListenerMethod(), Const.isOSX());
        if (shortcut != null) {
            GuiMenuWidgets.appendShortCut(menuItem, shortcut);
            menuItem.setAccelerator(GuiMenuWidgets.getAccelerator(shortcut));
            this.shortcutMap.put(guiMenuItem.getId(), shortcut);
        }
    }

    public static void appendShortCut(MenuItem menuItem, KeyboardShortcut shortcut) {
        menuItem.setText(menuItem.getText() + "\t" + GuiMenuWidgets.getShortcutString(shortcut));
    }

    public static int getAccelerator(KeyboardShortcut shortcut) {
        int a = 0;
        a += shortcut.getKeyCode();
        if (shortcut.isControl()) {
            a += 262144;
        }
        if (shortcut.isShift()) {
            a += 131072;
        }
        if (shortcut.isAlt()) {
            a += 65536;
        }
        if (shortcut.isCommand()) {
            a += 0x400000;
        }
        return a;
    }

    public static String getShortcutString(KeyboardShortcut shortcut) {
        String s = shortcut.toString();
        if (StringUtils.isEmpty((String)s) || s.endsWith("+")) {
            int keyCode = shortcut.getKeyCode();
            if (keyCode == 8) {
                return s + "Backspace";
            }
            if (keyCode == 27) {
                return s + "Esc";
            }
            if (keyCode == 127) {
                return s + "Delete";
            }
            if (keyCode == 0x1000003) {
                return s + "Left";
            }
            if (keyCode == 0x1000004) {
                return s + "Right";
            }
            if (keyCode == 0x1000001) {
                return s + "Up";
            }
            if (keyCode == 0x1000002) {
                return s + "Down";
            }
            if (keyCode == 0x1000007) {
                return s + "Home";
            }
            if (keyCode == 0x100000A) {
                return s + "F1";
            }
            if (keyCode == 0x100000B) {
                return s + "F2";
            }
            if (keyCode == 0x100000C) {
                return s + "F3";
            }
            if (keyCode == 0x100000D) {
                return s + "F4";
            }
            if (keyCode == 0x100000E) {
                return s + "F5";
            }
            if (keyCode == 0x100000F) {
                return s + "F6";
            }
            if (keyCode == 0x1000010) {
                return s + "F7";
            }
            if (keyCode == 0x1000011) {
                return s + "F8";
            }
            if (keyCode == 0x1000012) {
                return s + "F9";
            }
            if (keyCode == 0x1000013) {
                return s + "F10";
            }
            if (keyCode == 0x1000014) {
                return s + "F11";
            }
            if (keyCode == 0x1000015) {
                return s + "F12";
            }
        }
        return s;
    }

    public MenuItem findMenuItem(String id) {
        return this.menuItemMap.get(id);
    }

    public KeyboardShortcut findKeyboardShortcut(String id) {
        return this.shortcutMap.get(id);
    }

    public MenuItem enableMenuItem(String id, boolean enabled) {
        MenuItem menuItem = this.menuItemMap.get(id);
        if (menuItem == null || menuItem.isDisposed()) {
            return null;
        }
        menuItem.setEnabled(enabled);
        return menuItem;
    }

    public MenuItem enableMenuItem(IHopFileType fileType, String id, String permission) {
        return this.enableMenuItem(fileType, id, permission, true);
    }

    public MenuItem enableMenuItem(IHopFileType fileType, String id, String permission, boolean active) {
        MenuItem menuItem = this.menuItemMap.get(id);
        if (menuItem == null || menuItem.isDisposed()) {
            return null;
        }
        boolean hasCapability = fileType.hasCapability(permission);
        menuItem.setEnabled(hasCapability && active);
        return menuItem;
    }

    public Map<String, MenuItem> getMenuItemMap() {
        return this.menuItemMap;
    }

    public void setMenuItemMap(Map<String, MenuItem> menuItemMap) {
        this.menuItemMap = menuItemMap;
    }
}

