/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.context.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.DbCache;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.gui.plugin.action.GuiAction;
import org.apache.hop.core.gui.plugin.action.GuiActionType;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.util.HopMetadataUtil;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;

public class MetadataContextHandler
implements IGuiContextHandler {
    private static final Class<?> PKG = MetadataContextHandler.class;
    public static final String CONTEXT_ID = "HopGuiMetadataContext";
    private HopGui hopGui;
    private IHopMetadataProvider metadataProvider;
    private Class<? extends IHopMetadata> metadataObjectClass;
    private MetadataManager<? extends IHopMetadata> metadataManager;

    public MetadataContextHandler(HopGui hopGui, IHopMetadataProvider metadataProvider, Class<? extends IHopMetadata> metadataObjectClass) {
        this.hopGui = hopGui;
        this.metadataProvider = metadataProvider;
        this.metadataObjectClass = metadataObjectClass;
        this.metadataManager = new MetadataManager<IHopMetadata>(hopGui.getVariables(), metadataProvider, metadataObjectClass);
        this.metadataManager.setClassLoader(metadataObjectClass.getClassLoader());
    }

    @Override
    public String getContextId() {
        return CONTEXT_ID;
    }

    @Override
    public List<GuiAction> getSupportedActions() {
        HopMetadata hopMetadata = HopMetadataUtil.getHopMetadataAnnotation(this.metadataObjectClass);
        ArrayList<GuiAction> actions = new ArrayList<GuiAction>();
        GuiAction newAction = new GuiAction("CREATE_" + hopMetadata.name(), GuiActionType.Create, hopMetadata.name(), "Creates a new " + hopMetadata.name() + " : " + hopMetadata.description(), hopMetadata.image(), (shiftClicked, controlClicked, parameters) -> this.metadataManager.newMetadataWithEditor());
        newAction.setClassLoader(this.metadataObjectClass.getClassLoader());
        newAction.setCategory("Metadata");
        newAction.setCategoryOrder("2");
        actions.add(newAction);
        GuiAction editAction = new GuiAction("EDIT_" + hopMetadata.name(), GuiActionType.Modify, hopMetadata.name(), "Edits a " + hopMetadata.name() + " : " + hopMetadata.description(), hopMetadata.image(), (shiftClicked, controlClicked, parameters) -> this.metadataManager.editMetadata());
        editAction.setClassLoader(this.metadataObjectClass.getClassLoader());
        editAction.setCategory("Metadata");
        editAction.setCategoryOrder("2");
        actions.add(editAction);
        GuiAction deleteAction = new GuiAction("DELETE_" + hopMetadata.name(), GuiActionType.Delete, hopMetadata.name(), "After confirmation this deletes a " + hopMetadata.name() + " : " + hopMetadata.description(), hopMetadata.image(), (shiftClicked, controlClicked, parameters) -> this.metadataManager.deleteMetadata());
        deleteAction.setClassLoader(this.metadataObjectClass.getClassLoader());
        deleteAction.setCategory("Metadata");
        deleteAction.setCategoryOrder("2");
        actions.add(deleteAction);
        if (this.metadataObjectClass.isAssignableFrom(DatabaseMeta.class)) {
            GuiAction databaseClearCacheAction = new GuiAction("DATABASE_CLEAR_CACHE", GuiActionType.Custom, BaseMessages.getString(PKG, (String)"HopGui.Context.Database.Menu.ClearDatabaseCache.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGui.Context.Database.Menu.ClearDatabaseCache.Tooltip", (String[])new String[0]), null, (shiftClicked, controlClicked, parameters) -> DbCache.getInstance().clear((String)parameters[0]));
            newAction.setClassLoader(this.metadataObjectClass.getClassLoader());
            newAction.setCategory("Metadata");
            newAction.setCategoryOrder("3");
            actions.add(databaseClearCacheAction);
        }
        return actions;
    }
}

