/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.workflow;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.base.AbstractMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.IAddUndoPosition;
import org.apache.hop.core.IEngineMeta;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.action.GuiContextAction;
import org.apache.hop.core.action.GuiContextActionFilter;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.gui.AreaOwner;
import org.apache.hop.core.gui.IGc;
import org.apache.hop.core.gui.IGuiPosition;
import org.apache.hop.core.gui.IRedrawable;
import org.apache.hop.core.gui.IScrollBar;
import org.apache.hop.core.gui.IUndo;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.gui.Rectangle;
import org.apache.hop.core.gui.SnapAllignDistribute;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.IGuiRefresher;
import org.apache.hop.core.gui.plugin.action.GuiActionType;
import org.apache.hop.core.gui.plugin.key.GuiKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.GuiOsxKeyboardShortcut;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElementType;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.IHasLogChannel;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILogParentProvided;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.svg.SvgFile;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.history.AuditManager;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.laf.BasePropertyHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelinePainter;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageDialogWithToggle;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.core.gui.HopNamespace;
import org.apache.hop.ui.core.widget.OsHelper;
import org.apache.hop.ui.hopgui.CanvasFacade;
import org.apache.hop.ui.hopgui.CanvasListener;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.ServerPushSessionFacade;
import org.apache.hop.ui.hopgui.context.BaseGuiContextHandler;
import org.apache.hop.ui.hopgui.context.GuiContextUtil;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.dialog.NotePadDialog;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.delegates.HopGuiNotePadDelegate;
import org.apache.hop.ui.hopgui.file.shared.HopGuiTooltipExtension;
import org.apache.hop.ui.hopgui.file.workflow.HopWorkflowFileType;
import org.apache.hop.ui.hopgui.file.workflow.context.HopGuiWorkflowActionContext;
import org.apache.hop.ui.hopgui.file.workflow.context.HopGuiWorkflowContext;
import org.apache.hop.ui.hopgui.file.workflow.context.HopGuiWorkflowHopContext;
import org.apache.hop.ui.hopgui.file.workflow.context.HopGuiWorkflowNoteContext;
import org.apache.hop.ui.hopgui.file.workflow.delegates.HopGuiWorkflowActionDelegate;
import org.apache.hop.ui.hopgui.file.workflow.delegates.HopGuiWorkflowClipboardDelegate;
import org.apache.hop.ui.hopgui.file.workflow.delegates.HopGuiWorkflowGridDelegate;
import org.apache.hop.ui.hopgui.file.workflow.delegates.HopGuiWorkflowHopDelegate;
import org.apache.hop.ui.hopgui.file.workflow.delegates.HopGuiWorkflowLogDelegate;
import org.apache.hop.ui.hopgui.file.workflow.delegates.HopGuiWorkflowRunDelegate;
import org.apache.hop.ui.hopgui.file.workflow.delegates.HopGuiWorkflowUndoDelegate;
import org.apache.hop.ui.hopgui.file.workflow.extension.HopGuiWorkflowGraphExtension;
import org.apache.hop.ui.hopgui.perspective.dataorch.HopDataOrchestrationPerspective;
import org.apache.hop.ui.hopgui.perspective.dataorch.HopGuiAbstractGraph;
import org.apache.hop.ui.hopgui.shared.SwtGc;
import org.apache.hop.ui.hopgui.shared.SwtScrollBar;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.ActionResult;
import org.apache.hop.workflow.IActionListener;
import org.apache.hop.workflow.WorkflowExecutionConfiguration;
import org.apache.hop.workflow.WorkflowHopMeta;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.WorkflowPainter;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.workflow.engine.WorkflowEngineFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.ToolTip;

@GuiPlugin(description="Workflow Graph tab")
public class HopGuiWorkflowGraph
extends HopGuiAbstractGraph
implements IRedrawable,
MouseListener,
MouseMoveListener,
MouseTrackListener,
IHasLogChannel,
ILogParentProvided,
IHopFileTypeHandler,
IGuiRefresher {
    private static final Class<?> PKG = HopGuiWorkflowGraph.class;
    public static final String GUI_PLUGIN_TOOLBAR_PARENT_ID = "HopGuiWorkflowGraph-Toolbar";
    public static final String TOOLBAR_ITEM_START = "HopGuiWorkflowGraph-ToolBar-10010-Run";
    public static final String TOOLBAR_ITEM_STOP = "HopGuiWorkflowGraph-ToolBar-10030-Stop";
    public static final String TOOLBAR_ITEM_UNDO_ID = "HopGuiWorkflowGraph-ToolBar-10100-Undo";
    public static final String TOOLBAR_ITEM_REDO_ID = "HopGuiWorkflowGraph-ToolBar-10110-Redo";
    public static final String TOOLBAR_ITEM_SNAP_TO_GRID = "HopGuiWorkflowGraph-ToolBar-10190-Snap-To-Grid";
    public static final String TOOLBAR_ITEM_ALIGN_LEFT = "HopGuiWorkflowGraph-ToolBar-10200-Align-Left";
    public static final String TOOLBAR_ITEM_ALIGN_RIGHT = "HopGuiWorkflowGraph-ToolBar-10210-Align-Right";
    public static final String TOOLBAR_ITEM_ALIGN_TOP = "HopGuiWorkflowGraph-ToolBar-10250-Align-Ttop";
    public static final String TOOLBAR_ITEM_ALIGN_BOTTOM = "HopGuiWorkflowGraph-ToolBar-10260-Align-Bottom";
    public static final String TOOLBAR_ITEM_DISTRIBUTE_HORIZONTALLY = "HopGuiWorkflowGraph-ToolBar-10300-Distribute-Horizontally";
    public static final String TOOLBAR_ITEM_DISTRIBUTE_VERTICALLY = "HopGuiWorkflowGraph-ToolBar-10310-Distribute-Vertically";
    public static final String TOOLBAR_ITEM_SHOW_EXECUTION_RESULTS = "HopGuiWorkflowGraph-ToolBar-10400-Execution-Results";
    public static final String TOOLBAR_ITEM_ZOOM_LEVEL = "HopGuiWorkflowGraph-ToolBar-10500-Zoom-Level";
    public static final String TOOLBAR_ITEM_ZOOM_IN = "HopGuiWorkflowGraph-ToolBar-10510-Zoom-In";
    public static final String TOOLBAR_ITEM_ZOOM_OUT = "HopGuiWorkflowGraph-ToolBar-10520-Zoom-Out";
    public static final String TOOLBAR_ITEM_ZOOM_100PCT = "HopGuiWorkflowGraph-ToolBar-10530-Zoom-100Pct";
    public static final String TOOLBAR_ITEM_EDIT_WORKFLOW = "HopGuiWorkflowGrpah-ToolBar-10450-EditWorkflow";
    private static final String STRING_PARALLEL_WARNING_PARAMETER = "ParallelActionsWarning";
    private static final int HOP_SEL_MARGIN = 9;
    private static final int TOOLTIP_HIDE_DELAY_FLASH = 2000;
    public static final String ACTION_ID_WORKFLOW_GRAPH_HOP_ENABLE = "workflow-graph-hop-10010-hop-enable";
    public static final String ACTION_ID_WORKFLOW_GRAPH_HOP_DISABLE = "workflow-graph-hop-10000-hop-disable";
    public static final String ACTION_ID_WORKFLOW_GRAPH_HOP_HOP_UNCONDITIONAL = "workflow-graph-hop-10030-hop-unconditional";
    public static final String ACTION_ID_WORKFLOW_GRAPH_HOP_HOP_EVALUATION_SUCCESS = "workflow-graph-hop-10040-hop-evaluation-success";
    public static final String ACTION_ID_WORKFLOW_GRAPH_HOP_HOP_EVALUATION_FAILURE = "workflow-graph-hop-10050-hop-evaluation-failure";
    private final HopDataOrchestrationPerspective perspective;
    protected ILogChannel log;
    protected WorkflowMeta workflowMeta;
    protected IWorkflowEngine<WorkflowMeta> workflow;
    protected Thread workflowThread;
    protected PropsUi props;
    protected int iconSize;
    protected int lineWidth;
    protected Point lastClick;
    protected List<ActionMeta> selectedActions;
    protected ActionMeta selectedAction;
    private List<NotePadMeta> selectedNotes;
    protected NotePadMeta selectedNote;
    protected Point lastMove;
    protected WorkflowHopMeta hopCandidate;
    protected HopGui hopGui;
    protected boolean splitHop;
    protected int lastButton;
    protected WorkflowHopMeta lastHopSplit;
    protected Rectangle selectionRegion;
    protected static final double theta = Math.toRadians(10.0);
    protected static final int size = 30;
    protected int currentMouseX = 0;
    protected int currentMouseY = 0;
    protected NotePadMeta ni = null;
    private SashForm sashForm;
    public CTabFolder extraViewTabFolder;
    private ToolBar toolBar;
    private GuiToolbarWidgets toolBarWidgets;
    private boolean halting;
    public HopGuiWorkflowLogDelegate workflowLogDelegate;
    public HopGuiWorkflowGridDelegate workflowGridDelegate;
    public HopGuiWorkflowClipboardDelegate workflowClipboardDelegate;
    public HopGuiWorkflowRunDelegate workflowRunDelegate;
    public HopGuiWorkflowUndoDelegate workflowUndoDelegate;
    public HopGuiWorkflowActionDelegate workflowActionDelegate;
    public HopGuiWorkflowHopDelegate workflowHopDelegate;
    public HopGuiNotePadDelegate notePadDelegate;
    private Composite mainComposite;
    private ToolItem closeItem;
    private ToolItem minMaxItem;
    private List<AreaOwner> areaOwners;
    private HopWorkflowFileType<WorkflowMeta> fileType;
    private ActionMeta startHopAction;
    private Point endHopLocation;
    private ActionMeta endHopAction;
    private ActionMeta noInputAction;
    private Point[] previousTransformLocations;
    private Point[] previousNoteLocations;
    private ActionMeta currentAction;
    private boolean ignoreNextClick;
    private boolean doubleClick;
    private WorkflowHopMeta clickedWorkflowHop;
    private ActionMeta lastChained = null;

    public HopGuiWorkflowGraph(Composite parent, HopGui hopGui, CTabItem parentTabItem, HopDataOrchestrationPerspective perspective, WorkflowMeta workflowMeta, HopWorkflowFileType<WorkflowMeta> fileType) {
        super(hopGui, parent, 0, parentTabItem);
        this.perspective = perspective;
        this.workflowMeta = workflowMeta;
        this.fileType = fileType;
        this.log = hopGui.getLog();
        this.hopGui = hopGui;
        this.workflowMeta = workflowMeta;
        this.props = PropsUi.getInstance();
        this.areaOwners = new ArrayList<AreaOwner>();
        workflowMeta.setInternalHopVariables(this.variables);
        this.workflowLogDelegate = new HopGuiWorkflowLogDelegate(hopGui, this);
        this.workflowGridDelegate = new HopGuiWorkflowGridDelegate(hopGui, this);
        this.workflowClipboardDelegate = new HopGuiWorkflowClipboardDelegate(hopGui, this);
        this.workflowRunDelegate = new HopGuiWorkflowRunDelegate(hopGui, this);
        this.workflowUndoDelegate = new HopGuiWorkflowUndoDelegate(hopGui, this);
        this.workflowActionDelegate = new HopGuiWorkflowActionDelegate(hopGui, this);
        this.workflowHopDelegate = new HopGuiWorkflowHopDelegate(hopGui, this);
        this.notePadDelegate = new HopGuiNotePadDelegate(hopGui, this);
        this.setLayout((Layout)new FormLayout());
        this.setLayoutData(new GridData(1808));
        this.addToolBar();
        this.mainComposite = new Composite((Composite)this, 0);
        this.mainComposite.setLayout((Layout)new FillLayout());
        FormData toolbarFd = new FormData();
        toolbarFd.left = new FormAttachment(0, 0);
        toolbarFd.right = new FormAttachment(100, 0);
        this.toolBar.setLayoutData((Object)toolbarFd);
        FormData fdMainComposite = new FormData();
        fdMainComposite.left = new FormAttachment(0, 0);
        fdMainComposite.top = new FormAttachment((Control)this.toolBar, 0);
        fdMainComposite.right = new FormAttachment(100, 0);
        fdMainComposite.bottom = new FormAttachment(100, 0);
        this.mainComposite.setLayoutData((Object)fdMainComposite);
        this.sashForm = new SashForm(this.mainComposite, 512);
        this.wsCanvas = new ScrolledComposite((Composite)this.sashForm, 264960);
        this.wsCanvas.setAlwaysShowScrollBars(true);
        this.wsCanvas.setLayout((Layout)new FormLayout());
        FormData fdsCanvas = new FormData();
        fdsCanvas.left = new FormAttachment(0, 0);
        fdsCanvas.top = new FormAttachment(0, 0);
        fdsCanvas.right = new FormAttachment(100, 0);
        fdsCanvas.bottom = new FormAttachment(100, 0);
        this.wsCanvas.setLayoutData((Object)fdsCanvas);
        this.canvas = new Canvas((Composite)this.wsCanvas, 262144);
        Listener listener = CanvasListener.getInstance();
        this.canvas.addListener(3, listener);
        this.canvas.addListener(5, listener);
        this.canvas.addListener(4, listener);
        this.canvas.addListener(9, listener);
        FormData fdCanvas = new FormData();
        fdCanvas.left = new FormAttachment(0, 0);
        fdCanvas.top = new FormAttachment(0, 0);
        fdCanvas.right = new FormAttachment(100, 0);
        fdCanvas.bottom = new FormAttachment(100, 0);
        this.canvas.setLayoutData((Object)fdCanvas);
        this.sashForm.setWeights(new int[]{100});
        this.toolTip = new ToolTip(this.getShell(), 4096);
        this.toolTip.setAutoHide(true);
        this.newProps();
        this.selectionRegion = null;
        this.hopCandidate = null;
        this.lastHopSplit = null;
        this.selectedActions = null;
        this.selectedNote = null;
        ScrollBar horizontalBar = this.wsCanvas.getHorizontalBar();
        ScrollBar verticalBar = this.wsCanvas.getVerticalBar();
        horizontalBar.setMinimum(1);
        horizontalBar.setMaximum(100);
        horizontalBar.setVisible(true);
        verticalBar.setMinimum(1);
        verticalBar.setMaximum(100);
        verticalBar.setVisible(true);
        if (!EnvironmentUtils.getInstance().isWeb()) {
            horizontalBar.setIncrement(5);
            verticalBar.setIncrement(5);
        }
        if (OsHelper.isWindows()) {
            horizontalBar.addListener(13, e -> this.canvas.redraw());
            verticalBar.addListener(13, e -> this.canvas.redraw());
        }
        this.setVisible(true);
        this.canvas.addPaintListener(this::paintControl);
        this.selectedActions = null;
        this.lastClick = null;
        this.canvas.addMouseListener((MouseListener)this);
        if (!EnvironmentUtils.getInstance().isWeb()) {
            this.canvas.addMouseMoveListener((MouseMoveListener)this);
            this.canvas.addMouseTrackListener((MouseTrackListener)this);
        }
        hopGui.replaceKeyboardShortcutListeners(this);
        this.canvas.pack();
        org.eclipse.swt.graphics.Rectangle bounds = this.canvas.getBounds();
        this.wsCanvas.setContent((Control)this.canvas);
        this.wsCanvas.setExpandHorizontal(true);
        this.wsCanvas.setExpandVertical(true);
        this.wsCanvas.setMinWidth(bounds.width);
        this.wsCanvas.setMinHeight(bounds.height);
        this.setBackground(GuiResource.getInstance().getColorBackground());
        this.wsCanvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                new Thread(() -> {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    HopGuiWorkflowGraph.this.getDisplay().asyncExec(() -> HopGuiWorkflowGraph.this.adjustScrolling());
                }).start();
            }
        });
        this.updateGui();
    }

    public static HopGuiWorkflowGraph getInstance() {
        return HopGui.getActiveWorkflowGraph();
    }

    protected void hideToolTips() {
        this.toolTip.setVisible(false);
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (!PropsUi.getInstance().useDoubleClick()) {
            return;
        }
        this.doubleClick = true;
        this.clearSettings();
        Point real = this.screen2real(e.x, e.y);
        this.hideToolTips();
        AreaOwner areaOwner = this.getVisibleAreaOwner(real.x, real.y);
        try {
            HopGuiWorkflowGraphExtension ext = new HopGuiWorkflowGraphExtension(this, e, real, areaOwner);
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, (IVariables)this.variables, (String)HopExtensionPoint.WorkflowGraphMouseDoubleClick.id, (Object)ext);
            if (ext.isPreventingDefault()) {
                return;
            }
        }
        catch (Exception ex) {
            LogChannel.GENERAL.logError("Error calling JobGraphMouseDoubleClick extension point", (Throwable)ex);
        }
        ActionMeta action = this.workflowMeta.getAction(real.x, real.y, this.iconSize);
        if (action != null) {
            if (e.button == 1) {
                this.editAction(action);
            } else {
                this.launchStuff(action);
            }
        } else {
            WorkflowHopMeta online = this.findWorkflowHop(real.x, real.y);
            if (online == null) {
                NotePadMeta ni = this.workflowMeta.getNote(real.x, real.y);
                if (ni != null) {
                    this.editNote(ni);
                } else {
                    this.editWorkflowProperties();
                }
            }
        }
    }

    public void mouseDown(MouseEvent e) {
        block27: {
            Point real;
            boolean control;
            block28: {
                if (EnvironmentUtils.getInstance().isWeb()) {
                    this.mouseHover(e);
                }
                this.doubleClick = false;
                if (this.ignoreNextClick) {
                    this.ignoreNextClick = false;
                    return;
                }
                control = (e.stateMask & SWT.MOD1) != 0;
                boolean shift = (e.stateMask & 0x20000) != 0;
                this.lastButton = e.button;
                real = this.screen2real(e.x, e.y);
                this.lastClick = new Point(real.x, real.y);
                this.setupDragView(e.button, new Point(e.x, e.y));
                this.hideToolTips();
                if (e.button == 3) {
                    this.setMenu(real.x, real.y);
                    return;
                }
                AreaOwner areaOwner = this.getVisibleAreaOwner(real.x, real.y);
                try {
                    HopGuiWorkflowGraphExtension ext = new HopGuiWorkflowGraphExtension(this, e, real, areaOwner);
                    ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, (IVariables)this.variables, (String)HopExtensionPoint.WorkflowGraphMouseDown.id, (Object)ext);
                    if (ext.isPreventingDefault()) {
                        return;
                    }
                }
                catch (Exception ex) {
                    LogChannel.GENERAL.logError("Error calling JobGraphMouseDown extension point", (Throwable)ex);
                }
                if (e.button != 1 && e.button != 2) break block27;
                if (areaOwner == null || areaOwner.getAreaType() == null) break block28;
                switch (areaOwner.getAreaType()) {
                    case ACTION_ICON: {
                        ActionMeta actionCopy;
                        if (shift && control) {
                            this.openReferencedObject();
                            return;
                        }
                        this.currentAction = actionCopy = (ActionMeta)areaOwner.getOwner();
                        if (this.hopCandidate != null) {
                            this.addCandidateAsHop();
                        } else if (e.button == 2 || e.button == 1 && shift) {
                            this.canvas.setData("mode", (Object)"hop");
                            this.startHopAction = actionCopy;
                        } else {
                            this.canvas.setData("mode", (Object)"drag");
                            this.selectedActions = this.workflowMeta.getSelectedActions();
                            this.selectedAction = actionCopy;
                            this.previousTransformLocations = this.workflowMeta.getSelectedLocations();
                            Point p = actionCopy.getLocation();
                            this.iconOffset = new Point(real.x - p.x, real.y - p.y);
                        }
                        this.updateGui();
                        break;
                    }
                    case NOTE: {
                        this.ni = (NotePadMeta)areaOwner.getOwner();
                        this.selectedNotes = this.workflowMeta.getSelectedNotes();
                        this.selectedNote = this.ni;
                        Point loc = this.ni.getLocation();
                        this.previousNoteLocations = this.workflowMeta.getSelectedNoteLocations();
                        this.noteOffset = new Point(real.x - loc.x, real.y - loc.y);
                        this.updateGui();
                        break;
                    }
                    case WORKFLOW_HOP_ICON: {
                        WorkflowHopMeta hop = (WorkflowHopMeta)areaOwner.getOwner();
                        if (hop.getFromAction().isEvaluation()) {
                            if (hop.isUnconditional()) {
                                hop.setUnconditional(false);
                                hop.setEvaluation(true);
                            } else if (hop.getEvaluation()) {
                                hop.setEvaluation(false);
                            } else {
                                hop.setUnconditional(true);
                            }
                            this.updateGui();
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block27;
            }
            WorkflowHopMeta hop = this.findWorkflowHop(real.x, real.y);
            if (hop != null) {
                if (e.button == 2 || e.button == 1 && control) {
                    hop.setEnabled(!hop.isEnabled());
                    this.updateGui();
                } else {
                    this.clickedWorkflowHop = hop;
                }
            } else {
                this.canvas.setData("mode", (Object)"select");
                this.startHopAction = null;
                if (!control && e.button == 1) {
                    this.selectionRegion = new Rectangle(real.x, real.y, 0, 0);
                }
                this.updateGui();
            }
        }
        if (EnvironmentUtils.getInstance().isWeb()) {
            this.mouseMove(e);
        }
    }

    public void mouseUp(MouseEvent e) {
        this.canvas.setData("mode", (Object)"null");
        if (EnvironmentUtils.getInstance().isWeb()) {
            this.mouseMove(e);
        }
        boolean control = (e.stateMask & SWT.MOD1) != 0;
        boolean singleClick = false;
        SingleClickType singleClickType = null;
        ActionMeta singleClickAction = null;
        NotePadMeta singleClickNote = null;
        WorkflowHopMeta singleClickHop = null;
        this.viewDrag = false;
        this.viewDragStart = null;
        if (this.iconOffset == null) {
            this.iconOffset = new Point(0, 0);
        }
        Point real = this.screen2real(e.x, e.y);
        Point icon = new Point(real.x - this.iconOffset.x, real.y - this.iconOffset.y);
        AreaOwner areaOwner = this.getVisibleAreaOwner(real.x, real.y);
        try {
            HopGuiWorkflowGraphExtension ext = new HopGuiWorkflowGraphExtension(this, e, real, areaOwner);
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, (IVariables)this.variables, (String)HopExtensionPoint.WorkflowGraphMouseUp.id, (Object)ext);
            if (ext.isPreventingDefault()) {
                this.redraw();
                this.clearSettings();
                return;
            }
        }
        catch (Exception ex) {
            LogChannel.GENERAL.logError("Error calling WorkflowGraphMouseUp extension point", (Throwable)ex);
        }
        if (areaOwner != null && areaOwner.getAreaType() != null) {
            switch (areaOwner.getAreaType()) {
                case ACTION_ICON: {
                    if (this.startHopAction == null) break;
                    this.currentAction = (ActionMeta)areaOwner.getOwner();
                    this.hopCandidate = new WorkflowHopMeta(this.startHopAction, this.currentAction);
                    this.addCandidateAsHop();
                    this.redraw();
                    break;
                }
                case ACTION_NAME: {
                    if (this.startHopAction != null || this.selectionRegion != null || this.selectedActions != null || this.selectedNotes != null) break;
                    this.startHopAction = null;
                    this.selectionRegion = null;
                    ActionMeta actionMeta = (ActionMeta)areaOwner.getParent();
                    this.editAction(actionMeta);
                    return;
                }
            }
        }
        if (this.selectionRegion != null) {
            this.selectionRegion.width = real.x - this.selectionRegion.x;
            this.selectionRegion.height = real.y - this.selectionRegion.y;
            if (this.selectionRegion.isEmpty()) {
                singleClick = true;
                singleClickType = SingleClickType.Workflow;
            } else {
                this.workflowMeta.unselectAll();
                this.selectInRect(this.workflowMeta, this.selectionRegion);
            }
            this.selectionRegion = null;
            this.avoidScrollAdjusting = true;
            this.updateGui();
        } else if (this.selectedAction != null && this.startHopAction == null) {
            if (e.button == 1) {
                Point realclick = this.screen2real(e.x, e.y);
                if (this.lastClick.x == realclick.x && this.lastClick.y == realclick.y) {
                    if (control) {
                        this.selectedAction.flipSelected();
                    } else {
                        singleClick = true;
                        singleClickType = SingleClickType.Action;
                        singleClickAction = this.selectedAction;
                    }
                } else {
                    int[] indexes;
                    this.selectedActions = this.workflowMeta.getSelectedActions();
                    this.selectedNotes = this.workflowMeta.getSelectedNotes();
                    boolean also = false;
                    if (this.selectedNotes != null && this.selectedNotes.size() > 0 && this.previousNoteLocations != null) {
                        indexes = this.workflowMeta.getNoteIndexes(this.selectedNotes);
                        this.addUndoPosition(this.selectedNotes.toArray(new NotePadMeta[this.selectedNotes.size()]), indexes, this.previousNoteLocations, this.workflowMeta.getSelectedNoteLocations(), also);
                        boolean bl = also = this.selectedActions != null && this.selectedActions.size() > 0;
                    }
                    if (this.selectedActions != null && this.selectedActions.size() > 0 && this.previousTransformLocations != null) {
                        indexes = this.workflowMeta.getActionIndexes(this.selectedActions);
                        this.addUndoPosition(this.selectedActions.toArray(new ActionMeta[this.selectedActions.size()]), indexes, this.previousTransformLocations, this.workflowMeta.getSelectedLocations(), also);
                    }
                }
            }
            if (this.splitHop) {
                WorkflowHopMeta hi = this.findHop(icon.x + this.iconSize / 2, icon.y + this.iconSize / 2, this.selectedAction);
                if (hi != null) {
                    int id = 0;
                    if (!this.hopGui.getProps().getAutoSplit()) {
                        MessageDialogWithToggle md = new MessageDialogWithToggle(this.hopShell(), BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.SplitHop.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.SplitHop.Message", (String[])new String[0]) + Const.CR + hi.toString(), 4, new String[]{BaseMessages.getString(PKG, (String)"System.Button.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Button.No", (String[])new String[0])}, BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.Option.SplitHop.DoNotAskAgain", (String[])new String[0]), this.hopGui.getProps().getAutoSplit());
                        id = md.open();
                        this.hopGui.getProps().setAutoSplit(md.getToggleState());
                    }
                    if ((id & 0xFF) == 0 && this.workflowMeta.findWorkflowHop(this.selectedAction, hi.getFromAction()) == null && this.workflowMeta.findWorkflowHop(hi.getToAction(), this.selectedAction) == null) {
                        if (this.workflowMeta.findWorkflowHop(hi.getFromAction(), this.selectedAction, true) == null) {
                            WorkflowHopMeta newhop1 = new WorkflowHopMeta(hi.getFromAction(), this.selectedAction);
                            if (hi.getFromAction().getAction().isUnconditional()) {
                                newhop1.setUnconditional();
                            }
                            this.workflowMeta.addWorkflowHop(newhop1);
                            this.hopGui.undoDelegate.addUndoNew((IUndo)this.workflowMeta, new WorkflowHopMeta[]{newhop1}, new int[]{this.workflowMeta.indexOfWorkflowHop(newhop1)}, true);
                        }
                        if (this.workflowMeta.findWorkflowHop(this.selectedAction, hi.getToAction(), true) == null) {
                            WorkflowHopMeta newhop2 = new WorkflowHopMeta(this.selectedAction, hi.getToAction());
                            if (this.selectedAction.getAction().isUnconditional()) {
                                newhop2.setUnconditional();
                            }
                            this.workflowMeta.addWorkflowHop(newhop2);
                            this.hopGui.undoDelegate.addUndoNew((IUndo)this.workflowMeta, new WorkflowHopMeta[]{newhop2}, new int[]{this.workflowMeta.indexOfWorkflowHop(newhop2)}, true);
                        }
                        int idx = this.workflowMeta.indexOfWorkflowHop(hi);
                        this.hopGui.undoDelegate.addUndoDelete((IUndo)this.workflowMeta, new WorkflowHopMeta[]{hi}, new int[]{idx}, true);
                        this.workflowMeta.removeWorkflowHop(idx);
                    }
                }
                this.splitHop = false;
            }
            this.selectedActions = null;
            this.selectedNotes = null;
            this.selectedAction = null;
            this.selectedNote = null;
            this.startHopAction = null;
            this.endHopLocation = null;
            this.avoidScrollAdjusting = true;
            this.updateGui();
        } else if (this.selectedNote != null) {
            if (e.button == 1) {
                if (this.lastClick.x == real.x && this.lastClick.y == real.y) {
                    if (control) {
                        this.selectedNote.flipSelected();
                    } else {
                        singleClick = true;
                        singleClickType = SingleClickType.Note;
                        singleClickNote = this.selectedNote;
                    }
                } else {
                    int[] indexes;
                    this.selectedActions = this.workflowMeta.getSelectedActions();
                    this.selectedNotes = this.workflowMeta.getSelectedNotes();
                    boolean also = false;
                    if (this.selectedNotes != null && this.selectedNotes.size() > 0 && this.previousNoteLocations != null) {
                        indexes = this.workflowMeta.getNoteIndexes(this.selectedNotes);
                        this.addUndoPosition(this.selectedNotes.toArray(new NotePadMeta[this.selectedNotes.size()]), indexes, this.previousNoteLocations, this.workflowMeta.getSelectedNoteLocations(), also);
                        boolean bl = also = this.selectedActions != null && this.selectedActions.size() > 0;
                    }
                    if (this.selectedActions != null && this.selectedActions.size() > 0 && this.previousTransformLocations != null) {
                        indexes = this.workflowMeta.getActionIndexes(this.selectedActions);
                        this.addUndoPosition(this.selectedActions.toArray(new ActionMeta[this.selectedActions.size()]), indexes, this.previousTransformLocations, this.workflowMeta.getSelectedLocations(), also);
                    }
                }
            }
            this.selectedNotes = null;
            this.selectedActions = null;
            this.selectedAction = null;
            this.selectedNote = null;
            this.startHopAction = null;
            this.endHopLocation = null;
        }
        if (this.clickedWorkflowHop != null) {
            singleClick = true;
            singleClickType = SingleClickType.Hop;
            singleClickHop = this.clickedWorkflowHop;
        }
        this.clickedWorkflowHop = null;
        boolean fSingleClick = singleClick;
        SingleClickType fSingleClickType = singleClickType;
        ActionMeta fSingleClickAction = singleClickAction;
        NotePadMeta fSingleClickNote = singleClickNote;
        WorkflowHopMeta fSingleClickHop = singleClickHop;
        if (PropsUi.getInstance().useDoubleClick()) {
            Display.getDefault().timerExec(Display.getDefault().getDoubleClickTime(), () -> this.showContextDialog(e, real, fSingleClick, fSingleClickType, fSingleClickAction, fSingleClickNote, fSingleClickHop));
        } else {
            this.showContextDialog(e, real, fSingleClick, fSingleClickType, fSingleClickAction, fSingleClickNote, fSingleClickHop);
        }
        this.lastButton = 0;
    }

    private void showContextDialog(MouseEvent e, Point real, boolean fSingleClick, SingleClickType fSingleClickType, ActionMeta fSingleClickAction, NotePadMeta fSingleClickNote, WorkflowHopMeta fSingleClickHop) {
        this.selectionRegion = null;
        if (fSingleClickType == SingleClickType.Workflow && (this.workflowMeta.getSelectedActions().size() > 0 || this.workflowMeta.getSelectedNotes().size() > 0)) {
            this.workflowMeta.unselectAll();
            this.selectionRegion = null;
            this.updateGui();
            this.toolTip.setVisible(false);
            this.toolTip.setText(Const.CR + "  Selection cleared " + Const.CR);
            this.showToolTip(new org.eclipse.swt.graphics.Point(e.x, e.y));
            return;
        }
        if (!this.doubleClick && fSingleClick && fSingleClickType != null) {
            BaseGuiContextHandler contextHandler = null;
            String message = null;
            switch (fSingleClickType) {
                case Workflow: {
                    message = BaseMessages.getString(PKG, (String)"HopGuiWorkflowGraph.ContextualActionDialog.Workflow.Header", (String[])new String[0]);
                    contextHandler = new HopGuiWorkflowContext(this.workflowMeta, this, real);
                    break;
                }
                case Action: {
                    message = BaseMessages.getString(PKG, (String)"HopGuiWorkflowGraph.ContextualActionDialog.Action.Header", (String[])new String[]{fSingleClickAction.getName()});
                    contextHandler = new HopGuiWorkflowActionContext(this.workflowMeta, fSingleClickAction, this, real);
                    break;
                }
                case Note: {
                    message = BaseMessages.getString(PKG, (String)"HopGuiWorkflowGraph.ContextualActionDialog.Note.Header", (String[])new String[0]);
                    contextHandler = new HopGuiWorkflowNoteContext(this.workflowMeta, fSingleClickNote, this, real);
                    break;
                }
                case Hop: {
                    message = BaseMessages.getString(PKG, (String)"HopGuiWorkflowGraph.ContextualActionDialog.Hop.Header", (String[])new String[0]);
                    contextHandler = new HopGuiWorkflowHopContext(this.workflowMeta, fSingleClickHop, this, real);
                    break;
                }
            }
            if (contextHandler != null) {
                Shell parent = this.hopShell();
                org.eclipse.swt.graphics.Point p = parent.getDisplay().map((Control)this.canvas, null, e.x, e.y);
                this.ignoreNextClick = GuiContextUtil.getInstance().handleActionSelection(parent, message, new Point(p.x, p.y), (IGuiContextHandler)((Object)contextHandler));
            }
        }
    }

    public void mouseMove(MouseEvent e) {
        int dy;
        ActionMeta actionCopy;
        Point real;
        boolean shift = (e.stateMask & 0x20000) != 0;
        this.noInputAction = null;
        this.hideToolTips();
        this.lastMove = real = this.screen2real(e.x, e.y);
        if (this.iconOffset == null) {
            this.iconOffset = new Point(0, 0);
        }
        Point icon = new Point(real.x - this.iconOffset.x, real.y - this.iconOffset.y);
        if (this.noteOffset == null) {
            this.noteOffset = new Point(0, 0);
        }
        Point note = new Point(real.x - this.noteOffset.x, real.y - this.noteOffset.y);
        AreaOwner areaOwner = this.getVisibleAreaOwner(real.x, real.y);
        if (areaOwner != null && areaOwner.getAreaType() != null) {
            actionCopy = null;
            switch (areaOwner.getAreaType()) {
                case ACTION_ICON: {
                    actionCopy = (ActionMeta)areaOwner.getOwner();
                    break;
                }
            }
        }
        if (this.selectedAction != null && !this.selectedAction.isSelected()) {
            this.workflowMeta.unselectAll();
            this.selectedAction.setSelected(true);
            this.selectedActions = new ArrayList<ActionMeta>();
            this.selectedActions.add(this.selectedAction);
            this.previousTransformLocations = new Point[]{this.selectedAction.getLocation()};
            this.redraw();
        } else if (this.selectedNote != null && !this.selectedNote.isSelected()) {
            this.workflowMeta.unselectAll();
            this.selectedNote.setSelected(true);
            this.selectedNotes = new ArrayList<NotePadMeta>();
            this.selectedNotes.add(this.selectedNote);
            this.previousNoteLocations = new Point[]{this.selectedNote.getLocation()};
            this.redraw();
        } else if (this.selectionRegion != null && this.startHopAction == null) {
            this.selectionRegion.width = real.x - this.selectionRegion.x;
            this.selectionRegion.height = real.y - this.selectionRegion.y;
            this.redraw();
        } else if (this.selectedAction != null && this.lastButton == 1 && !shift && this.startHopAction == null) {
            int i;
            int dx = icon.x - this.selectedAction.getLocation().x;
            dy = icon.y - this.selectedAction.getLocation().y;
            WorkflowHopMeta hi = this.findHop(icon.x + this.iconSize / 2, icon.y + this.iconSize / 2, this.selectedAction);
            if (hi != null) {
                if (!hi.getFromAction().equals((Object)this.selectedAction) && !hi.getToAction().equals((Object)this.selectedAction)) {
                    this.splitHop = true;
                    this.lastHopSplit = hi;
                    hi.split = true;
                }
            } else if (this.lastHopSplit != null) {
                this.lastHopSplit.split = false;
                this.lastHopSplit = null;
                this.splitHop = false;
            }
            this.selectedNotes = this.workflowMeta.getSelectedNotes();
            this.selectedActions = this.workflowMeta.getSelectedActions();
            if (this.selectedActions != null) {
                for (i = 0; i < this.selectedActions.size(); ++i) {
                    ActionMeta actionCopy2 = this.selectedActions.get(i);
                    PropsUi.setLocation((IGuiPosition)actionCopy2, actionCopy2.getLocation().x + dx, actionCopy2.getLocation().y + dy);
                }
            }
            if (this.selectedNotes != null) {
                for (i = 0; i < this.selectedNotes.size(); ++i) {
                    NotePadMeta ni = this.selectedNotes.get(i);
                    PropsUi.setLocation((IGuiPosition)ni, ni.getLocation().x + dx, ni.getLocation().y + dy);
                }
            }
            this.redraw();
        } else if (this.startHopAction != null && this.endHopAction == null || this.endHopAction != null && this.startHopAction == null) {
            actionCopy = this.workflowMeta.getAction(real.x, real.y, this.iconSize);
            this.endHopLocation = new Point(real.x, real.y);
            if (actionCopy != null && (this.startHopAction != null && !this.startHopAction.equals((Object)actionCopy) || this.endHopAction != null && !this.endHopAction.equals((Object)actionCopy))) {
                if (this.hopCandidate == null) {
                    if (this.startHopAction != null) {
                        if (!actionCopy.isStart()) {
                            this.hopCandidate = new WorkflowHopMeta(this.startHopAction, actionCopy);
                            this.endHopLocation = null;
                        } else {
                            this.noInputAction = actionCopy;
                            this.toolTip.setText("The start action can only be used at the start of a Workflow");
                            this.showToolTip(new org.eclipse.swt.graphics.Point(real.x, real.y));
                        }
                    } else if (this.endHopAction != null) {
                        this.hopCandidate = new WorkflowHopMeta(actionCopy, this.endHopAction);
                        this.endHopLocation = null;
                    }
                }
            } else if (this.hopCandidate != null) {
                this.hopCandidate = null;
                this.redraw();
            }
            this.redraw();
        } else if (this.viewDrag && this.lastClick != null) {
            this.dragView(this.viewDragStart, new Point(e.x, e.y));
        }
        if (this.selectedNote != null && this.lastButton == 1 && !shift) {
            int dx = note.x - this.selectedNote.getLocation().x;
            dy = note.y - this.selectedNote.getLocation().y;
            this.selectedNotes = this.workflowMeta.getSelectedNotes();
            this.selectedActions = this.workflowMeta.getSelectedActions();
            if (this.selectedActions != null) {
                for (int i = 0; i < this.selectedActions.size(); ++i) {
                    ActionMeta actionCopy3 = this.selectedActions.get(i);
                    PropsUi.setLocation((IGuiPosition)actionCopy3, actionCopy3.getLocation().x + dx, actionCopy3.getLocation().y + dy);
                }
            }
            if (this.selectedNotes != null) {
                for (int i = 0; i < this.selectedNotes.size(); ++i) {
                    NotePadMeta ni = this.selectedNotes.get(i);
                    PropsUi.setLocation((IGuiPosition)ni, ni.getLocation().x + dx, ni.getLocation().y + dy);
                }
            }
            this.redraw();
        }
    }

    public void mouseHover(MouseEvent e) {
        boolean tip = true;
        Point real = this.screen2real(e.x, e.y);
        if (tip) {
            this.setToolTip(real.x, real.y, e.x, e.y);
        }
    }

    public void mouseEnter(MouseEvent event) {
    }

    public void mouseExit(MouseEvent event) {
    }

    @Override
    public void adjustScrolling() {
        this.adjustScrolling(this.workflowMeta.getMaximum());
    }

    private void addCandidateAsHop() {
        if (this.hopCandidate != null) {
            if (this.hopCandidate.getFromAction() == null || this.hopCandidate.getToAction() == null) {
                return;
            }
            if (this.hopCandidate.getFromAction().equals((Object)this.hopCandidate.getToAction())) {
                return;
            }
            if (!this.hopCandidate.getFromAction().isEvaluation() && this.hopCandidate.getFromAction().isUnconditional()) {
                this.hopCandidate.setUnconditional();
            } else {
                this.hopCandidate.setConditional();
                int nr = this.workflowMeta.findNrNextActions(this.hopCandidate.getFromAction());
                if (nr == 1) {
                    ActionMeta jge = this.workflowMeta.findNextAction(this.hopCandidate.getFromAction(), 0);
                    WorkflowHopMeta other = this.workflowMeta.findWorkflowHop(this.hopCandidate.getFromAction(), jge);
                    if (other != null) {
                        this.hopCandidate.setEvaluation(!other.getEvaluation());
                    }
                }
            }
            if (this.checkIfHopAlreadyExists(this.workflowMeta, this.hopCandidate)) {
                boolean cancel = false;
                this.workflowMeta.addWorkflowHop(this.hopCandidate);
                if (this.workflowMeta.hasLoop(this.hopCandidate.getToAction())) {
                    MessageBox mb = new MessageBox(this.hopGui.getShell(), 296);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.HopCausesLoop.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.HopCausesLoop.Title", (String[])new String[0]));
                    int choice = mb.open();
                    if (choice == 256) {
                        this.workflowMeta.removeWorkflowHop(this.hopCandidate);
                        cancel = true;
                    }
                }
                if (!cancel) {
                    this.hopGui.undoDelegate.addUndoNew((IUndo)this.workflowMeta, new WorkflowHopMeta[]{this.hopCandidate}, new int[]{this.workflowMeta.indexOfWorkflowHop(this.hopCandidate)});
                }
                this.clearSettings();
                this.redraw();
            }
        }
    }

    public boolean checkIfHopAlreadyExists(WorkflowMeta workflowMeta, WorkflowHopMeta newHop) {
        boolean ok = true;
        if (workflowMeta.findWorkflowHop(newHop.getFromAction(), newHop.getToAction(), true) != null) {
            MessageBox mb = new MessageBox(this.hopShell(), 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.HopExists.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.HopExists.Title", (String[])new String[0]));
            mb.open();
            ok = false;
        }
        return ok;
    }

    public AreaOwner getVisibleAreaOwner(int x, int y) {
        for (int i = this.areaOwners.size() - 1; i >= 0; --i) {
            AreaOwner areaOwner = this.areaOwners.get(i);
            if (!areaOwner.contains(x, y)) continue;
            return areaOwner;
        }
        return null;
    }

    protected void asyncRedraw() {
        this.hopGui.getDisplay().asyncExec(() -> {
            if (!this.isDisposed()) {
                this.redraw();
            }
        });
    }

    @GuiToolbarElement(root="HopGuiWorkflowGraph-Toolbar", id="HopGuiWorkflowGraph-ToolBar-10500-Zoom-Level", label="i18n:org.apache.hop.ui.hopgui:HopGui.Toolbar.Zoom", toolTip="i18n::HopGuiWorkflowGraph.GuiAction.ZoomInOut.Tooltip", type=GuiToolbarElementType.COMBO, alignRight=true, comboValuesMethod="getZoomLevels")
    public void zoomLevel() {
        this.readMagnification();
        this.setFocus();
    }

    @Override
    @GuiToolbarElement(root="HopGuiWorkflowGraph-Toolbar", id="HopGuiWorkflowGraph-ToolBar-10510-Zoom-In", toolTip="i18n::HopGuiWorkflowGraph.GuiAction.ZoomIn.Tooltip", type=GuiToolbarElementType.BUTTON, image="ui/images/zoom-in.svg")
    public void zoomIn() {
        super.zoomIn();
    }

    @Override
    @GuiToolbarElement(root="HopGuiWorkflowGraph-Toolbar", id="HopGuiWorkflowGraph-ToolBar-10520-Zoom-Out", toolTip="i18n::HopGuiWorkflowGraph.GuiAction.ZoomOut.Tooltip", type=GuiToolbarElementType.BUTTON, image="ui/images/zoom-out.svg")
    public void zoomOut() {
        super.zoomOut();
    }

    @Override
    @GuiToolbarElement(root="HopGuiWorkflowGraph-Toolbar", id="HopGuiWorkflowGraph-ToolBar-10530-Zoom-100Pct", toolTip="i18n::HopGuiWorkflowGraph.GuiAction.Zoom100.Tooltip", type=GuiToolbarElementType.BUTTON, image="ui/images/zoom-100.svg")
    public void zoom100Percent() {
        super.zoom100Percent();
    }

    public List<String> getZoomLevels() {
        return Arrays.asList(PipelinePainter.magnificationDescriptions);
    }

    private void addToolBar() {
        try {
            this.toolBar = new ToolBar((Composite)this, 16704);
            this.toolBarWidgets = new GuiToolbarWidgets();
            this.toolBarWidgets.registerGuiPluginObject(this);
            this.toolBarWidgets.createToolbarWidgets((Composite)this.toolBar, GUI_PLUGIN_TOOLBAR_PARENT_ID);
            FormData layoutData = new FormData();
            layoutData.left = new FormAttachment(0, 0);
            layoutData.top = new FormAttachment(0, 0);
            layoutData.right = new FormAttachment(100, 0);
            this.toolBar.setLayoutData((Object)layoutData);
            this.toolBar.pack();
            PropsUi.getInstance().setLook((Control)this.toolBar, 6);
            this.updateGui();
        }
        catch (Throwable t) {
            this.log.logError("Error setting up the navigation toolbar for HopUI", t);
            new ErrorDialog(this.hopShell(), "Error", "Error setting up the navigation toolbar for HopGUI", new Exception(t));
        }
    }

    @Override
    public void setZoomLabel() {
        String oldString;
        Combo zoomLabel = (Combo)this.toolBarWidgets.getWidgetsMap().get(TOOLBAR_ITEM_ZOOM_LEVEL);
        if (zoomLabel == null || zoomLabel.isDisposed()) {
            return;
        }
        String newString = Math.round(this.magnification * 100.0f) + "%";
        if (!newString.equals(oldString = zoomLabel.getText())) {
            zoomLabel.setText(Math.round(this.magnification * 100.0f) + "%");
        }
    }

    @Override
    @GuiToolbarElement(root="HopGuiWorkflowGraph-Toolbar", id="HopGuiWorkflowGraph-ToolBar-10010-Run", toolTip="i18n::WorkflowGraph.Toolbar.Start.Tooltip", image="ui/images/run.svg")
    public void start() {
        this.workflowMeta.setShowDialog(this.workflowMeta.isAlwaysShowRunOptions());
        ServerPushSessionFacade.start();
        Thread thread = new Thread(){

            @Override
            public void run() {
                HopGuiWorkflowGraph.this.getDisplay().asyncExec(() -> {
                    try {
                        HopGuiWorkflowGraph.this.workflowRunDelegate.executeWorkflow(HopGuiWorkflowGraph.this.hopGui.getVariables(), HopGuiWorkflowGraph.this.workflowMeta, null);
                        ServerPushSessionFacade.stop();
                    }
                    catch (Exception e) {
                        new ErrorDialog(HopGuiWorkflowGraph.this.getShell(), "Execute workflow", "There was an error during workflow execution", e);
                    }
                });
            }
        };
        thread.start();
    }

    @Override
    @GuiToolbarElement(root="HopGuiWorkflowGraph-Toolbar", id="HopGuiWorkflowGraph-ToolBar-10030-Stop", toolTip="i18n::WorkflowGraph.Toolbar.Stop.Tooltip", image="ui/images/stop.svg")
    public void stop() {
        if (this.isRunning() && !this.halting) {
            this.halting = true;
            this.workflow.stopExecution();
            this.log.logBasic(BaseMessages.getString(PKG, (String)"WorkflowLog.Log.ProcessingOfWorkflowStopped", (String[])new String[0]));
            this.halting = false;
            this.updateGui();
        }
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void preview() {
    }

    @Override
    public void debug() {
    }

    private void readMagnification() {
        Combo zoomLabel = (Combo)this.toolBarWidgets.getWidgetsMap().get(TOOLBAR_ITEM_ZOOM_LEVEL);
        if (zoomLabel == null || zoomLabel.isDisposed()) {
            return;
        }
        String possibleText = zoomLabel.getText();
        possibleText = possibleText.replace("%", "");
        try {
            float possibleFloatMagnification;
            this.magnification = possibleFloatMagnification = Float.parseFloat(possibleText) / 100.0f;
            if (zoomLabel.getText().indexOf(37) < 0) {
                zoomLabel.setText(zoomLabel.getText().concat("%"));
            }
        }
        catch (Exception e) {
            MessageBox mb = new MessageBox(this.hopShell(), 65);
            mb.setMessage(BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.InvalidZoomMeasurement.Message", (String[])new String[]{zoomLabel.getText()}));
            mb.setText(BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.InvalidZoomMeasurement.Title", (String[])new String[0]));
            mb.open();
        }
        this.adjustScrolling();
        this.redraw();
    }

    public void selectInRect(WorkflowMeta workflowMeta, Rectangle rect) {
        int i;
        for (i = 0; i < workflowMeta.nrActions(); ++i) {
            ActionMeta je = workflowMeta.getAction(i);
            Point p = je.getLocation();
            if ((p.x < rect.x || p.x > rect.x + rect.width) && (p.x < rect.x + rect.width || p.x > rect.x) || (p.y < rect.y || p.y > rect.y + rect.height) && (p.y < rect.y + rect.height || p.y > rect.y)) continue;
            je.setSelected(true);
        }
        for (i = 0; i < workflowMeta.nrNotes(); ++i) {
            NotePadMeta ni = workflowMeta.getNote(i);
            Point a = ni.getLocation();
            Point b = new Point(a.x + ni.width, a.y + ni.height);
            if (!rect.contains(a.x, a.y) || !rect.contains(b.x, b.y)) continue;
            ni.setSelected(true);
        }
    }

    public boolean setFocus() {
        return this.canvas != null && !this.canvas.isDisposed() ? this.canvas.setFocus() : false;
    }

    public static void showOnlyStartOnceMessage(Shell shell) {
        MessageBox mb = new MessageBox(shell, 65);
        mb.setMessage(BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.OnlyUseStartOnce.Message", (String[])new String[0]));
        mb.setText(BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.OnlyUseStartOnce.Title", (String[])new String[0]));
        mb.open();
    }

    public void deleteSelected(ActionMeta selectedAction) {
        List selection = this.workflowMeta.getSelectedActions();
        if (this.currentAction == null && selectedAction == null && selection.isEmpty() && this.workflowMeta.getSelectedNotes().isEmpty()) {
            return;
        }
        if (selectedAction != null && selection.size() == 0) {
            this.workflowActionDelegate.deleteAction(this.workflowMeta, selectedAction);
            return;
        }
        if (selection.size() > 0) {
            this.workflowActionDelegate.deleteActions(this.workflowMeta, selection);
        }
        if (this.workflowMeta.getSelectedNotes().size() > 0) {
            this.notePadDelegate.deleteNotes((AbstractMeta)this.workflowMeta, this.workflowMeta.getSelectedNotes());
        }
    }

    public void clearSettings() {
        this.selectedAction = null;
        this.selectedNote = null;
        this.selectedActions = null;
        this.selectedNotes = null;
        this.selectionRegion = null;
        this.hopCandidate = null;
        this.lastHopSplit = null;
        this.lastButton = 0;
        this.startHopAction = null;
        this.endHopAction = null;
        this.iconOffset = null;
        this.workflowMeta.unselectAll();
        for (int i = 0; i < this.workflowMeta.nrWorkflowHops(); ++i) {
            this.workflowMeta.getWorkflowHop(i).setSplit(false);
        }
    }

    public Point getRealPosition(Composite canvas, int x, int y) {
        Point p = new Point(0, 0);
        for (Composite follow = canvas; follow != null; follow = follow.getParent()) {
            Point xy = new Point(follow.getLocation().x, follow.getLocation().y);
            p.x += xy.x;
            p.y += xy.y;
        }
        p.x = x - p.x - 8;
        p.y = y - p.y - 48;
        return this.screen2real(p.x, p.y);
    }

    private WorkflowHopMeta findWorkflowHop(int x, int y) {
        return this.findHop(x, y, null);
    }

    private WorkflowHopMeta findHop(int x, int y, ActionMeta exclude) {
        WorkflowHopMeta online = null;
        for (int i = 0; i < this.workflowMeta.nrWorkflowHops(); ++i) {
            int[] line;
            WorkflowHopMeta hi = this.workflowMeta.getWorkflowHop(i);
            ActionMeta fs = hi.getFromAction();
            ActionMeta ts = hi.getToAction();
            if (fs == null || ts == null) {
                return null;
            }
            if (exclude != null && (exclude.equals((Object)fs) || exclude.equals((Object)ts)) || !this.pointOnLine(x, y, line = this.getLine(fs, ts))) continue;
            online = hi;
        }
        return online;
    }

    protected int[] getLine(ActionMeta fs, ActionMeta ts) {
        if (fs == null || ts == null) {
            return null;
        }
        Point from = fs.getLocation();
        Point to = ts.getLocation();
        this.offset = this.getOffset();
        int x1 = from.x + this.iconSize / 2;
        int y1 = from.y + this.iconSize / 2;
        int x2 = to.x + this.iconSize / 2;
        int y2 = to.y + this.iconSize / 2;
        return new int[]{x1, y1, x2, y2};
    }

    @GuiContextAction(id="workflow-graph-action-10050-create-hop", parentId="HopGuiWorkflowActionContext", type=GuiActionType.Create, name="i18n::HopGuiWorkflowGraph.ContextualAction.CreateHop.Text", tooltip="i18n::HopGuiWorkflowGraph.ContextualAction.CreateHop.Tooltip", image="ui/images/hop.svg", category="i18n::HopGuiWorkflowGraph.ContextualAction.Category.Basic.Text", categoryOrder="1")
    public void newHopCandidate(HopGuiWorkflowActionContext context) {
        this.startHopAction = context.getActionMeta();
        this.endHopAction = null;
        this.redraw();
    }

    @GuiContextAction(id="workflow-graph-action-10800-edit-description", parentId="HopGuiWorkflowActionContext", type=GuiActionType.Modify, name="i18n::HopGuiWorkflowGraph.ContextualAction.EditActionDescription.Text", tooltip="i18n::HopGuiWorkflowGraph.ContextualAction.EditActionDescription.Tooltip", image="ui/images/edit_description.svg", category="i18n::HopGuiWorkflowGraph.ContextualAction.Category.Basic.Text", categoryOrder="1")
    public void editActionDescription(HopGuiWorkflowActionContext context) {
        ActionMeta action = context.getActionMeta();
        String title = BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.EditDescription.Title", (String[])new String[0]);
        String message = BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.EditDescription.Message", (String[])new String[0]);
        EnterTextDialog dialog = new EnterTextDialog(this.hopShell(), title, message, context.getActionMeta().getDescription());
        String description = dialog.open();
        if (description != null) {
            action.setDescription(description);
            action.setChanged();
            this.updateGui();
        }
    }

    @GuiContextAction(id="workflow-graph-transform-10600-parallel", parentId="HopGuiWorkflowActionContext", type=GuiActionType.Modify, name="i18n::HopGuiWorkflowGraph.ContextualAction.ParallelExecution.Text", tooltip="i18n::HopGuiWorkflowGraph.ContextualAction.ParallelExecution.Tooltip", image="ui/images/parallel.svg", category="i18n::HopGuiWorkflowGraph.ContextualAction.Category.Advanced.Text", categoryOrder="3")
    public void editActionParallel(HopGuiWorkflowActionContext context) {
        ActionMeta action = context.getActionMeta();
        ActionMeta originalAction = (ActionMeta)action.cloneDeep();
        action.setLaunchingInParallel(!action.isLaunchingInParallel());
        ActionMeta jeNew = (ActionMeta)action.cloneDeep();
        this.hopGui.undoDelegate.addUndoChange((IUndo)this.workflowMeta, new ActionMeta[]{originalAction}, new ActionMeta[]{jeNew}, new int[]{this.workflowMeta.indexOfAction(jeNew)});
        this.workflowMeta.setChanged();
        if (action.isLaunchingInParallel() && "Y".equalsIgnoreCase(this.hopGui.getProps().getCustomParameter(STRING_PARALLEL_WARNING_PARAMETER, "Y"))) {
            MessageDialogWithToggle md = new MessageDialogWithToggle(this.hopShell(), BaseMessages.getString(PKG, (String)"WorkflowGraph.ParallelActionsWarning.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"WorkflowGraph.ParallelActionsWarning.DialogMessage", (String[])new String[]{Const.CR}) + Const.CR, 8, new String[]{BaseMessages.getString(PKG, (String)"WorkflowGraph.ParallelActionsWarning.Option1", (String[])new String[0])}, BaseMessages.getString(PKG, (String)"WorkflowGraph.ParallelActionsWarning.Option2", (String[])new String[0]), "N".equalsIgnoreCase(this.hopGui.getProps().getCustomParameter(STRING_PARALLEL_WARNING_PARAMETER, "Y")));
            md.open();
            this.hopGui.getProps().setCustomParameter(STRING_PARALLEL_WARNING_PARAMETER, md.getToggleState() ? "N" : "Y");
        }
        this.redraw();
    }

    @GuiContextAction(id="workflow-graph-action-10900-delete", parentId="HopGuiWorkflowActionContext", type=GuiActionType.Delete, name="i18n::HopGuiWorkflowGraph.ContextualAction.DeleteAction.Text", tooltip="i18n::HopGuiWorkflowGraph.ContextualAction.DeleteAction.Tooltip", image="ui/images/delete.svg", category="i18n::HopGuiWorkflowGraph.ContextualAction.Category.Basic.Text", categoryOrder="1")
    public void deleteAction(HopGuiWorkflowActionContext context) {
        this.deleteSelected(context.getActionMeta());
        this.adjustScrolling();
        this.redraw();
    }

    protected synchronized void setMenu(int x, int y) {
        this.currentMouseX = x;
        this.currentMouseY = y;
    }

    @Override
    @GuiKeyboardShortcut(control=true, key=97)
    @GuiOsxKeyboardShortcut(command=true, key=97)
    public void selectAll() {
        this.workflowMeta.selectAll();
        this.updateGui();
    }

    @Override
    @GuiKeyboardShortcut(key=27)
    public void unselectAll() {
        this.clearSettings();
        this.updateGui();
    }

    @Override
    @GuiKeyboardShortcut(control=true, key=99)
    @GuiOsxKeyboardShortcut(command=true, key=99)
    public void copySelectedToClipboard() {
        if (this.workflowLogDelegate.hasSelectedText()) {
            this.workflowLogDelegate.copySelected();
        } else {
            this.workflowClipboardDelegate.copySelected(this.workflowMeta, this.workflowMeta.getSelectedActions(), this.workflowMeta.getSelectedNotes());
        }
    }

    @Override
    @GuiKeyboardShortcut(control=true, key=120)
    @GuiOsxKeyboardShortcut(command=true, key=120)
    public void cutSelectedToClipboard() {
        this.workflowClipboardDelegate.copySelected(this.workflowMeta, this.workflowMeta.getSelectedActions(), this.workflowMeta.getSelectedNotes());
        this.deleteSelected();
    }

    @Override
    @GuiKeyboardShortcut(key=127)
    public void deleteSelected() {
        this.deleteSelected(null);
    }

    @Override
    @GuiKeyboardShortcut(control=true, key=118)
    @GuiOsxKeyboardShortcut(command=true, key=118)
    public void pasteFromClipboard() {
        this.workflowClipboardDelegate.pasteXml(this.workflowMeta, this.workflowClipboardDelegate.fromClipboard(), this.lastMove == null ? new Point(50, 50) : this.lastMove);
    }

    @GuiContextAction(id="workflow-graph-workflow-clipboard-paste", parentId="HopGuiWorkflowContext", type=GuiActionType.Modify, name="i18n::HopGuiWorkflowGraph.ContextualAction.PasteFromClipboard.Text", tooltip="i18n::HopGuiWorkflowGraph.ContextualAction.PasteFromClipboard.Tooltip", image="ui/images/paste.svg", category="i18n::HopGuiWorkflowGraph.ContextualAction.Category.Basic.Text", categoryOrder="1")
    public void pasteFromClipboard(HopGuiWorkflowContext context) {
        this.workflowClipboardDelegate.pasteXml(this.workflowMeta, this.workflowClipboardDelegate.fromClipboard(), context.getClick());
        this.adjustScrolling();
    }

    @GuiContextAction(id="workflow-graph-edit-workflow", parentId="HopGuiWorkflowContext", type=GuiActionType.Modify, name="i18n::HopGuiWorkflowGraph.ContextualAction.EditWorkflow.Text", tooltip="i18n::HopGuiWorkflowGraph.ContextualAction.EditWorkflow.Tooltip", image="ui/images/workflow.svg", category="i18n::HopGuiWorkflowGraph.ContextualAction.Category.Basic.Text", categoryOrder="1")
    public void editWorkflowProperties(HopGuiWorkflowContext context) {
        this.editProperties(this.workflowMeta, this.hopGui, true);
    }

    @GuiToolbarElement(root="HopGuiWorkflowGraph-Toolbar", id="HopGuiWorkflowGrpah-ToolBar-10450-EditWorkflow", toolTip="i18n::WorkflowGraph.Toolbar.EditWorkflow.Tooltip", image="ui/images/workflow.svg")
    @GuiKeyboardShortcut(control=true, key=108)
    @GuiOsxKeyboardShortcut(command=true, key=108)
    public void editWorkflowProperties() {
        this.editProperties(this.workflowMeta, this.hopGui, true);
    }

    @GuiContextAction(id="workflow-graph-new-note", parentId="HopGuiWorkflowContext", type=GuiActionType.Create, name="i18n::HopGuiWorkflowGraph.ContextualAction.CreateNote.Text", tooltip="i18n::HopGuiWorkflowGraph.ContextualAction.CreateNote.Tooltip", image="ui/images/note-add.svg", category="i18n::HopGuiWorkflowGraph.ContextualAction.Category.Basic.Text", categoryOrder="1")
    public void newNote(HopGuiWorkflowContext context) {
        String title = BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.EditNote.Title", (String[])new String[0]);
        NotePadDialog dd = new NotePadDialog(this.variables, this.hopShell(), title);
        NotePadMeta n = dd.open();
        if (n != null) {
            NotePadMeta npi = new NotePadMeta(n.getNote(), context.getClick().x, context.getClick().y, 20, 20, n.getFontName(), n.getFontSize(), n.isFontBold(), n.isFontItalic(), n.getFontColorRed(), n.getFontColorGreen(), n.getFontColorBlue(), n.getBackGroundColorRed(), n.getBackGroundColorGreen(), n.getBackGroundColorBlue(), n.getBorderColorRed(), n.getBorderColorGreen(), n.getBorderColorBlue());
            this.workflowMeta.addNote(npi);
            this.hopGui.undoDelegate.addUndoNew((IUndo)this.workflowMeta, new NotePadMeta[]{npi}, new int[]{this.workflowMeta.indexOfNote(npi)});
            this.adjustScrolling();
            this.redraw();
        }
    }

    public void setCurrentNote(NotePadMeta ni) {
        this.ni = ni;
    }

    public NotePadMeta getCurrentNote() {
        return this.ni;
    }

    @GuiContextAction(id="workflow-graph-10-edit-note", parentId="HopGuiWorkflowNoteContext", type=GuiActionType.Modify, name="i18n::HopGuiWorkflowGraph.ContextualAction.EditNote.Text", tooltip="i18n::HopGuiWorkflowGraph.ContextualAction.EditNote.Tooltip", image="ui/images/edit.svg", category="i18n::HopGuiWorkflowGraph.ContextualAction.Category.Basic.Text", categoryOrder="1")
    public void editNote(HopGuiWorkflowNoteContext context) {
        this.selectionRegion = null;
        this.editNote(context.getNotePadMeta());
    }

    @GuiContextAction(id="workflow-graph-20-delete-note", parentId="HopGuiWorkflowNoteContext", type=GuiActionType.Delete, name="i18n::HopGuiWorkflowGraph.ContextualAction.DeleteNote.Text", tooltip="HopGuiWorkflowGraph.ContextualAction.DeleteNote.Tooltip", image="ui/images/delete.svg", category="i18n::HopGuiWorkflowGraph.ContextualAction.Category.Basic.Text", categoryOrder="1")
    public void deleteNote(HopGuiWorkflowNoteContext context) {
        this.selectionRegion = null;
        NotePadMeta note = context.getNotePadMeta();
        int idx = this.workflowMeta.indexOfNote(note);
        if (idx >= 0) {
            this.workflowMeta.removeNote(idx);
            this.hopGui.undoDelegate.addUndoDelete((IUndo)this.workflowMeta, new NotePadMeta[]{note}, new int[]{idx});
        }
        this.adjustScrolling();
        this.redraw();
    }

    public void raiseNote() {
        this.selectionRegion = null;
        int idx = this.workflowMeta.indexOfNote(this.getCurrentNote());
        if (idx >= 0) {
            this.workflowMeta.raiseNote(idx);
        }
        this.redraw();
    }

    public void lowerNote() {
        this.selectionRegion = null;
        int idx = this.workflowMeta.indexOfNote(this.getCurrentNote());
        if (idx >= 0) {
            this.workflowMeta.lowerNote(idx);
        }
        this.redraw();
    }

    @GuiContextAction(id="workflow-graph-hop-10010-hop-enable", parentId="HopGuiWorkflowHopContext", type=GuiActionType.Modify, name="i18n::HopGuiWorkflowGraph.ContextualAction.EnableHop.Text", tooltip="i18n::HopGuiWorkflowGraph.ContextualAction.EnableHop.Tooltip", image="ui/images/hop.svg", category="i18n::HopGuiWorkflowGraph.ContextualAction.Category.Basic.Text", categoryOrder="1")
    public void enableHop(HopGuiWorkflowHopContext context) {
        WorkflowHopMeta hop = context.getHopMeta();
        if (!hop.isEnabled()) {
            WorkflowHopMeta before = hop.clone();
            hop.setEnabled(true);
            if (this.checkHopLoop(hop, false)) {
                WorkflowHopMeta after = hop.clone();
                this.hopGui.undoDelegate.addUndoChange((IUndo)this.workflowMeta, new WorkflowHopMeta[]{before}, new WorkflowHopMeta[]{after}, new int[]{this.workflowMeta.indexOfWorkflowHop(hop)});
            }
            this.updateGui();
        }
    }

    @GuiContextAction(id="workflow-graph-hop-10000-hop-disable", parentId="HopGuiWorkflowHopContext", type=GuiActionType.Modify, name="i18n::HopGuiWorkflowGraph.ContextualAction.DisableHop.Text", tooltip="i18n::HopGuiWorkflowGraph.ContextualAction.DisableHop.Tooltip", image="ui/images/HOP_disable.svg", category="i18n::HopGuiWorkflowGraph.ContextualAction.Category.Basic.Text", categoryOrder="1")
    public void disableHop(HopGuiWorkflowHopContext context) {
        WorkflowHopMeta hop = context.getHopMeta();
        if (hop.isEnabled()) {
            WorkflowHopMeta before = hop.clone();
            hop.setEnabled(false);
            this.updateGui();
            WorkflowHopMeta after = hop.clone();
            this.hopGui.undoDelegate.addUndoChange((IUndo)this.workflowMeta, new WorkflowHopMeta[]{before}, new WorkflowHopMeta[]{after}, new int[]{this.workflowMeta.indexOfWorkflowHop(hop)});
        }
    }

    private boolean checkHopLoop(WorkflowHopMeta hop, boolean originalState) {
        if (!originalState && this.workflowMeta.hasLoop(hop.getToAction())) {
            MessageBox mb = new MessageBox(this.hopShell(), 296);
            mb.setMessage(BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.LoopAfterHopEnabled.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.LoopAfterHopEnabled.Title", (String[])new String[0]));
            int choice = mb.open();
            if (choice == 256) {
                hop.setEnabled(originalState);
                return false;
            }
        }
        return true;
    }

    @GuiContextAction(id="workflow-graph-hop-10020-hop-delete", parentId="HopGuiWorkflowHopContext", type=GuiActionType.Delete, name="i18n::HopGuiWorkflowGraph.ContextualAction.DeleteHop.Text", tooltip="i18n::HopGuiWorkflowGraph.ContextualAction.DeleteHop.Tooltip", image="ui/images/HOP_delete.svg", category="i18n::HopGuiWorkflowGraph.ContextualAction.Category.Basic.Text", categoryOrder="1")
    public void deleteHop(HopGuiWorkflowHopContext context) {
        this.workflowHopDelegate.delHop(this.workflowMeta, context.getHopMeta());
        this.updateGui();
    }

    @GuiContextAction(id="workflow-graph-hop-10030-hop-unconditional", parentId="HopGuiWorkflowHopContext", type=GuiActionType.Modify, name="i18n::HopGuiWorkflowGraph.ContextualAction.UnconditionalHop.Text", tooltip="i18n::HopGuiWorkflowGraph.ContextualAction.UnconditionalHop.Tooltip", image="ui/images/unconditional.svg", category="i18n::HopGuiWorkflowGraph.ContextualAction.Category.Routing.Text", categoryOrder="2")
    public void setHopUnconditional(HopGuiWorkflowHopContext context) {
        WorkflowHopMeta hop = context.getHopMeta();
        WorkflowHopMeta before = hop.clone();
        if (!hop.isUnconditional()) {
            hop.setUnconditional();
            WorkflowHopMeta after = hop.clone();
            this.hopGui.undoDelegate.addUndoChange((IUndo)this.workflowMeta, new WorkflowHopMeta[]{before}, new WorkflowHopMeta[]{after}, new int[]{this.workflowMeta.indexOfWorkflowHop(hop)});
        }
        this.updateGui();
    }

    @GuiContextAction(id="workflow-graph-hop-10040-hop-evaluation-success", parentId="HopGuiWorkflowHopContext", type=GuiActionType.Modify, name="i18n::HopGuiWorkflowGraph.ContextualAction.SuccessHop.Text", tooltip="i18n::HopGuiWorkflowGraph.ContextualAction.SuccessHop.Tooltip", image="ui/images/true.svg", category="i18n::HopGuiWorkflowGraph.ContextualAction.Category.Routing.Text", categoryOrder="2")
    public void setHopEvaluationTrue(HopGuiWorkflowHopContext context) {
        WorkflowHopMeta hop = context.getHopMeta();
        WorkflowHopMeta before = hop.clone();
        hop.setConditional();
        hop.setEvaluation(true);
        WorkflowHopMeta after = hop.clone();
        this.hopGui.undoDelegate.addUndoChange((IUndo)this.workflowMeta, new WorkflowHopMeta[]{before}, new WorkflowHopMeta[]{after}, new int[]{this.workflowMeta.indexOfWorkflowHop(hop)});
        this.updateGui();
    }

    @GuiContextAction(id="workflow-graph-hop-10050-hop-evaluation-failure", parentId="HopGuiWorkflowHopContext", type=GuiActionType.Modify, name="i18n::HopGuiWorkflowGraph.ContextualAction.FailureHop.Text", tooltip="i18n::HopGuiWorkflowGraph.ContextualAction.FailureHop.Tooltip", image="ui/images/false.svg", category="i18n::HopGuiWorkflowGraph.ContextualAction.Category.Routing.Text", categoryOrder="2")
    public void setHopEvaluationFalse(HopGuiWorkflowHopContext context) {
        WorkflowHopMeta hop = context.getHopMeta();
        WorkflowHopMeta before = hop.clone();
        hop.setConditional();
        hop.setEvaluation(false);
        WorkflowHopMeta after = hop.clone();
        this.hopGui.undoDelegate.addUndoChange((IUndo)this.workflowMeta, new WorkflowHopMeta[]{before}, new WorkflowHopMeta[]{after}, new int[]{this.workflowMeta.indexOfWorkflowHop(hop)});
        this.updateGui();
    }

    @GuiContextActionFilter(parentId="HopGuiWorkflowHopContext")
    public boolean filterWorkflowHopActions(String contextActionId, HopGuiWorkflowHopContext context) {
        if (contextActionId.equals(ACTION_ID_WORKFLOW_GRAPH_HOP_ENABLE)) {
            return !context.getHopMeta().isEnabled();
        }
        if (contextActionId.equals(ACTION_ID_WORKFLOW_GRAPH_HOP_DISABLE)) {
            return context.getHopMeta().isEnabled();
        }
        return true;
    }

    public void enableHopsBetweenSelectedActions() {
        this.enableHopsBetweenSelectedActions(true);
    }

    public void disableHopsBetweenSelectedActions() {
        this.enableHopsBetweenSelectedActions(false);
    }

    public void enableHopsBetweenSelectedActions(boolean enabled) {
        List list = this.workflowMeta.getSelectedActions();
        boolean hasLoop = false;
        for (int i = 0; i < this.workflowMeta.nrWorkflowHops(); ++i) {
            WorkflowHopMeta hop = this.workflowMeta.getWorkflowHop(i);
            if (!list.contains(hop.getFromAction()) || !list.contains(hop.getToAction())) continue;
            WorkflowHopMeta before = hop.clone();
            hop.setEnabled(enabled);
            WorkflowHopMeta after = hop.clone();
            this.hopGui.undoDelegate.addUndoChange((IUndo)this.workflowMeta, new WorkflowHopMeta[]{before}, new WorkflowHopMeta[]{after}, new int[]{this.workflowMeta.indexOfWorkflowHop(hop)});
            if (!this.workflowMeta.hasLoop(hop.getToAction())) continue;
            hasLoop = true;
        }
        if (hasLoop && enabled) {
            MessageBox mb = new MessageBox(this.hopShell(), 40);
            mb.setMessage(BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.LoopAfterHopEnabled.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.LoopAfterHopEnabled.Title", (String[])new String[0]));
            mb.open();
        }
        this.updateGui();
    }

    @GuiContextAction(id="workflow-graph-hop-10060-hop-enable-downstream", parentId="HopGuiWorkflowHopContext", type=GuiActionType.Modify, name="i18n::HopGuiWorkflowGraph.ContextualAction.EnableDownstream.Text", tooltip="i18n::HopGuiWorkflowGraph.ContextualAction.EnableDownstream.Tooltip", image="ui/images/HOP_enable_downstream.svg", category="i18n::HopGuiWorkflowGraph.ContextualAction.Category.Bulk.Text", categoryOrder="3")
    public void enableHopsDownstream(HopGuiWorkflowHopContext context) {
        this.enableDisableHopsDownstream(context.getHopMeta(), true);
    }

    @GuiContextAction(id="workflow-graph-hop-10070-hop-disable-downstream", parentId="HopGuiWorkflowHopContext", type=GuiActionType.Modify, name="i18n::HopGuiWorkflowGraph.ContextualAction.DisableDownstream.Text", tooltip="i18n::HopGuiWorkflowGraph.ContextualAction.DisableDownstream.Tooltip", image="ui/images/HOP_disable_downstream.svg", category="i18n::HopGuiWorkflowGraph.ContextualAction.Category.Bulk.Text", categoryOrder="3")
    public void disableHopsDownstream(HopGuiWorkflowHopContext context) {
        this.enableDisableHopsDownstream(context.getHopMeta(), false);
    }

    public void enableDisableHopsDownstream(WorkflowHopMeta hop, boolean enabled) {
        if (hop == null) {
            return;
        }
        WorkflowHopMeta before = hop.clone();
        hop.setEnabled(enabled);
        WorkflowHopMeta after = hop.clone();
        this.hopGui.undoDelegate.addUndoChange((IUndo)this.workflowMeta, new WorkflowHopMeta[]{before}, new WorkflowHopMeta[]{after}, new int[]{this.workflowMeta.indexOfWorkflowHop(hop)});
        Set<ActionMeta> checkedActions = this.enableDisableNextHops(hop.getToAction(), enabled, new HashSet<ActionMeta>());
        if (checkedActions.stream().anyMatch(action -> this.workflowMeta.hasLoop(action))) {
            MessageBox mb = new MessageBox(this.hopShell(), 40);
            mb.setMessage(BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.LoopAfterHopEnabled.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.LoopAfterHopEnabled.Title", (String[])new String[0]));
            mb.open();
        }
        this.updateGui();
    }

    private Set<ActionMeta> enableDisableNextHops(ActionMeta from, boolean enabled, Set<ActionMeta> checkedActions) {
        checkedActions.add(from);
        this.workflowMeta.getWorkflowHops().stream().filter(hop -> from.equals((Object)hop.getFromAction())).forEach(hop -> {
            if (hop.isEnabled() != enabled) {
                WorkflowHopMeta before = hop.clone();
                hop.setEnabled(enabled);
                WorkflowHopMeta after = hop.clone();
                this.hopGui.undoDelegate.addUndoChange((IUndo)this.workflowMeta, new WorkflowHopMeta[]{before}, new WorkflowHopMeta[]{after}, new int[]{this.workflowMeta.indexOfWorkflowHop(hop)});
            }
            if (!checkedActions.contains(hop.getToAction())) {
                this.enableDisableNextHops(hop.getToAction(), enabled, checkedActions);
            }
        });
        return checkedActions;
    }

    private void modalMessageDialog(String title, String message, int swtFlags) {
        MessageBox messageBox = new MessageBox(this.hopShell(), swtFlags);
        messageBox.setMessage(message);
        messageBox.setText(title);
        messageBox.open();
    }

    protected void setToolTip(int x, int y, int screenX, int screenY) {
        if (!this.hopGui.getProps().showToolTips()) {
            return;
        }
        this.canvas.setToolTipText(null);
        Image tipImage = null;
        WorkflowHopMeta hi = this.findWorkflowHop(x, y);
        StringBuilder tip = new StringBuilder();
        AreaOwner areaOwner = this.getVisibleAreaOwner(x, y);
        if (areaOwner != null && areaOwner.getAreaType() != null) {
            switch (areaOwner.getAreaType()) {
                case WORKFLOW_HOP_ICON: {
                    hi = (WorkflowHopMeta)areaOwner.getOwner();
                    if (hi.isUnconditional()) {
                        tipImage = GuiResource.getInstance().getImageUnconditionalHop();
                        tip.append(BaseMessages.getString(PKG, (String)"WorkflowGraph.Hop.Tooltip.Unconditional", (String[])new String[]{hi.getFromAction().getName(), Const.CR}));
                        break;
                    }
                    if (hi.getEvaluation()) {
                        tip.append(BaseMessages.getString(PKG, (String)"WorkflowGraph.Hop.Tooltip.EvaluatingTrue", (String[])new String[]{hi.getFromAction().getName(), Const.CR}));
                        tipImage = GuiResource.getInstance().getImageTrue();
                        break;
                    }
                    tip.append(BaseMessages.getString(PKG, (String)"WorkflowGraph.Hop.Tooltip.EvaluatingFalse", (String[])new String[]{hi.getFromAction().getName(), Const.CR}));
                    tipImage = GuiResource.getInstance().getImageFalse();
                    break;
                }
                case WORKFLOW_HOP_PARALLEL_ICON: {
                    hi = (WorkflowHopMeta)areaOwner.getOwner();
                    tip.append(BaseMessages.getString(PKG, (String)"WorkflowGraph.Hop.Tooltip.Parallel", (String[])new String[]{hi.getFromAction().getName(), Const.CR}));
                    tipImage = GuiResource.getInstance().getImageParallelHop();
                    break;
                }
                case CUSTOM: {
                    String message = (String)areaOwner.getOwner();
                    tip.append(message);
                    tipImage = null;
                    GuiResource.getInstance().getImagePipeline();
                    break;
                }
                case ACTION_RESULT_FAILURE: 
                case ACTION_RESULT_SUCCESS: {
                    ActionResult actionResult = (ActionResult)areaOwner.getOwner();
                    ActionMeta actionCopy = (ActionMeta)areaOwner.getParent();
                    Result result = actionResult.getResult();
                    tip.append("'").append(actionCopy.getName()).append("' ");
                    if (result.getResult()) {
                        tipImage = GuiResource.getInstance().getImageSuccess();
                        tip.append("finished successfully.");
                    } else {
                        tipImage = GuiResource.getInstance().getImageFailure();
                        tip.append("failed.");
                    }
                    tip.append(Const.CR).append("------------------------").append(Const.CR).append(Const.CR);
                    tip.append("Result         : ").append(result.getResult()).append(Const.CR);
                    tip.append("Errors         : ").append(result.getNrErrors()).append(Const.CR);
                    if (result.getNrLinesRead() > 0L) {
                        tip.append("Lines read     : ").append(result.getNrLinesRead()).append(Const.CR);
                    }
                    if (result.getNrLinesWritten() > 0L) {
                        tip.append("Lines written  : ").append(result.getNrLinesWritten()).append(Const.CR);
                    }
                    if (result.getNrLinesInput() > 0L) {
                        tip.append("Lines input    : ").append(result.getNrLinesInput()).append(Const.CR);
                    }
                    if (result.getNrLinesOutput() > 0L) {
                        tip.append("Lines output   : ").append(result.getNrLinesOutput()).append(Const.CR);
                    }
                    if (result.getNrLinesUpdated() > 0L) {
                        tip.append("Lines updated  : ").append(result.getNrLinesUpdated()).append(Const.CR);
                    }
                    if (result.getNrLinesDeleted() > 0L) {
                        tip.append("Lines deleted  : ").append(result.getNrLinesDeleted()).append(Const.CR);
                    }
                    if (result.getNrLinesRejected() > 0L) {
                        tip.append("Lines rejected : ").append(result.getNrLinesRejected()).append(Const.CR);
                    }
                    if (result.getResultFiles() != null && !result.getResultFiles().isEmpty()) {
                        tip.append(Const.CR).append("Result files:").append(Const.CR);
                        if (result.getResultFiles().size() > 10) {
                            tip.append(" (10 files of ").append(result.getResultFiles().size()).append(" shown");
                        }
                        ArrayList files = new ArrayList(result.getResultFiles().values());
                        for (int i = 0; i < files.size(); ++i) {
                            ResultFile file = (ResultFile)files.get(i);
                            tip.append("  - ").append(file.toString()).append(Const.CR);
                        }
                    }
                    if (result.getRows() == null || result.getRows().isEmpty()) break;
                    tip.append(Const.CR).append("Result rows: ");
                    if (result.getRows().size() > 10) {
                        tip.append(" (10 rows of ").append(result.getRows().size()).append(" shown");
                    }
                    tip.append(Const.CR);
                    for (int i = 0; i < result.getRows().size() && i < 10; ++i) {
                        RowMetaAndData row = (RowMetaAndData)result.getRows().get(i);
                        tip.append("  - ").append(row.toString()).append(Const.CR);
                    }
                    break;
                }
                case ACTION_RESULT_CHECKPOINT: {
                    tip.append("The workflow started here since this is the furthest checkpoint that was reached last time the pipeline was executed.");
                    tipImage = GuiResource.getInstance().getImageCheckpoint();
                    break;
                }
                case ACTION_ICON: {
                    ActionMeta jec = (ActionMeta)areaOwner.getOwner();
                    if (!jec.isDeprecated()) break;
                    tip.append(BaseMessages.getString(PKG, (String)"WorkflowGraph.DeprecatedEntry.Tooltip.Title", (String[])new String[0])).append(Const.CR);
                    String tipNext = BaseMessages.getString(PKG, (String)"WorkflowGraph.DeprecatedEntry.Tooltip.Message1", (String[])new String[]{jec.getName()});
                    int length = tipNext.length() + 5;
                    for (int i = 0; i < length; ++i) {
                        tip.append("-");
                    }
                    tip.append(Const.CR).append(tipNext).append(Const.CR);
                    tip.append(BaseMessages.getString(PKG, (String)"WorkflowGraph.DeprecatedEntry.Tooltip.Message2", (String[])new String[0]));
                    if (!(Utils.isEmpty((CharSequence)jec.getSuggestion()) || jec.getSuggestion().startsWith("!") && jec.getSuggestion().endsWith("!"))) {
                        tip.append(" ");
                        tip.append(BaseMessages.getString(PKG, (String)"WorkflowGraph.DeprecatedEntry.Tooltip.Message3", (String[])new String[]{jec.getSuggestion()}));
                    }
                    tipImage = GuiResource.getInstance().getImageDeprecated();
                    break;
                }
                default: {
                    try {
                        HopGuiTooltipExtension tooltipExt = new HopGuiTooltipExtension(x, y, screenX, screenY, areaOwner, tip);
                        ExtensionPointHandler.callExtensionPoint((ILogChannel)this.hopGui.getLog(), (IVariables)this.variables, (String)HopExtensionPoint.HopGuiWorkflowGraphAreaHover.name(), (Object)tooltipExt);
                        tipImage = tooltipExt.tooltipImage;
                        break;
                    }
                    catch (Exception ex) {
                        this.hopGui.getLog().logError("Error calling extension point " + HopExtensionPoint.HopGuiWorkflowGraphAreaHover.name(), (Throwable)ex);
                    }
                }
            }
        }
        if (hi != null && tip.length() == 0) {
            tip.append(BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.HopInfo", (String[])new String[0])).append(Const.CR);
            tip.append(BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.HopInfo.SourceEntry", (String[])new String[0])).append(" ").append(hi.getFromAction().getName()).append(Const.CR);
            tip.append(BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.HopInfo.TargetEntry", (String[])new String[0])).append(" ").append(hi.getToAction().getName()).append(Const.CR);
            tip.append(BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.HopInfo.Status", (String[])new String[0])).append(" ");
            tip.append(hi.isEnabled() ? BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.HopInfo.Enable", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.HopInfo.Disable", (String[])new String[0]));
            tipImage = hi.isUnconditional() ? GuiResource.getInstance().getImageUnconditionalHop() : (hi.getEvaluation() ? GuiResource.getInstance().getImageTrue() : GuiResource.getInstance().getImageFalse());
        }
        if (tip == null || tip.length() == 0) {
            this.toolTip.setVisible(false);
        } else if (!tip.toString().equalsIgnoreCase(this.getToolTipText())) {
            this.toolTip.setText(tip.toString());
            this.toolTip.setVisible(false);
            this.showToolTip(new org.eclipse.swt.graphics.Point(screenX, screenY));
        }
    }

    public void launchStuff(ActionMeta actionCopy) {
        CharSequence[] references = actionCopy.getAction().getReferencedObjectDescriptions();
        if (!Utils.isEmpty((CharSequence[])references)) {
            this.loadReferencedObject(actionCopy, 0);
        }
    }

    protected void loadReferencedObject(ActionMeta actionCopy, int index) {
        try {
            IHasFilename referencedMeta = actionCopy.getAction().loadReferencedObject(index, (IHopMetadataProvider)this.hopGui.getMetadataProvider(), this.variables);
            if (referencedMeta == null) {
                return;
            }
            IHopFileType fileTypeHandler = this.hopGui.getPerspectiveManager().findFileTypeHandler(referencedMeta);
            fileTypeHandler.openFile(this.hopGui, referencedMeta.getFilename(), this.hopGui.getVariables());
        }
        catch (Exception e) {
            new ErrorDialog(this.hopShell(), BaseMessages.getString(PKG, (String)"HopGuiWorkflowGraph.ErrorDialog.FileNotLoaded.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGuiWorkflowGraph.ErrorDialog.FileNotLoaded.Message", (String[])new String[0]), e);
        }
    }

    public synchronized void setWorkflow(IWorkflowEngine<WorkflowMeta> workflow) {
        this.workflow = workflow;
    }

    public void paintControl(PaintEvent e) {
        Point area = this.getArea();
        if (area.x == 0 || area.y == 0) {
            return;
        }
        boolean needsDoubleBuffering = Const.isWindows() && "GUI".equalsIgnoreCase(Const.getHopPlatformRuntime());
        Image image = null;
        GC swtGc = e.gc;
        if (needsDoubleBuffering) {
            image = new Image((Device)this.hopDisplay(), area.x, area.y);
            swtGc = new GC((Drawable)image);
        }
        try {
            this.drawWorkflowImage(swtGc, area.x, area.y, this.magnification);
            if (needsDoubleBuffering) {
                e.gc.drawImage(image, 0, 0);
                swtGc.dispose();
                image.dispose();
            }
        }
        catch (Exception ex) {
            new ErrorDialog(this.hopGui.getShell(), BaseMessages.getString(PKG, (String)"HopGuiWorkflowGraph.ErrorDialog.WorkflowDrawing.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGuiWorkflowGraph.ErrorDialog.WorkflowDrawing.Message", (String[])new String[0]), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawWorkflowImage(GC swtGc, int width, int height, float magnificationFactor) throws HopException {
        SwtGc gc = new SwtGc(swtGc, width, height, this.iconSize);
        try {
            PropsUi propsUi = PropsUi.getInstance();
            int gridSize = propsUi.isShowCanvasGridEnabled() ? propsUi.getCanvasGridSize() : 1;
            ScrollBar horizontalScrollBar = this.wsCanvas.getHorizontalBar();
            ScrollBar verticalScrollBar = this.wsCanvas.getVerticalBar();
            WorkflowPainter workflowPainter = new WorkflowPainter((IGc)gc, this.variables, this.workflowMeta, new Point(width, height), (IScrollBar)(horizontalScrollBar == null ? null : new SwtScrollBar(horizontalScrollBar)), (IScrollBar)(verticalScrollBar == null ? null : new SwtScrollBar(verticalScrollBar)), this.hopCandidate, this.selectionRegion, this.areaOwners, propsUi.getIconSize(), propsUi.getLineWidth(), gridSize, propsUi.getNoteFont().getName(), propsUi.getNoteFont().getHeight(), propsUi.getZoomFactor(), !propsUi.useDoubleClick());
            float correctedMagnification = (float)((double)magnificationFactor * propsUi.getZoomFactor());
            workflowPainter.setMagnification(correctedMagnification);
            workflowPainter.setStartHopAction(this.startHopAction);
            workflowPainter.setEndHopLocation(this.endHopLocation);
            workflowPainter.setEndHopAction(this.endHopAction);
            workflowPainter.setNoInputAction(this.noInputAction);
            if (this.workflow != null) {
                workflowPainter.setActionResults(this.workflow.getActionResults());
            } else {
                workflowPainter.setActionResults(new ArrayList());
            }
            ArrayList activeActions = new ArrayList();
            if (this.workflow != null) {
                activeActions.addAll(this.workflow.getActiveActions());
            }
            workflowPainter.setActiveActions(activeActions);
            try {
                workflowPainter.drawWorkflow();
                if (this.workflowMeta.isEmpty() || this.workflowMeta.nrNotes() == 0 && this.workflowMeta.nrActions() == 1 && this.workflowMeta.getAction(0).isStart()) {
                    SvgFile svgFile = new SvgFile(BasePropertyHandler.getProperty((String)"WorkflowCanvas_image"), this.getClass().getClassLoader());
                    gc.drawImage(svgFile, 200, 200, 32, 40, gc.getMagnification(), 0.0);
                    gc.setBackground(IGc.EColor.BACKGROUND);
                    gc.drawText(BaseMessages.getString(PKG, (String)"HopGuiWorkflowGraph.NewWorkflowBackgroundMessage", (String[])new String[0]), 260, 220);
                }
            }
            catch (HopException e) {
                throw new HopException("Error drawing workflow", (Throwable)e);
            }
        }
        finally {
            gc.dispose();
        }
        CanvasFacade.setData(this.canvas, this.magnification, (AbstractMeta)this.workflowMeta, HopGuiWorkflowGraph.class);
    }

    @Override
    protected Point getOffset() {
        Point area = this.getArea();
        Point max = this.workflowMeta.getMaximum();
        Point thumb = this.getThumb(area, max);
        return this.getOffset(thumb, area);
    }

    @Override
    public boolean hasChanged() {
        return this.workflowMeta.hasChanged();
    }

    protected void newHop() {
        List selection = this.workflowMeta.getSelectedActions();
        if (selection == null || selection.size() < 2) {
            return;
        }
        ActionMeta fr = (ActionMeta)selection.get(0);
        ActionMeta to = (ActionMeta)selection.get(1);
        this.workflowHopDelegate.newHop(this.workflowMeta, fr, to);
    }

    @GuiContextAction(id="workflow-graph-action-10000-edit", parentId="HopGuiWorkflowActionContext", type=GuiActionType.Modify, name="i18n::HopGuiWorkflowGraph.ContextualAction.EditAction.Text", tooltip="i18n::HopGuiWorkflowGraph.ContextualAction.EditAction.Tooltip", image="ui/images/edit.svg", category="i18n::HopGuiWorkflowGraph.ContextualAction.Category.Basic.Text", categoryOrder="1")
    public void editAction(HopGuiWorkflowActionContext context) {
        this.workflowActionDelegate.editAction(this.workflowMeta, context.getActionMeta());
    }

    public void editAction(ActionMeta je) {
        this.workflowActionDelegate.editAction(this.workflowMeta, je);
    }

    protected void editNote(NotePadMeta notePadMeta) {
        NotePadMeta before = notePadMeta.clone();
        String title = BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.EditNote.Title", (String[])new String[0]);
        NotePadDialog dd = new NotePadDialog(this.variables, this.hopShell(), title, notePadMeta);
        NotePadMeta n = dd.open();
        if (n != null) {
            notePadMeta.setChanged();
            notePadMeta.setNote(n.getNote());
            notePadMeta.setFontName(n.getFontName());
            notePadMeta.setFontSize(n.getFontSize());
            notePadMeta.setFontBold(n.isFontBold());
            notePadMeta.setFontItalic(n.isFontItalic());
            notePadMeta.setFontColorRed(n.getFontColorRed());
            notePadMeta.setFontColorGreen(n.getFontColorGreen());
            notePadMeta.setFontColorBlue(n.getFontColorBlue());
            notePadMeta.setBackGroundColorRed(n.getBackGroundColorRed());
            notePadMeta.setBackGroundColorGreen(n.getBackGroundColorGreen());
            notePadMeta.setBackGroundColorBlue(n.getBackGroundColorBlue());
            notePadMeta.setBorderColorRed(n.getBorderColorRed());
            notePadMeta.setBorderColorGreen(n.getBorderColorGreen());
            notePadMeta.setBorderColorBlue(n.getBorderColorBlue());
            this.hopGui.undoDelegate.addUndoChange((IUndo)this.workflowMeta, new NotePadMeta[]{before}, new NotePadMeta[]{notePadMeta}, new int[]{this.workflowMeta.indexOfNote(notePadMeta)});
            notePadMeta.width = 20;
            notePadMeta.height = 20;
            this.updateGui();
        }
    }

    protected void drawArrow(GC gc, int[] line) {
        int x1 = line[0] + this.offset.x;
        int y1 = line[1] + this.offset.y;
        int x2 = line[2] + this.offset.x;
        int y2 = line[3] + this.offset.y;
        gc.drawLine(x1, y1, x2, y2);
        int a = Math.abs(x2 - x1);
        int b = Math.abs(y2 - y1);
        int dist = (int)Math.sqrt(a * a + b * b);
        double factor = dist >= 2 * this.iconSize ? 1.5 : 1.2;
        int mx = (int)((double)x1 + factor * (double)(x2 - x1) / 2.0);
        int my = (int)((double)y1 + factor * (double)(y2 - y1) / 2.0);
        double angle = Math.atan2(y2 - y1, x2 - x1) + Math.PI;
        int x3 = (int)((double)mx + Math.cos(angle - theta) * 30.0);
        int y3 = (int)((double)my + Math.sin(angle - theta) * 30.0);
        int x4 = (int)((double)mx + Math.cos(angle + theta) * 30.0);
        int y4 = (int)((double)my + Math.sin(angle + theta) * 30.0);
        Color fore = gc.getForeground();
        Color back = gc.getBackground();
        gc.setBackground(fore);
        gc.fillPolygon(new int[]{mx, my, x3, y3, x4, y4});
        gc.setBackground(back);
    }

    protected boolean pointOnLine(int x, int y, int[] line) {
        int pm = 4;
        boolean retval = false;
        for (int dx = -pm; dx <= pm && !retval; ++dx) {
            for (int dy = -pm; dy <= pm && !retval; ++dy) {
                retval = this.pointOnThinLine(x + dx, y + dy, line);
            }
        }
        return retval;
    }

    protected boolean pointOnThinLine(int x, int y, int[] line) {
        int x1 = line[0];
        int y1 = line[1];
        int x2 = line[2];
        int y2 = line[3];
        if (!((x >= x1 && x <= x2 || x >= x2 && x <= x1) && (y >= y1 && y <= y2 || y >= y2 && y <= y1))) {
            return false;
        }
        double angleLine = Math.atan2(y2 - y1, x2 - x1) + Math.PI;
        double anglePoint = Math.atan2(y - y1, x - x1) + Math.PI;
        return anglePoint >= angleLine - 0.01 && anglePoint <= angleLine + 0.01;
    }

    protected SnapAllignDistribute createSnapAllignDistribute() {
        List elements = this.workflowMeta.getSelectedActions();
        int[] indices = this.workflowMeta.getActionIndexes(elements);
        return new SnapAllignDistribute((IUndo)this.workflowMeta, elements, indices, (IAddUndoPosition)this.hopGui.undoDelegate, (IRedrawable)this);
    }

    @GuiToolbarElement(root="HopGuiWorkflowGraph-Toolbar", id="HopGuiWorkflowGraph-ToolBar-10190-Snap-To-Grid", toolTip="i18n::WorkflowGraph.Toolbar.SnapToGrid.Tooltip", image="ui/images/snap-to-grid.svg", disabledImage="ui/images/snap-to-grid-disabled.svg")
    public void snapToGrid() {
        this.snapToGrid(16);
    }

    protected void snapToGrid(int size) {
        this.createSnapAllignDistribute().snapToGrid(size);
    }

    @GuiToolbarElement(root="HopGuiWorkflowGraph-Toolbar", id="HopGuiWorkflowGraph-ToolBar-10200-Align-Left", toolTip="i18n::WorkflowGraph.Toolbar.AlignLeft.Tooltip", image="ui/images/align-left.svg", disabledImage="ui/images/align-left-disabled.svg")
    @GuiKeyboardShortcut(control=true, key=0x1000003)
    @GuiOsxKeyboardShortcut(command=true, key=0x1000003)
    public void alignLeft() {
        this.createSnapAllignDistribute().allignleft();
    }

    @GuiToolbarElement(root="HopGuiWorkflowGraph-Toolbar", id="HopGuiWorkflowGraph-ToolBar-10210-Align-Right", toolTip="i18n::WorkflowGraph.Toolbar.AlignRight.Tooltip", image="ui/images/align-right.svg", disabledImage="ui/images/align-right-disabled.svg")
    @GuiKeyboardShortcut(control=true, key=0x1000004)
    @GuiOsxKeyboardShortcut(command=true, key=0x1000004)
    public void alignRight() {
        this.createSnapAllignDistribute().allignright();
    }

    @GuiToolbarElement(root="HopGuiWorkflowGraph-Toolbar", id="HopGuiWorkflowGraph-ToolBar-10250-Align-Ttop", toolTip="i18n::WorkflowGraph.Toolbar.AlignTop.Tooltip", image="ui/images/align-top.svg", disabledImage="ui/images/align-top-disabled.svg")
    @GuiKeyboardShortcut(control=true, key=0x1000001)
    @GuiOsxKeyboardShortcut(command=true, key=0x1000001)
    public void alignTop() {
        this.createSnapAllignDistribute().alligntop();
    }

    @GuiToolbarElement(root="HopGuiWorkflowGraph-Toolbar", id="HopGuiWorkflowGraph-ToolBar-10260-Align-Bottom", toolTip="i18n::WorkflowGraph.Toolbar.AlignBottom.Tooltip", image="ui/images/align-bottom.svg", disabledImage="ui/images/align-bottom-disabled.svg")
    @GuiKeyboardShortcut(control=true, key=0x1000002)
    @GuiOsxKeyboardShortcut(command=true, key=0x1000002)
    public void alignBottom() {
        this.createSnapAllignDistribute().allignbottom();
    }

    @GuiToolbarElement(root="HopGuiWorkflowGraph-Toolbar", id="HopGuiWorkflowGraph-ToolBar-10300-Distribute-Horizontally", toolTip="i18n::WorkflowGraph.Toolbar.DistributeHorizontal.Tooltip", image="ui/images/distribute-horizontally.svg", disabledImage="ui/images/distribute-horizontally-disabled.svg")
    @GuiKeyboardShortcut(alt=true, key=0x1000004)
    @GuiOsxKeyboardShortcut(alt=true, key=0x1000004)
    public void distributeHorizontal() {
        this.createSnapAllignDistribute().distributehorizontal();
    }

    @GuiToolbarElement(root="HopGuiWorkflowGraph-Toolbar", id="HopGuiWorkflowGraph-ToolBar-10310-Distribute-Vertically", toolTip="i18n::WorkflowGraph.Toolbar.DistributeVertical.Tooltip", image="ui/images/distribute-vertically.svg", disabledImage="ui/images/distribute-vertically-disabled.svg")
    @GuiKeyboardShortcut(alt=true, key=0x1000001)
    @GuiOsxKeyboardShortcut(alt=true, key=0x1000001)
    public void distributeVertical() {
        this.createSnapAllignDistribute().distributevertical();
    }

    @GuiContextAction(id="workflow-graph-action-10100-action-detach", parentId="HopGuiWorkflowActionContext", type=GuiActionType.Modify, name="i18n::HopGuiWorkflowGraph.ContextualAction.DetachAction.Text", tooltip="i18n::HopGuiWorkflowGraph.ContextualAction.DetachAction.Tooltip", image="ui/images/HOP_delete.svg", category="i18n::HopGuiWorkflowGraph.ContextualAction.Category.Basic.Text", categoryOrder="1")
    public void detachAction(HopGuiWorkflowActionContext context) {
        ActionMeta actionMeta = context.getActionMeta();
        WorkflowHopMeta fromHop = this.workflowMeta.findWorkflowHopTo(actionMeta);
        WorkflowHopMeta toHop = this.workflowMeta.findWorkflowHopFrom(actionMeta);
        for (int i = this.workflowMeta.nrWorkflowHops() - 1; i >= 0; --i) {
            WorkflowHopMeta hop = this.workflowMeta.getWorkflowHop(i);
            if (!actionMeta.equals((Object)hop.getFromAction()) && !actionMeta.equals((Object)hop.getToAction())) continue;
            this.hopGui.undoDelegate.addUndoNew((IUndo)this.workflowMeta, new WorkflowHopMeta[]{hop}, new int[]{i});
            this.workflowMeta.removeWorkflowHop(i);
        }
        if (fromHop != null && toHop != null) {
            this.workflowHopDelegate.newHop(this.workflowMeta, new WorkflowHopMeta(fromHop.getFromAction(), toHop.getToAction()));
        }
        this.updateGui();
    }

    @GuiContextAction(id="pipeline-graph-transform-10010-copy-transform-to-clipboard", parentId="HopGuiWorkflowActionContext", type=GuiActionType.Custom, name="i18n::HopGuiWorkflowGraph.ContextualAction.CopyAction.Text", tooltip="i18n::HopGuiWorkflowGraph.ContextualAction.CopyAction.Tooltip", image="ui/images/copy.svg", category="i18n::HopGuiWorkflowGraph.ContextualAction.Category.Basic.Text", categoryOrder="1")
    public void copyActionToClipboard(HopGuiWorkflowActionContext context) {
        this.workflowClipboardDelegate.copySelected(this.workflowMeta, Arrays.asList(context.getActionMeta()), this.workflowMeta.getSelectedNotes());
    }

    public void newProps() {
        this.iconSize = this.hopGui.getProps().getIconSize();
        this.lineWidth = this.hopGui.getProps().getLineWidth();
    }

    public String toString() {
        if (this.workflowMeta == null) {
            return "Hop";
        }
        return this.workflowMeta.getName();
    }

    public IEngineMeta getMeta() {
        return this.workflowMeta;
    }

    public void setWorkflowMeta(WorkflowMeta workflowMeta) {
        this.workflowMeta = workflowMeta;
        if (workflowMeta != null) {
            workflowMeta.setInternalHopVariables(this.variables);
        }
    }

    @Override
    @GuiToolbarElement(root="HopGuiWorkflowGraph-Toolbar", id="HopGuiWorkflowGraph-ToolBar-10100-Undo", toolTip="i18n:org.apache.hop.ui.hopgui:HopGui.Toolbar.Undo.Tooltip", image="ui/images/undo.svg", disabledImage="ui/images/undo-disabled.svg", separator=true)
    @GuiKeyboardShortcut(control=true, key=122)
    public void undo() {
        this.workflowUndoDelegate.undoWorkflowAction(this, this.workflowMeta);
        this.forceFocus();
    }

    @Override
    @GuiToolbarElement(root="HopGuiWorkflowGraph-Toolbar", id="HopGuiWorkflowGraph-ToolBar-10110-Redo", toolTip="i18n:org.apache.hop.ui.hopgui:HopGui.Toolbar.Redo.Tooltip", image="ui/images/redo.svg", disabledImage="ui/images/redo-disabled.svg")
    @GuiKeyboardShortcut(control=true, shift=true, key=122)
    public void redo() {
        this.workflowUndoDelegate.redoWorkflowAction(this, this.workflowMeta);
        this.forceFocus();
    }

    public boolean isRunning() {
        if (this.workflow == null) {
            return false;
        }
        if (this.workflow.isFinished()) {
            return false;
        }
        if (this.workflow.isStopped()) {
            return false;
        }
        if (this.workflow.isActive()) {
            return true;
        }
        return this.workflow.isInitialized();
    }

    @Override
    public void updateGui() {
        if (this.hopGui == null || this.toolBarWidgets == null || this.toolBar == null || this.toolBar.isDisposed()) {
            return;
        }
        this.hopDisplay().asyncExec(() -> {
            this.setZoomLabel();
            this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_UNDO_ID, this.workflowMeta.viewThisUndo() != null);
            this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_REDO_ID, this.workflowMeta.viewNextUndo() != null);
            boolean selectedAction = !this.workflowMeta.getSelectedActions().isEmpty();
            this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_SNAP_TO_GRID, selectedAction);
            boolean selectedActions = this.workflowMeta.getSelectedActions().size() > 1;
            this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_ALIGN_LEFT, selectedActions);
            this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_ALIGN_RIGHT, selectedActions);
            this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_ALIGN_TOP, selectedActions);
            this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_ALIGN_BOTTOM, selectedActions);
            this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_DISTRIBUTE_HORIZONTALLY, selectedActions);
            this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_DISTRIBUTE_VERTICALLY, selectedActions);
            boolean running = this.isRunning() && !this.workflow.isStopped();
            this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_START, !running);
            this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_STOP, running);
            this.hopGui.setUndoMenu((IUndo)this.workflowMeta);
            this.hopGui.handleFileCapabilities(this.fileType, this.workflowMeta.hasChanged(), running, false);
            if (!this.avoidScrollAdjusting) {
                this.avoidScrollAdjusting = false;
                this.adjustScrolling();
            }
            HopGuiWorkflowGraph.super.redraw();
        });
    }

    public boolean canBeClosed() {
        return !this.workflowMeta.hasChanged();
    }

    public WorkflowMeta getManagedObject() {
        return this.workflowMeta;
    }

    public boolean hasContentChanged() {
        return this.workflowMeta.hasChanged();
    }

    public static int showChangedWarning(Shell shell, String name) {
        MessageBox mb = new MessageBox(shell, 456);
        mb.setMessage(BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.PromptSave.Message", (String[])new String[]{name}));
        mb.setText(BaseMessages.getString(PKG, (String)"WorkflowGraph.Dialog.PromptSave.Title", (String[])new String[0]));
        return mb.open();
    }

    public boolean editProperties(WorkflowMeta workflowMeta, HopGui hopGui, boolean allowDirectoryChange) {
        if (workflowMeta == null) {
            return false;
        }
        WorkflowDialog jd = new WorkflowDialog(hopGui.getShell(), 0, this.variables, workflowMeta);
        if (jd.open() != null) {
            hopGui.setParametersAsVariablesInUI((INamedParameterDefinitions)workflowMeta, this.variables);
            this.updateGui();
            this.perspective.updateTabs();
            return true;
        }
        return false;
    }

    @Override
    public synchronized void save() throws HopException {
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this.variables, (String)HopExtensionPoint.WorkflowBeforeSave.id, (Object)this.workflowMeta);
            if (StringUtils.isEmpty((String)this.workflowMeta.getFilename())) {
                throw new HopException("No filename: please specify a filename for this workflow");
            }
            AuditManager.registerEvent((String)HopNamespace.getNamespace(), (String)"file", (String)this.workflowMeta.getFilename(), (String)"save");
            String xml = this.workflowMeta.getXml(this.variables);
            OutputStream out = HopVfs.getOutputStream((String)this.workflowMeta.getFilename(), (boolean)false);
            try {
                out.write(XmlHandler.getXmlHeader((String)"UTF-8").getBytes("UTF-8"));
                out.write(xml.getBytes("UTF-8"));
                this.workflowMeta.clearChanged();
                this.updateGui();
                HopGui.getDataOrchestrationPerspective().updateTabs();
            }
            finally {
                out.flush();
                out.close();
                ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this.variables, (String)HopExtensionPoint.WorkflowAfterSave.id, (Object)this.workflowMeta);
            }
        }
        catch (Exception e) {
            throw new HopException("Error saving workflow to file '" + this.workflowMeta.getFilename() + "'", (Throwable)e);
        }
    }

    @Override
    public void saveAs(String filename) throws HopException {
        try {
            FileObject fileObject;
            if (!((String)filename).toLowerCase().endsWith(((HopWorkflowFileType)this.getFileType()).getDefaultFileExtension())) {
                filename = (String)filename + ((HopWorkflowFileType)this.getFileType()).getDefaultFileExtension();
            }
            if ((fileObject = HopVfs.getFileObject((String)filename)).exists()) {
                MessageBox box = new MessageBox(this.hopGui.getShell(), 196);
                box.setText("Overwrite?");
                box.setMessage("Are you sure you want to overwrite file '" + (String)filename + "'?");
                int answer = box.open();
                if ((answer & 0x40) == 0) {
                    return;
                }
            }
            this.workflowMeta.setFilename((String)filename);
            this.save();
        }
        catch (Exception e) {
            new HopException("Error validating file existence for '" + (String)filename + "'", (Throwable)e);
        }
    }

    public Point getLastMove() {
        return this.lastMove;
    }

    public void setLastMove(Point lastMove) {
        this.lastMove = lastMove;
    }

    public void addExtraView() {
        this.extraViewTabFolder = new CTabFolder((Composite)this.sashForm, 2);
        this.hopGui.getProps().setLook((Control)this.extraViewTabFolder, 5);
        this.extraViewTabFolder.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                if (HopGuiWorkflowGraph.this.sashForm.getMaximizedControl() == null) {
                    HopGuiWorkflowGraph.this.sashForm.setMaximizedControl((Control)HopGuiWorkflowGraph.this.extraViewTabFolder);
                } else {
                    HopGuiWorkflowGraph.this.sashForm.setMaximizedControl(null);
                }
            }
        });
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.top = new FormAttachment(0, 0);
        fdTabFolder.bottom = new FormAttachment(100, 0);
        this.extraViewTabFolder.setLayoutData((Object)fdTabFolder);
        ToolBar extraViewToolBar = new ToolBar((Composite)this.extraViewTabFolder, 0x800000);
        this.extraViewTabFolder.setTopRight((Control)extraViewToolBar, 131072);
        this.props.setLook((Control)extraViewToolBar);
        this.minMaxItem = new ToolItem(extraViewToolBar, 8);
        this.minMaxItem.setImage(GuiResource.getInstance().getImageMaximizePanel());
        this.minMaxItem.setToolTipText(BaseMessages.getString(PKG, (String)"WorkflowGraph.ExecutionResultsPanel.MaxButton.Tooltip", (String[])new String[0]));
        this.minMaxItem.addListener(13, e -> this.minMaxExtraView());
        this.closeItem = new ToolItem(extraViewToolBar, 8);
        this.closeItem.setImage(GuiResource.getInstance().getImageClosePanel());
        this.closeItem.setToolTipText(BaseMessages.getString(PKG, (String)"WorkflowGraph.ExecutionResultsPanel.CloseButton.Tooltip", (String[])new String[0]));
        this.closeItem.addListener(13, e -> this.disposeExtraView());
        int height = extraViewToolBar.computeSize((int)-1, (int)-1).y;
        this.extraViewTabFolder.setTabHeight(Math.max(height, this.extraViewTabFolder.getTabHeight()));
        this.sashForm.setWeights(new int[]{60, 40});
    }

    public void checkEmptyExtraView() {
        if (this.extraViewTabFolder.getItemCount() == 0) {
            this.disposeExtraView();
        }
    }

    private void disposeExtraView() {
        this.extraViewTabFolder.dispose();
        this.sashForm.layout();
        this.sashForm.setWeights(new int[]{100});
        ToolItem item = this.toolBarWidgets.findToolItem(TOOLBAR_ITEM_SHOW_EXECUTION_RESULTS);
        item.setToolTipText(BaseMessages.getString(PKG, (String)"HopGui.Tooltip.ShowExecutionResults", (String[])new String[0]));
        item.setImage(GuiResource.getInstance().getImageShowResults());
    }

    private void minMaxExtraView() {
        boolean maximized;
        boolean bl = maximized = this.sashForm.getMaximizedControl() != null;
        if (maximized) {
            this.sashForm.setMaximizedControl(null);
            this.minMaxItem.setImage(GuiResource.getInstance().getImageMaximizePanel());
            this.minMaxItem.setToolTipText(BaseMessages.getString(PKG, (String)"WorkflowGraph.ExecutionResultsPanel.MaxButton.Tooltip", (String[])new String[0]));
        } else {
            this.sashForm.setMaximizedControl((Control)this.extraViewTabFolder);
            this.minMaxItem.setImage(GuiResource.getInstance().getImageMinimizePanel());
            this.minMaxItem.setToolTipText(BaseMessages.getString(PKG, (String)"WorkflowGraph.ExecutionResultsPanel.MinButton.Tooltip", (String[])new String[0]));
        }
    }

    public boolean isExecutionResultsPaneVisible() {
        return this.extraViewTabFolder != null && !this.extraViewTabFolder.isDisposed();
    }

    @GuiToolbarElement(root="HopGuiWorkflowGraph-Toolbar", id="HopGuiWorkflowGraph-ToolBar-10400-Execution-Results", toolTip="i18n:org.apache.hop.ui.hopgui:HopGui.Tooltip.ShowExecutionResults", image="ui/images/show-results.svg", separator=true)
    public void showExecutionResults() {
        if (this.isExecutionResultsPaneVisible()) {
            this.disposeExtraView();
        } else {
            this.addAllTabs();
        }
    }

    public void addAllTabs() {
        CTabItem tabItemSelection = null;
        if (this.extraViewTabFolder != null && !this.extraViewTabFolder.isDisposed()) {
            tabItemSelection = this.extraViewTabFolder.getSelection();
        }
        this.workflowLogDelegate.addWorkflowLog();
        this.workflowGridDelegate.addWorkflowGrid();
        if (tabItemSelection != null) {
            this.extraViewTabFolder.setSelection(tabItemSelection);
        } else {
            this.extraViewTabFolder.setSelection(this.workflowGridDelegate.getWorkflowGridTab());
        }
        ToolItem toolItem = this.toolBarWidgets.findToolItem(TOOLBAR_ITEM_SHOW_EXECUTION_RESULTS);
        toolItem.setToolTipText(BaseMessages.getString(PKG, (String)"HopGui.Tooltip.HideExecutionResults", (String[])new String[0]));
        toolItem.setImage(GuiResource.getInstance().getImageHideResults());
    }

    @Override
    public void close() {
        this.perspective.remove(this);
    }

    @Override
    public boolean isCloseable() {
        try {
            if (this.workflowMeta.hasChanged()) {
                MessageBox messageDialog = new MessageBox(this.hopShell(), 452);
                messageDialog.setText(BaseMessages.getString(PKG, (String)"HopGuiWorkflowGraph.SaveFile.Dialog.Header", (String[])new String[0]));
                messageDialog.setMessage(BaseMessages.getString(PKG, (String)"HopGuiWorkflowGraph.SaveFile.Dialog.Message", (String[])new String[]{this.buildTabName()}));
                int answer = messageDialog.open();
                if ((answer & 0x40) != 0) {
                    if (StringUtils.isEmpty((String)this.getFilename())) {
                        String filename = BaseDialog.presentFileDialog(true, this.hopGui.getShell(), this.fileType.getFilterExtensions(), this.fileType.getFilterNames(), true);
                        if (filename == null) {
                            return false;
                        }
                        filename = this.hopGui.getVariables().resolve(filename);
                        this.saveAs(filename);
                    } else {
                        this.save();
                    }
                    return true;
                }
                return (answer & 0x80) != 0;
            }
            return true;
        }
        catch (Exception e) {
            new ErrorDialog(this.hopShell(), "Error", "Error preparing file close", e);
            return false;
        }
    }

    public String buildTabName() throws HopException {
        String tabName = null;
        String realFilename = this.variables.resolve(this.workflowMeta.getFilename());
        if (StringUtils.isEmpty((String)realFilename)) {
            tabName = this.workflowMeta.getName();
        } else {
            try {
                FileObject fileObject = HopVfs.getFileObject((String)this.workflowMeta.getFilename());
                FileName fileName = fileObject.getName();
                tabName = fileName.getBaseName();
            }
            catch (Exception e) {
                throw new HopException("Unable to get information from file name '" + this.workflowMeta.getFilename() + "'", (Throwable)e);
            }
        }
        return tabName;
    }

    public synchronized void start(WorkflowExecutionConfiguration executionConfiguration) throws HopException {
        if (this.handleWorkflowMetaChanges(this.workflowMeta)) {
            if (!this.isRunning()) {
                try {
                    if (executionConfiguration.isClearingLog()) {
                        this.workflowLogDelegate.clearLog();
                    }
                    if (this.workflow != null) {
                        HopLogStore.discardLines((String)this.workflow.getLogChannelId(), (boolean)true);
                    }
                    WorkflowMeta runWorkflowMeta = new WorkflowMeta(this.hopGui.getVariables(), this.workflowMeta.getFilename(), this.workflowMeta.getMetadataProvider());
                    String hopGuiObjectId = UUID.randomUUID().toString();
                    SimpleLoggingObject hopGuiLoggingObject = new SimpleLoggingObject("HOPGUI", LoggingObjectType.HOP_GUI, null);
                    hopGuiLoggingObject.setContainerObjectId(hopGuiObjectId);
                    hopGuiLoggingObject.setLogLevel(executionConfiguration.getLogLevel());
                    if (executionConfiguration.getStartActionName() != null) {
                        this.workflowMeta.setStartActionName(executionConfiguration.getStartActionName());
                    }
                    this.workflowMeta.setClearingLog(executionConfiguration.isClearingLog());
                    ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this.variables, (String)HopExtensionPoint.HopGuiWorkflowMetaExecutionStart.id, (Object)this.workflowMeta);
                    this.workflow = WorkflowEngineFactory.createWorkflowEngine((IVariables)this.variables, (String)executionConfiguration.getRunConfiguration(), (IHopMetadataProvider)this.hopGui.getMetadataProvider(), (WorkflowMeta)runWorkflowMeta, (ILoggingObject)hopGuiLoggingObject);
                    this.workflow.setLogLevel(executionConfiguration.getLogLevel());
                    this.workflow.setInteractive(true);
                    this.workflow.setGatheringMetrics(executionConfiguration.isGatheringMetrics());
                    for (String varName : executionConfiguration.getVariablesMap().keySet()) {
                        String varValue = (String)executionConfiguration.getVariablesMap().get(varName);
                        if (!StringUtils.isNotEmpty((String)varValue)) continue;
                        this.workflow.setVariable(varName, varValue);
                    }
                    for (String paramName : executionConfiguration.getParametersMap().keySet()) {
                        String paramValue = (String)executionConfiguration.getParametersMap().get(paramName);
                        this.workflow.setParameterValue(paramName, paramValue);
                    }
                    this.workflow.activateParameters(this.workflow);
                    this.workflow.getExtensionDataMap().putAll(executionConfiguration.getExtensionOptions());
                    this.workflow.addActionListener(this.createRefreshActionListener());
                    if (!Utils.isEmpty((CharSequence)executionConfiguration.getStartActionName())) {
                        ActionMeta startActionMeta = runWorkflowMeta.findAction(executionConfiguration.getStartActionName());
                        this.workflow.setStartActionMeta(startActionMeta);
                    }
                    Map paramMap = executionConfiguration.getParametersMap();
                    Set keys = paramMap.keySet();
                    for (String key : keys) {
                        this.workflow.setParameterValue(key, Const.NVL((String)((String)paramMap.get(key)), (String)""));
                    }
                    this.workflow.activateParameters(this.workflow);
                    try {
                        ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.UI, (IVariables)this.variables, (String)HopExtensionPoint.HopGuiWorkflowBeforeStart.id, this.workflow);
                    }
                    catch (HopException e) {
                        LogChannel.UI.logError(e.getMessage(), new Object[]{this.workflowMeta.getFilename()});
                        return;
                    }
                    this.log.logBasic(BaseMessages.getString(PKG, (String)"WorkflowLog.Log.StartingWorkflow", (String[])new String[0]));
                    this.workflowThread = new Thread(() -> this.workflow.startExecution());
                    this.workflowThread.start();
                    this.workflowGridDelegate.previousNrItems = -1;
                    this.workflowGridDelegate.workflowTracker = this.workflow.getWorkflowTracker();
                    this.updateGui();
                    this.workflow.addWorkflowFinishedListener(workflow -> this.jobFinished());
                    this.addAllTabs();
                }
                catch (HopException e) {
                    new ErrorDialog(this.hopShell(), BaseMessages.getString(PKG, (String)"WorkflowLog.Dialog.CanNotOpenWorkflow.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"WorkflowLog.Dialog.CanNotOpenWorkflow.Message", (String[])new String[0]), (Exception)((Object)e));
                    this.workflow = null;
                }
            } else {
                MessageBox m = new MessageBox(this.hopShell(), 40);
                m.setText(BaseMessages.getString(PKG, (String)"WorkflowLog.Dialog.WorkflowIsAlreadyRunning.Title", (String[])new String[0]));
                m.setMessage(BaseMessages.getString(PKG, (String)"WorkflowLog.Dialog.WorkflowIsAlreadyRunning.Message", (String[])new String[0]));
                m.open();
            }
        } else {
            this.showSaveFileMessage();
        }
    }

    public void showSaveFileMessage() {
        MessageBox m = new MessageBox(this.hopShell(), 40);
        m.setText(BaseMessages.getString(PKG, (String)"WorkflowLog.Dialog.WorkflowHasChangedSave.Title", (String[])new String[0]));
        m.setMessage(BaseMessages.getString(PKG, (String)"WorkflowLog.Dialog.WorkflowHasChangedSave.Message", (String[])new String[0]));
        m.open();
    }

    private IActionListener createRefreshActionListener() {
        return new IActionListener<WorkflowMeta>(){

            public void beforeExecution(IWorkflowEngine<WorkflowMeta> workflow, ActionMeta actionCopy, IAction action) {
                HopGuiWorkflowGraph.this.asyncRedraw();
            }

            public void afterExecution(IWorkflowEngine<WorkflowMeta> workflow, ActionMeta actionCopy, IAction action, Result result) {
                HopGuiWorkflowGraph.this.asyncRedraw();
            }
        };
    }

    protected void jobFinished() {
        if (this.workflow != null && this.workflow.isInitialized() && this.workflow.isFinished()) {
            this.log.logBasic(BaseMessages.getString(PKG, (String)"WorkflowLog.Log.WorkflowHasEnded", (String[])new String[0]));
        }
        this.updateGui();
    }

    public IHasLogChannel getLogChannelProvider() {
        return () -> this.getWorkflow() != null ? this.getWorkflow().getLogChannel() : LogChannel.GENERAL;
    }

    public void addUndoPosition(Object[] obj, int[] pos, Point[] prev, Point[] curr) {
        this.addUndoPosition(obj, pos, prev, curr, false);
    }

    public void addUndoPosition(Object[] obj, int[] pos, Point[] prev, Point[] curr, boolean nextAlso) {
        this.workflowMeta.addUndo(obj, null, pos, prev, curr, 4, nextAlso);
        this.hopGui.setUndoMenu((IUndo)this.workflowMeta);
    }

    public boolean handleWorkflowMetaChanges(WorkflowMeta workflowMeta) throws HopException {
        if (workflowMeta.hasChanged()) {
            if (StringUtils.isNotEmpty((String)workflowMeta.getFilename()) && this.hopGui.getProps().getAutoSave()) {
                if (this.log.isDetailed()) {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"WorkflowLog.Log.AutoSaveFileBeforeRunning", (String[])new String[0]));
                }
                this.save();
            } else {
                MessageDialogWithToggle md = new MessageDialogWithToggle(this.hopShell(), BaseMessages.getString(PKG, (String)"WorkflowLog.Dialog.SaveChangedFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"WorkflowLog.Dialog.SaveChangedFile.Message", (String[])new String[0]) + Const.CR + BaseMessages.getString(PKG, (String)"WorkflowLog.Dialog.SaveChangedFile.Message2", (String[])new String[0]) + Const.CR, 4, new String[]{BaseMessages.getString(PKG, (String)"System.Button.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Button.No", (String[])new String[0])}, BaseMessages.getString(PKG, (String)"WorkflowLog.Dialog.SaveChangedFile.Toggle", (String[])new String[0]), this.hopGui.getProps().getAutoSave());
                int answer = md.open();
                if (answer == 0) {
                    String filename = workflowMeta.getFilename();
                    if (StringUtils.isEmpty((String)filename)) {
                        filename = BaseDialog.presentFileDialog(true, this.hopGui.getShell(), this.fileType.getFilterExtensions(), this.fileType.getFilterNames(), true);
                        if (filename != null) {
                            filename = this.hopGui.getVariables().resolve(filename);
                            this.saveAs(filename);
                        }
                    } else {
                        this.save();
                    }
                }
                this.hopGui.getProps().setAutoSave(md.getToggleState());
            }
        }
        return StringUtils.isNotEmpty((String)workflowMeta.getFilename()) && !workflowMeta.hasChanged();
    }

    public void addActionToChain(String typeDesc, boolean shift) {
        List sel;
        if (this.lastChained != null && this.workflowMeta.findAction(this.lastChained.getName()) == null) {
            this.lastChained = null;
        }
        if ((sel = this.workflowMeta.getSelectedActions()).size() == 1) {
            this.lastChained = (ActionMeta)sel.get(0);
        }
        Point p = null;
        if (this.lastChained == null) {
            p = this.workflowMeta.getMaximum();
            p.x -= 100;
        } else {
            p = new Point(this.lastChained.getLocation().x, this.lastChained.getLocation().y);
        }
        p.x += 200;
        ActionMeta newEntry = this.workflowActionDelegate.newAction(this.workflowMeta, null, typeDesc, false, p);
        if (newEntry == null) {
            return;
        }
        newEntry.setLocation(p.x, p.y);
        if (this.lastChained != null) {
            this.workflowHopDelegate.newHop(this.workflowMeta, this.lastChained, newEntry);
        }
        this.lastChained = newEntry;
        this.adjustScrolling();
        this.updateGui();
        if (shift) {
            this.editAction(newEntry);
        }
        this.workflowMeta.unselectAll();
        newEntry.setSelected(true);
        this.updateGui();
    }

    @GuiKeyboardShortcut(key=122)
    @GuiOsxKeyboardShortcut(key=122)
    public void openReferencedObject() {
        if (this.lastMove != null) {
            this.hideToolTips();
            ActionMeta action = this.workflowMeta.getAction(this.lastMove.x, this.lastMove.y, this.iconSize);
            if (action != null) {
                IAction iAction = action.getAction();
                String[] objectDescriptions = iAction.getReferencedObjectDescriptions();
                if (objectDescriptions == null || objectDescriptions.length == 0) {
                    return;
                }
                if (objectDescriptions.length == 1) {
                    HopGuiWorkflowActionContext.openReferencedObject(this.workflowMeta, this.variables, iAction, objectDescriptions[0], 0);
                } else {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.getShell(), objectDescriptions, BaseMessages.getString(PKG, (String)"HopGuiWorkflowGraph.OpenReferencedObject.Selection.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGuiWorkflowGraph.OpenReferencedObject.Selection.Message", (String[])new String[0]));
                    String answer = dialog.open(0);
                    if (answer != null) {
                        int index = dialog.getSelectionNr();
                        HopGuiWorkflowActionContext.openReferencedObject(this.workflowMeta, this.variables, iAction, answer, index);
                    }
                }
            }
        }
    }

    @Override
    public Object getSubject() {
        return this.workflowMeta;
    }

    public WorkflowMeta getWorkflowMeta() {
        return this.workflowMeta;
    }

    public IWorkflowEngine<WorkflowMeta> getWorkflow() {
        return this.workflow;
    }

    public ILogChannel getLogChannel() {
        return this.log;
    }

    public void editAction(WorkflowMeta workflowMeta, ActionMeta actionCopy) {
    }

    @Override
    public String getName() {
        return this.workflowMeta.getName();
    }

    @Override
    public void setName(String name) {
        this.workflowMeta.setName(name);
    }

    @Override
    public String getFilename() {
        return this.workflowMeta.getFilename();
    }

    @Override
    public void setFilename(String filename) {
        this.workflowMeta.setFilename(filename);
    }

    public HopGui getHopGui() {
        return this.hopGui;
    }

    public HopDataOrchestrationPerspective getPerspective() {
        return this.perspective;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public ILogChannel getLog() {
        return this.log;
    }

    public void setLog(ILogChannel log) {
        this.log = log;
    }

    public PropsUi getProps() {
        return this.props;
    }

    public void setProps(PropsUi props) {
        this.props = props;
    }

    public void setHopGui(HopGui hopGui) {
        this.hopGui = hopGui;
    }

    @Override
    public HopWorkflowFileType<WorkflowMeta> getFileType() {
        return this.fileType;
    }

    public void setFileType(HopWorkflowFileType<WorkflowMeta> fileType) {
        this.fileType = fileType;
    }

    @Override
    public List<IGuiContextHandler> getContextHandlers() {
        return null;
    }

    public Thread getWorkflowThread() {
        return this.workflowThread;
    }

    private static enum SingleClickType {
        Workflow,
        Action,
        Note,
        Hop;

    }
}

