/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.key.GuiKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.GuiOsxKeyboardShortcut;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.metadata.util.HopMetadataUtil;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.bus.HopGuiEvents;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataFileType;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.TabFolderReorder;
import org.apache.hop.ui.core.widget.TreeMemory;
import org.apache.hop.ui.core.widget.TreeUtil;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.HopGuiKeyHandler;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.empty.EmptyFileType;
import org.apache.hop.ui.hopgui.file.empty.EmptyHopFileTypeHandler;
import org.apache.hop.ui.hopgui.perspective.HopPerspectivePlugin;
import org.apache.hop.ui.hopgui.perspective.IHopPerspective;
import org.apache.hop.ui.hopgui.perspective.TabItemHandler;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

@HopPerspectivePlugin(id="200-HopMetadataPerspective", name="i18n::MetadataPerspective.Name", description="i18n::MetadataPerspective.Description", image="ui/images/metadata.svg")
@GuiPlugin(description="i18n::MetadataPerspective.GuiPlugin.Description")
public class MetadataPerspective
implements IHopPerspective {
    public static final Class<?> PKG = MetadataPerspective.class;
    private static final String METADATA_PERSPECTIVE_TREE = "Metadata perspective tree";
    public static final String GUI_PLUGIN_TOOLBAR_PARENT_ID = "MetadataPerspective-Toolbar";
    public static final String TOOLBAR_ITEM_EDIT = "MetadataPerspective-Toolbar-10010-Edit";
    public static final String TOOLBAR_ITEM_DUPLICATE = "MetadataPerspective-Toolbar-10030-Duplicate";
    public static final String TOOLBAR_ITEM_DELETE = "MetadataPerspective-Toolbar-10040-Delete";
    public static final String TOOLBAR_ITEM_REFRESH = "MetadataPerspective-Toolbar-10100-Refresh";
    public static final String KEY_HELP = "Help";
    private static MetadataPerspective instance;
    private HopGui hopGui;
    private SashForm sash;
    private Tree tree;
    private TreeEditor treeEditor;
    private CTabFolder tabFolder;
    private ToolBar toolBar;
    private GuiToolbarWidgets toolBarWidgets;
    private List<MetadataEditor<?>> editors = new ArrayList();
    private final EmptyFileType emptyFileType;
    private final MetadataFileType metadataFileType;

    public static MetadataPerspective getInstance() {
        return instance;
    }

    public MetadataPerspective() {
        instance = this;
        this.emptyFileType = new EmptyFileType();
        this.metadataFileType = new MetadataFileType();
    }

    @Override
    public String getId() {
        return "metadata-perspective";
    }

    @Override
    @GuiKeyboardShortcut(control=true, shift=true, key=109)
    @GuiOsxKeyboardShortcut(command=true, shift=true, key=109)
    public void activate() {
        this.hopGui.setActivePerspective(this);
    }

    @Override
    public void perspectiveActivated() {
        this.refresh();
        this.updateSelection();
        if (this.tabFolder.getItemCount() == 0) {
            HopGui.getInstance().handleFileCapabilities(this.emptyFileType, false, false, false);
        } else {
            IHopFileTypeHandler handler = this.getActiveFileTypeHandler();
            boolean changed = handler != null ? handler.hasChanged() : false;
            HopGui.getInstance().handleFileCapabilities(this.metadataFileType, changed, false, false);
        }
    }

    @Override
    public boolean isActive() {
        return this.hopGui.isActivePerspective(this);
    }

    @Override
    public List<IHopFileType> getSupportedHopFileTypes() {
        return Arrays.asList(this.metadataFileType);
    }

    @Override
    public void initialize(HopGui hopGui, Composite parent) {
        this.hopGui = hopGui;
        this.sash = new SashForm(parent, 256);
        FormData fdSash = new FormData();
        fdSash.left = new FormAttachment(0, 0);
        fdSash.top = new FormAttachment(0, 0);
        fdSash.right = new FormAttachment(100, 0);
        fdSash.bottom = new FormAttachment(100, 0);
        this.sash.setLayoutData((Object)fdSash);
        this.createTree((Composite)this.sash);
        this.createTabFolder((Composite)this.sash);
        this.sash.setWeights(new int[]{20, 80});
        this.refresh();
        this.updateSelection();
        for (TreeItem item : this.tree.getItems()) {
            TreeMemory.getInstance().storeExpanded(METADATA_PERSPECTIVE_TREE, item, true);
        }
        hopGui.getEventsHandler().addEventListener(this.getClass().getName(), e -> this.refresh(), HopGuiEvents.MetadataChanged.name());
        HopGuiKeyHandler.getInstance().addParentObjectToHandle(this);
    }

    protected MetadataManager<IHopMetadata> getMetadataManager(String objectKey) throws HopException {
        MultiMetadataProvider metadataProvider = this.hopGui.getMetadataProvider();
        Class metadataClass = metadataProvider.getMetadataClassForKey(objectKey);
        return new MetadataManager<IHopMetadata>(HopGui.getInstance().getVariables(), (IHopMetadataProvider)metadataProvider, metadataClass);
    }

    protected void createTree(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        Composite composite = new Composite(parent, 2048);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.toolBar = new ToolBar(composite, 16704);
        this.toolBarWidgets = new GuiToolbarWidgets();
        this.toolBarWidgets.registerGuiPluginObject(this);
        this.toolBarWidgets.createToolbarWidgets((Composite)this.toolBar, GUI_PLUGIN_TOOLBAR_PARENT_ID);
        FormData layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 0);
        layoutData.top = new FormAttachment(0, 0);
        layoutData.right = new FormAttachment(100, 0);
        this.toolBar.setLayoutData((Object)layoutData);
        this.toolBar.pack();
        props.setLook((Control)this.toolBar, 6);
        this.tree = new Tree(composite, 772);
        this.tree.setHeaderVisible(false);
        this.tree.addListener(13, event -> this.updateSelection());
        this.tree.addListener(2, event -> {
            if (event.keyCode == 127) {
                this.onDeleteMetadata();
            }
        });
        this.tree.addListener(14, event -> {
            TreeItem treeItem = this.tree.getSelection()[0];
            if (treeItem != null) {
                if (treeItem.getParentItem() == null) {
                    this.onNewMetadata();
                } else {
                    this.onEditMetadata();
                }
            }
        });
        this.tree.addMenuDetectListener(event -> {
            if (this.tree.getSelectionCount() < 1) {
                return;
            }
            TreeItem treeItem = this.tree.getSelection()[0];
            if (treeItem != null) {
                Menu menu = new Menu((Control)this.tree);
                MenuItem menuItem = new MenuItem(menu, 8);
                menuItem.setText("New");
                menuItem.addListener(13, e -> this.onNewMetadata());
                if (treeItem.getParentItem() != null) {
                    new MenuItem(menu, 2);
                    menuItem = new MenuItem(menu, 8);
                    menuItem.setText("Edit");
                    menuItem.addListener(13, e -> this.onEditMetadata());
                    menuItem = new MenuItem(menu, 8);
                    menuItem.setText("Rename");
                    menuItem.addListener(13, e -> this.onRenameMetadata());
                    menuItem = new MenuItem(menu, 8);
                    menuItem.setText("Duplicate");
                    menuItem.addListener(13, e -> this.duplicateMetadata());
                    new MenuItem(menu, 2);
                    menuItem = new MenuItem(menu, 8);
                    menuItem.setText("Delete");
                    menuItem.addListener(13, e -> this.onDeleteMetadata());
                }
                this.tree.setMenu(menu);
                menu.setVisible(true);
            }
        });
        PropsUi.getInstance().setLook((Control)this.tree);
        FormData treeFormData = new FormData();
        treeFormData.left = new FormAttachment(0, 0);
        treeFormData.top = new FormAttachment((Control)this.toolBar, 0);
        treeFormData.right = new FormAttachment(100, 0);
        treeFormData.bottom = new FormAttachment(100, 0);
        this.tree.setLayoutData((Object)treeFormData);
        this.treeEditor = new TreeEditor(this.tree);
        this.treeEditor.horizontalAlignment = 16384;
        this.treeEditor.grabHorizontal = true;
        TreeMemory.addTreeListener(this.tree, METADATA_PERSPECTIVE_TREE);
    }

    protected void createTabFolder(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        this.tabFolder = new CTabFolder(parent, 2050);
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                MetadataPerspective.this.onTabClose(event);
            }
        });
        props.setLook((Control)this.tabFolder, 5);
        ToolBar toolBar = new ToolBar((Composite)this.tabFolder, 0x800000);
        ToolItem item = new ToolItem(toolBar, 8);
        item.setImage(GuiResource.getInstance().getImageMinimizePanel());
        item.addListener(13, e -> {
            if (this.sash.getMaximizedControl() == null) {
                this.sash.setMaximizedControl((Control)this.tabFolder);
                item.setImage(GuiResource.getInstance().getImageMaximizePanel());
            } else {
                this.sash.setMaximizedControl(null);
                item.setImage(GuiResource.getInstance().getImageMinimizePanel());
            }
        });
        this.tabFolder.setTopRight((Control)toolBar, 131072);
        new TabFolderReorder(this.tabFolder);
    }

    public void addEditor(MetadataEditor<?> editor) {
        PropsUi props = PropsUi.getInstance();
        CTabItem tabItem = new CTabItem(this.tabFolder, 64);
        tabItem.setText(editor.getTitle());
        tabItem.setImage(editor.getTitleImage());
        tabItem.setToolTipText(editor.getTitleToolTip());
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        FormLayout layoutComposite = new FormLayout();
        layoutComposite.marginWidth = 5;
        layoutComposite.marginHeight = 5;
        composite.setLayout((Layout)layoutComposite);
        props.setLook((Control)composite);
        Button[] buttons = editor.createButtonsForButtonBar(composite);
        if (buttons != null) {
            BaseTransformDialog.positionBottomButtons(composite, buttons, props.getMargin(), null);
        }
        Composite area = new Composite(composite, 0);
        FormLayout layoutArea = new FormLayout();
        layoutArea.marginWidth = 0;
        layoutArea.marginHeight = 0;
        area.setLayout((Layout)layoutArea);
        FormData fdArea = new FormData();
        fdArea.left = new FormAttachment(0, 0);
        fdArea.top = new FormAttachment(0, 0);
        fdArea.right = new FormAttachment(100, 0);
        fdArea.bottom = buttons != null ? new FormAttachment((Control)buttons[0], -props.getMargin()) : new FormAttachment(100, -props.getMargin());
        area.setLayoutData((Object)fdArea);
        props.setLook((Control)area);
        editor.createControl(area);
        tabItem.setControl((Control)composite);
        tabItem.setData(editor);
        this.editors.add(editor);
        this.activate();
        this.tabFolder.setSelection(tabItem);
        editor.setFocus();
    }

    public MetadataEditor<?> findEditor(String objectKey, String name) {
        if (objectKey == null || name == null) {
            return null;
        }
        for (MetadataEditor<?> editor : this.editors) {
            Object metadata = editor.getMetadata();
            HopMetadata annotation = HopMetadataUtil.getHopMetadataAnnotation(metadata.getClass());
            if (annotation == null || !annotation.key().equals(objectKey) || !name.equals(metadata.getName())) continue;
            return editor;
        }
        return null;
    }

    public void setActiveEditor(MetadataEditor<?> editor) {
        for (CTabItem item : this.tabFolder.getItems()) {
            if (!item.getData().equals(editor)) continue;
            this.tabFolder.setSelection(item);
            this.tabFolder.showItem(item);
            editor.setFocus();
            HopGui.getInstance().handleFileCapabilities(this.metadataFileType, editor.hasChanged(), false, false);
        }
    }

    public MetadataEditor<?> getActiveEditor() {
        if (this.tabFolder.getSelectionIndex() < 0) {
            return null;
        }
        return (MetadataEditor)this.tabFolder.getSelection().getData();
    }

    @Override
    public IHopFileTypeHandler getActiveFileTypeHandler() {
        MetadataEditor<?> editor = this.getActiveEditor();
        if (editor != null) {
            return editor;
        }
        return new EmptyHopFileTypeHandler();
    }

    @Override
    public void setActiveFileTypeHandler(IHopFileTypeHandler fileTypeHandler) {
        if (fileTypeHandler instanceof MetadataEditor) {
            this.setActiveEditor((MetadataEditor)fileTypeHandler);
        }
    }

    protected void onTabClose(CTabFolderEvent event) {
        CTabItem tabItem = (CTabItem)event.item;
        MetadataEditor editor = (MetadataEditor)tabItem.getData();
        if (editor.isCloseable()) {
            this.editors.remove(editor);
            tabItem.dispose();
            this.refresh();
            if (this.tabFolder.getItemCount() == 0) {
                HopGui.getInstance().handleFileCapabilities(new EmptyFileType(), false, false, false);
            }
        } else {
            event.doit = false;
        }
    }

    public void onNewMetadata() {
        if (this.tree.getSelectionCount() != 1) {
            return;
        }
        TreeItem treeItem = this.tree.getSelection()[0];
        if (treeItem != null) {
            String objectKey = treeItem.getParentItem() == null ? (String)treeItem.getData() : (String)treeItem.getParentItem().getData();
            try {
                MultiMetadataProvider metadataProvider = this.hopGui.getMetadataProvider();
                Class metadataClass = metadataProvider.getMetadataClassForKey(objectKey);
                MetadataManager manager = new MetadataManager(HopGui.getInstance().getVariables(), (IHopMetadataProvider)metadataProvider, metadataClass);
                manager.newMetadataWithEditor();
            }
            catch (Exception e) {
                new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)"MetadataPerspective.CreateMetadata.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetadataPerspective.CreateMetadata.Error.Message", (String[])new String[0]), e);
            }
        }
    }

    public void onEditMetadata() {
        if (this.tree.getSelectionCount() != 1) {
            return;
        }
        TreeItem treeItem = this.tree.getSelection()[0];
        if (treeItem != null && treeItem.getParentItem() != null) {
            String objectName;
            String objectKey = (String)treeItem.getParentItem().getData();
            MetadataEditor<?> editor = this.findEditor(objectKey, objectName = treeItem.getText(0));
            if (editor != null) {
                this.setActiveEditor(editor);
            } else {
                try {
                    MetadataManager<IHopMetadata> manager = this.getMetadataManager(objectKey);
                    manager.editWithEditor(objectName);
                }
                catch (Exception e) {
                    new ErrorDialog(this.getShell(), "Error", "Error editing metadata", e);
                }
            }
            this.updateSelection();
        }
    }

    @GuiToolbarElement(root="MetadataPerspective-Toolbar", id="MetadataPerspective-Toolbar-10010-Edit", toolTip="i18n::MetadataPerspective.ToolbarElement.Edit.Tooltip", image="ui/images/edit.svg")
    public void onRenameMetadata() {
        if (this.tree.getSelectionCount() < 1) {
            return;
        }
        TreeItem item = this.tree.getSelection()[0];
        if (item != null) {
            if (item.getParentItem() == null) {
                return;
            }
            String objectKey = (String)item.getParentItem().getData();
            Text text = new Text((Composite)this.tree, 2048);
            text.setText(item.getText());
            text.addListener(16, event -> text.dispose());
            text.addListener(2, event -> {
                switch (event.keyCode) {
                    case 13: 
                    case 0x1000050: {
                        if (item.getText().equals(text.getText())) break;
                        try {
                            MetadataManager<IHopMetadata> manager = this.getMetadataManager(objectKey);
                            if (!manager.rename(item.getText(), text.getText())) break;
                            item.setText(text.getText());
                            text.dispose();
                        }
                        catch (Exception e) {
                            new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)"MetadataPerspective.EditMetadata.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetadataPerspective.EditMetadata.Error.Message", (String[])new String[0]), e);
                        }
                        break;
                    }
                    case 27: {
                        text.dispose();
                    }
                }
            });
            text.selectAll();
            text.setFocus();
            this.treeEditor.setEditor((Control)text, item);
        }
    }

    @GuiToolbarElement(root="MetadataPerspective-Toolbar", id="MetadataPerspective-Toolbar-10040-Delete", toolTip="i18n::MetadataPerspective.ToolbarElement.Delete.Tooltip", image="ui/images/delete.svg")
    public void onDeleteMetadata() {
        if (this.tree.getSelectionCount() != 1) {
            return;
        }
        TreeItem treeItem = this.tree.getSelection()[0];
        if (treeItem != null && treeItem.getParentItem() != null) {
            String objectKey = (String)treeItem.getParentItem().getData();
            String objectName = treeItem.getText(0);
            try {
                MetadataManager<IHopMetadata> manager = this.getMetadataManager(objectKey);
                manager.deleteMetadata(objectName);
                this.refresh();
                this.updateSelection();
            }
            catch (Exception e) {
                new ErrorDialog(this.getShell(), "Error", "Error delete metadata", e);
            }
        }
    }

    @GuiToolbarElement(root="MetadataPerspective-Toolbar", id="MetadataPerspective-Toolbar-10030-Duplicate", toolTip="i18n::MetadataPerspective.ToolbarElement.CreateCopy.Tooltip", image="ui/images/duplicate.svg")
    public void duplicateMetadata() {
        if (this.tree.getSelectionCount() != 1) {
            return;
        }
        TreeItem treeItem = this.tree.getSelection()[0];
        if (treeItem != null && treeItem.getParentItem() != null) {
            String objectKey = (String)treeItem.getParentItem().getData();
            String objectName = treeItem.getText(0);
            try {
                String newName;
                MetadataManager<IHopMetadata> manager = this.getMetadataManager(objectKey);
                IHopMetadata metadata = manager.loadElement(objectName);
                int copyNr = 2;
                while (true) {
                    newName = objectName + " " + copyNr;
                    if (!manager.getSerializer().exists(newName)) break;
                    ++copyNr;
                }
                metadata.setName(newName);
                manager.getSerializer().save(metadata);
                this.refresh();
            }
            catch (Exception e) {
                new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)"MetadataPerspective.DuplicateMetadata.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetadataPerspective.DuplicateMetadata.Error.Message", (String[])new String[0]), e);
            }
        }
    }

    public void updateEditor(MetadataEditor<?> editor) {
        if (editor == null) {
            return;
        }
        for (CTabItem item : this.tabFolder.getItems()) {
            if (!editor.equals(item.getData())) continue;
            item.setText(editor.getTitle());
            if (editor.hasChanged()) {
                item.setFont(GuiResource.getInstance().getFontBold());
                break;
            }
            item.setFont(this.tabFolder.getFont());
            break;
        }
        this.refresh();
        this.updateGui();
    }

    public void updateGui() {
        if (this.hopGui == null || this.toolBarWidgets == null || this.toolBar == null || this.toolBar.isDisposed()) {
            return;
        }
        IHopFileTypeHandler activeHandler = this.getActiveFileTypeHandler();
        this.hopGui.getDisplay().asyncExec(() -> this.hopGui.handleFileCapabilities(activeHandler.getFileType(), activeHandler.hasChanged(), false, false));
    }

    @GuiToolbarElement(root="MetadataPerspective-Toolbar", id="MetadataPerspective-Toolbar-10100-Refresh", toolTip="i18n::MetadataPerspective.ToolbarElement.Refresh.Tooltip", image="ui/images/refresh.svg")
    @GuiKeyboardShortcut(key=0x100000E)
    @GuiOsxKeyboardShortcut(key=0x100000E)
    public void refresh() {
        try {
            this.tree.setRedraw(false);
            this.tree.removeAll();
            MultiMetadataProvider metadataProvider = this.hopGui.getMetadataProvider();
            List metadataClasses = metadataProvider.getMetadataClasses();
            Collections.sort(metadataClasses, (cl1, cl2) -> {
                HopMetadata a1 = HopMetadataUtil.getHopMetadataAnnotation((Class)cl1);
                HopMetadata a2 = HopMetadataUtil.getHopMetadataAnnotation((Class)cl2);
                return a1.name().compareTo(a2.name());
            });
            for (Class metadataClass : metadataClasses) {
                HopMetadata annotation = HopMetadataUtil.getHopMetadataAnnotation((Class)metadataClass);
                Image image = GuiResource.getInstance().getImage(annotation.image(), metadataClass.getClassLoader(), 16, 16);
                TreeItem classItem = new TreeItem(this.tree, 0);
                classItem.setText(0, Const.NVL((String)annotation.name(), (String)""));
                classItem.setImage(image);
                classItem.setExpanded(true);
                classItem.setData((Object)annotation.key());
                classItem.setData(KEY_HELP, (Object)annotation.description());
                IHopMetadataSerializer serializer = metadataProvider.getSerializer(metadataClass);
                List names = serializer.listObjectNames();
                Collections.sort(names);
                for (String name : names) {
                    TreeItem item = new TreeItem(classItem, 0);
                    item.setText(0, Const.NVL((String)name, (String)""));
                    MetadataEditor<?> editor = this.findEditor(annotation.key(), name);
                    if (editor == null || !editor.hasChanged()) continue;
                    item.setFont(GuiResource.getInstance().getFontBold());
                }
            }
            TreeUtil.setOptimalWidthOnColumns(this.tree);
            TreeMemory.setExpandedFromMemory(this.tree, METADATA_PERSPECTIVE_TREE);
            this.tree.setRedraw(true);
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)"MetadataPerspective.RefreshMetadata.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetadataPerspective.RefreshMetadata.Error.Message", (String[])new String[0]), e);
        }
    }

    protected void updateSelection() {
        String objectKey = null;
        String objectName = null;
        if (this.tree.getSelectionCount() > 0) {
            TreeItem selectedItem = this.tree.getSelection()[0];
            if (selectedItem.getParentItem() == null) {
                objectKey = selectedItem.getText();
                objectName = null;
            } else {
                objectKey = (String)selectedItem.getParentItem().getData();
                objectName = selectedItem.getText(0);
            }
        }
        this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_EDIT, StringUtils.isNotEmpty(objectName));
        this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_DUPLICATE, StringUtils.isNotEmpty(objectName));
        this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_DELETE, StringUtils.isNotEmpty(objectName));
    }

    @Override
    public boolean remove(IHopFileTypeHandler typeHandler) {
        MetadataEditor editor;
        if (typeHandler instanceof MetadataEditor && (editor = (MetadataEditor)typeHandler).isCloseable()) {
            this.editors.remove(editor);
            for (CTabItem item : this.tabFolder.getItems()) {
                if (!editor.equals(item.getData())) continue;
                item.dispose();
            }
            this.refresh();
            if (this.tabFolder.getItemCount() == 0) {
                HopGui.getInstance().handleFileCapabilities(new EmptyFileType(), false, false, false);
            }
        }
        return false;
    }

    @Override
    public List<TabItemHandler> getItems() {
        ArrayList<TabItemHandler> items = new ArrayList<TabItemHandler>();
        for (CTabItem tabItem : this.tabFolder.getItems()) {
            for (MetadataEditor<?> editor : this.editors) {
                if (!tabItem.getData().equals(editor)) continue;
                items.add(new TabItemHandler(tabItem, editor));
            }
        }
        return items;
    }

    @Override
    public void navigateToPreviousFile() {
        this.tabFolder.setSelection(this.tabFolder.getSelectionIndex() + 1);
    }

    @Override
    public void navigateToNextFile() {
        this.tabFolder.setSelection(this.tabFolder.getSelectionIndex() - 1);
    }

    @Override
    public boolean hasNavigationPreviousFile() {
        if (this.tabFolder.getItemCount() == 0) {
            return false;
        }
        return this.tabFolder.getSelectionIndex() >= 1;
    }

    @Override
    public boolean hasNavigationNextFile() {
        if (this.tabFolder.getItemCount() == 0) {
            return false;
        }
        return this.tabFolder.getSelectionIndex() < this.tabFolder.getItemCount();
    }

    @Override
    public Control getControl() {
        return this.sash;
    }

    protected Shell getShell() {
        return this.hopGui.getShell();
    }

    @Override
    public List<IGuiContextHandler> getContextHandlers() {
        ArrayList<IGuiContextHandler> handlers = new ArrayList<IGuiContextHandler>();
        return handlers;
    }

    @Override
    public List<ISearchable> getSearchables() {
        ArrayList<ISearchable> searchables = new ArrayList<ISearchable>();
        return searchables;
    }
}

