/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.kerb;

import com.sun.xml.ws.security.kerb.Krb5CredElement;
import com.sun.xml.ws.security.kerb.Krb5MechFactory;
import com.sun.xml.ws.security.kerb.Krb5NameElement;
import com.sun.xml.ws.security.kerb.Krb5Util;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.kerberos.KerberosKey;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.krb5.EncryptionKey;

public class Krb5AcceptCredential
extends KerberosKey
implements Krb5CredElement {
    private static final long serialVersionUID = 7714332137352567952L;
    private Krb5NameElement name;
    private EncryptionKey[] krb5EncryptionKeys;

    private Krb5AcceptCredential(Krb5NameElement name, KerberosKey[] keys) {
        super(keys[0].getPrincipal(), keys[0].getEncoded(), keys[0].getKeyType(), keys[0].getVersionNumber());
        this.name = name;
        this.krb5EncryptionKeys = new EncryptionKey[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            this.krb5EncryptionKeys[i] = new EncryptionKey(keys[i].getEncoded(), keys[i].getKeyType(), new Integer(keys[i].getVersionNumber()));
        }
    }

    static Krb5AcceptCredential getInstance(final int caller, Krb5NameElement name) throws GSSException {
        KerberosKey[] keys;
        final String serverPrinc = name == null ? null : name.getKrb5PrincipalName().getName();
        final AccessControlContext acc = AccessController.getContext();
        try {
            keys = (KerberosKey[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Krb5Util.getKeys(caller == -1 ? 2 : caller, serverPrinc, acc);
                }
            });
        }
        catch (PrivilegedActionException e) {
            GSSException ge = new GSSException(13, -1, "Attempt to obtain new ACCEPT credentials failed!");
            ge.initCause(e.getException());
            throw ge;
        }
        if (keys == null || keys.length == 0) {
            throw new GSSException(13, -1, "Failed to find any Kerberos Key");
        }
        if (name == null) {
            String fullName = keys[0].getPrincipal().getName();
            name = Krb5NameElement.getInstance(fullName, Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL);
        }
        return new Krb5AcceptCredential(name, keys);
    }

    public final GSSNameSpi getName() throws GSSException {
        return this.name;
    }

    public int getInitLifetime() throws GSSException {
        return 0;
    }

    public int getAcceptLifetime() throws GSSException {
        return Integer.MAX_VALUE;
    }

    public boolean isInitiatorCredential() throws GSSException {
        return false;
    }

    public boolean isAcceptorCredential() throws GSSException {
        return true;
    }

    public final Oid getMechanism() {
        return Krb5MechFactory.GSS_KRB5_MECH_OID;
    }

    public final Provider getProvider() {
        return Krb5MechFactory.PROVIDER;
    }

    EncryptionKey[] getKrb5EncryptionKeys() {
        return this.krb5EncryptionKeys;
    }

    public void dispose() throws GSSException {
        try {
            this.destroy();
        }
        catch (DestroyFailedException e) {
            GSSException gssException = new GSSException(11, -1, "Could not destroy credentials - " + e.getMessage());
            gssException.initCause(e);
        }
    }

    public void destroy() throws DestroyFailedException {
        if (this.krb5EncryptionKeys != null) {
            for (int i = 0; i < this.krb5EncryptionKeys.length; ++i) {
                this.krb5EncryptionKeys[i].destroy();
            }
            this.krb5EncryptionKeys = null;
        }
        super.destroy();
    }
}

