/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.path;

import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.internal.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ArrayIndexOperation {
    private final List<Integer> indexes;

    private ArrayIndexOperation(List<Integer> indexes) {
        this.indexes = Collections.unmodifiableList(indexes);
    }

    public List<Integer> indexes() {
        return this.indexes;
    }

    public boolean isSingleIndexOperation() {
        return this.indexes.size() == 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(Utils.join(",", this.indexes));
        sb.append("]");
        return sb.toString();
    }

    public static ArrayIndexOperation parse(String operation) {
        for (int i = 0; i < operation.length(); ++i) {
            char c = operation.charAt(i);
            if (Character.isDigit(c) || c == ',') continue;
            throw new InvalidPathException("Failed to parse ArrayIndexOperation: " + operation);
        }
        String[] tokens = operation.split(",");
        ArrayList<Integer> tempIndexes = new ArrayList<Integer>();
        for (String token : tokens) {
            tempIndexes.add(ArrayIndexOperation.parseInteger(token));
        }
        return new ArrayIndexOperation(tempIndexes);
    }

    private static Integer parseInteger(String token) {
        try {
            return Integer.parseInt(token);
        }
        catch (Exception e) {
            throw new InvalidPathException("Failed to parse token in ArrayIndexOperation: " + token, e);
        }
    }
}

