/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceBase;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryTableSourceDef;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;

@VisibleForTesting
class BigQueryTableSource<T>
extends BigQuerySourceBase<T> {
    private final BigQueryTableSourceDef tableDef;
    private final AtomicReference<Long> tableSizeBytes;

    static <T> BigQueryTableSource<T> create(String stepUuid, BigQueryTableSourceDef tableDef, BigQueryServices bqServices, Coder<T> coder, SerializableFunction<SchemaAndRecord, T> parseFn, boolean useAvroLogicalTypes) {
        return new BigQueryTableSource<T>(stepUuid, tableDef, bqServices, coder, parseFn, useAvroLogicalTypes);
    }

    private BigQueryTableSource(String stepUuid, BigQueryTableSourceDef tableDef, BigQueryServices bqServices, Coder<T> coder, SerializableFunction<SchemaAndRecord, T> parseFn, boolean useAvroLogicalTypes) {
        super(stepUuid, bqServices, coder, parseFn, useAvroLogicalTypes);
        this.tableDef = tableDef;
        this.tableSizeBytes = new AtomicReference();
    }

    @Override
    protected TableReference getTableToExtract(BigQueryOptions bqOptions) throws IOException {
        return this.tableDef.getTableReference(bqOptions);
    }

    public synchronized long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
        if (this.tableSizeBytes.get() == null) {
            BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
            TableReference tableRef = this.tableDef.getTableReference(bqOptions);
            Table table = this.bqServices.getDatasetService(bqOptions).getTable(tableRef);
            Long numBytes = table.getNumBytes();
            if (table.getStreamingBuffer() != null && table.getStreamingBuffer().getEstimatedBytes() != null) {
                numBytes = numBytes + table.getStreamingBuffer().getEstimatedBytes().longValue();
            }
            this.tableSizeBytes.compareAndSet(null, numBytes);
        }
        return this.tableSizeBytes.get();
    }

    @Override
    protected void cleanupTempResource(BigQueryOptions bqOptions) throws Exception {
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item((String)"table", this.tableDef.getJsonTable()));
        builder.add(DisplayData.item((String)"launchesBigQueryJobs", (Boolean)true).withLabel("This transform launches BigQuery jobs to read/write elements."));
    }
}

