/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.healthcare.FhirSearchParameter;

public class FhirSearchParameterCoder<T>
extends CustomCoder<FhirSearchParameter<T>> {
    private static final NullableCoder<String> STRING_CODER = NullableCoder.of((Coder)StringUtf8Coder.of());
    private final NullableCoder<Map<String, T>> originalCoder;

    FhirSearchParameterCoder(Coder<T> originalCoder) {
        this.originalCoder = NullableCoder.of((Coder)MapCoder.of(STRING_CODER, originalCoder));
    }

    public static <T> FhirSearchParameterCoder<T> of(Coder<T> originalCoder) {
        return new FhirSearchParameterCoder<T>(originalCoder);
    }

    public void encode(FhirSearchParameter<T> value, OutputStream outStream) throws IOException {
        STRING_CODER.encode((Object)value.getResourceType(), outStream);
        STRING_CODER.encode((Object)value.getKey(), outStream);
        this.originalCoder.encode(value.getQueries(), outStream);
    }

    public FhirSearchParameter<T> decode(InputStream inStream) throws IOException {
        String resourceType = (String)STRING_CODER.decode(inStream);
        String key = (String)STRING_CODER.decode(inStream);
        Map queries = (Map)this.originalCoder.decode(inStream);
        return FhirSearchParameter.of(resourceType, key, queries);
    }
}

