/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.google.api.services.healthcare.v1.model.DeidentifyConfig;
import com.google.api.services.healthcare.v1.model.DicomStore;
import com.google.api.services.healthcare.v1.model.Empty;
import com.google.api.services.healthcare.v1.model.FhirStore;
import com.google.api.services.healthcare.v1.model.Hl7V2Store;
import com.google.api.services.healthcare.v1.model.HttpBody;
import com.google.api.services.healthcare.v1.model.IngestMessageResponse;
import com.google.api.services.healthcare.v1.model.ListMessagesResponse;
import com.google.api.services.healthcare.v1.model.Message;
import com.google.api.services.healthcare.v1.model.Operation;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;

public interface HealthcareApiClient {
    public Message getHL7v2Message(String var1) throws IOException, ParseException;

    public Empty deleteHL7v2Message(String var1) throws IOException;

    public Hl7V2Store getHL7v2Store(String var1) throws IOException;

    public Instant getEarliestHL7v2SendTime(String var1, @Nullable String var2) throws IOException;

    public Instant getLatestHL7v2SendTime(String var1, @Nullable String var2) throws IOException;

    public ListMessagesResponse makeSendTimeBoundHL7v2ListRequest(String var1, Instant var2, @Nullable Instant var3, @Nullable String var4, @Nullable String var5, @Nullable String var6) throws IOException;

    public ListMessagesResponse makeHL7v2ListRequest(String var1, @Nullable String var2, @Nullable String var3, @Nullable String var4) throws IOException;

    public IngestMessageResponse ingestHL7v2Message(String var1, Message var2) throws IOException;

    public Message createHL7v2Message(String var1, Message var2) throws IOException;

    public Operation importFhirResource(String var1, String var2, @Nullable String var3) throws IOException;

    public Operation exportFhirResourceToGcs(String var1, String var2) throws IOException;

    public Operation deidentifyFhirStore(String var1, String var2, DeidentifyConfig var3) throws IOException;

    public Operation pollOperation(Operation var1, Long var2) throws InterruptedException, IOException;

    public HttpBody executeFhirBundle(String var1, String var2) throws IOException, HttpHealthcareApiClient.HealthcareHttpException;

    public HttpBody readFhirResource(String var1) throws IOException;

    public HttpBody searchFhirResource(String var1, String var2, @Nullable Map<String, Object> var3, String var4) throws IOException;

    public HttpBody getPatientEverything(String var1, @Nullable Map<String, Object> var2, String var3) throws IOException;

    public Hl7V2Store createHL7v2Store(String var1, String var2) throws IOException;

    public FhirStore createFhirStore(String var1, String var2, String var3, String var4) throws IOException;

    public FhirStore createFhirStore(String var1, String var2, String var3) throws IOException;

    public List<FhirStore> listAllFhirStores(String var1) throws IOException;

    public Empty deleteHL7v2Store(String var1) throws IOException;

    public Empty deleteFhirStore(String var1) throws IOException;

    public String retrieveDicomStudyMetadata(String var1) throws IOException;

    public DicomStore createDicomStore(String var1, String var2) throws IOException;

    public DicomStore createDicomStore(String var1, String var2, String var3) throws IOException;

    public Empty deleteDicomStore(String var1) throws IOException;

    public Empty uploadToDicomStore(String var1, String var2) throws IOException, URISyntaxException;
}

