/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.action;

import com.google.cloud.Timestamp;
import io.opencensus.common.Scope;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.util.Optional;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.HeartbeatRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatRecordAction {
    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatRecordAction.class);
    private static final Tracer TRACER = Tracing.getTracer();
    private final ChangeStreamMetrics metrics;

    HeartbeatRecordAction(ChangeStreamMetrics metrics) {
        this.metrics = metrics;
    }

    @VisibleForTesting
    public Optional<DoFn.ProcessContinuation> run(PartitionMetadata partition, HeartbeatRecord record, RestrictionTracker<TimestampRange, Timestamp> tracker, ManualWatermarkEstimator<Instant> watermarkEstimator) {
        try (Scope scope = TRACER.spanBuilder("HeartbeatRecordAction").setRecordEvents(true).startScopedSpan();){
            TRACER.getCurrentSpan().putAttribute("PartitionID", AttributeValue.stringAttributeValue((String)partition.getPartitionToken()));
            String token = partition.getPartitionToken();
            LOG.debug("[" + token + "] Processing heartbeat record " + record);
            Timestamp timestamp = record.getTimestamp();
            Instant timestampInstant = new Instant(timestamp.toSqlTimestamp().getTime());
            if (!tracker.tryClaim((Object)timestamp)) {
                LOG.debug("[" + token + "] Could not claim queryChangeStream(" + timestamp + "), stopping");
                Optional<DoFn.ProcessContinuation> optional = Optional.of(DoFn.ProcessContinuation.stop());
                return optional;
            }
            this.metrics.incHeartbeatRecordCount();
            watermarkEstimator.setWatermark(timestampInstant);
            LOG.debug("[" + token + "] Heartbeat record action completed successfully");
            Optional<DoFn.ProcessContinuation> optional = Optional.empty();
            return optional;
        }
    }
}

