/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import java.util.Iterator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.MutableDeletionInfo;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.rows.AbstractUnfilteredRowIterator;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowAndDeletionMergeIterator;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.utils.SearchIterator;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.BTreeSearchIterator;

public abstract class AbstractBTreePartition
implements Partition,
Iterable<Row> {
    protected static final Holder EMPTY = new Holder(PartitionColumns.NONE, BTree.empty(), DeletionInfo.LIVE, Rows.EMPTY_STATIC_ROW, EncodingStats.NO_STATS);
    protected final CFMetaData metadata;
    protected final DecoratedKey partitionKey;

    protected abstract Holder holder();

    protected abstract boolean canHaveShadowedData();

    protected AbstractBTreePartition(CFMetaData metadata, DecoratedKey partitionKey) {
        this.metadata = metadata;
        this.partitionKey = partitionKey;
    }

    public DeletionInfo deletionInfo() {
        return this.holder().deletionInfo;
    }

    public Row staticRow() {
        return this.holder().staticRow;
    }

    @Override
    public boolean isEmpty() {
        Holder holder = this.holder();
        return holder.deletionInfo.isLive() && BTree.isEmpty(holder.tree) && holder.staticRow.isEmpty();
    }

    public boolean hasRows() {
        Holder holder = this.holder();
        return !BTree.isEmpty(holder.tree);
    }

    @Override
    public CFMetaData metadata() {
        return this.metadata;
    }

    @Override
    public DecoratedKey partitionKey() {
        return this.partitionKey;
    }

    @Override
    public DeletionTime partitionLevelDeletion() {
        return this.deletionInfo().getPartitionDeletion();
    }

    @Override
    public PartitionColumns columns() {
        return this.holder().columns;
    }

    @Override
    public EncodingStats stats() {
        return this.holder().stats;
    }

    @Override
    public Row getRow(Clustering clustering) {
        Row row = this.searchIterator(ColumnFilter.selection(this.columns()), false).next(clustering);
        return row == null || clustering == Clustering.STATIC_CLUSTERING && row.isEmpty() ? null : row;
    }

    private Row staticRow(Holder current, ColumnFilter columns, boolean setActiveDeletionToRow) {
        DeletionTime partitionDeletion = current.deletionInfo.getPartitionDeletion();
        if (columns.fetchedColumns().statics.isEmpty() || current.staticRow.isEmpty() && partitionDeletion.isLive()) {
            return Rows.EMPTY_STATIC_ROW;
        }
        Row row = current.staticRow.filter(columns, partitionDeletion, setActiveDeletionToRow, this.metadata);
        return row == null ? Rows.EMPTY_STATIC_ROW : row;
    }

    @Override
    public SearchIterator<Clustering, Row> searchIterator(final ColumnFilter columns, final boolean reversed) {
        final Holder current = this.holder();
        return new SearchIterator<Clustering, Row>(){
            private final SearchIterator<Clustering, Row> rawIter;
            private final DeletionTime partitionDeletion;
            {
                this.rawIter = new BTreeSearchIterator<Clusterable, Row>(current.tree, AbstractBTreePartition.this.metadata.comparator, BTree.Dir.desc(reversed));
                this.partitionDeletion = current.deletionInfo.getPartitionDeletion();
            }

            @Override
            public Row next(Clustering clustering) {
                if (clustering == Clustering.STATIC_CLUSTERING) {
                    return AbstractBTreePartition.this.staticRow(current, columns, true);
                }
                Row row = this.rawIter.next(clustering);
                RangeTombstone rt = current.deletionInfo.rangeCovering(clustering);
                DeletionTime activeDeletion = this.partitionDeletion;
                if (rt != null && rt.deletionTime().supersedes(activeDeletion)) {
                    activeDeletion = rt.deletionTime();
                }
                if (row == null) {
                    if (activeDeletion == this.partitionDeletion) {
                        return null;
                    }
                    return BTreeRow.emptyDeletedRow(clustering, Row.Deletion.regular(activeDeletion));
                }
                return row.filter(columns, activeDeletion, true, AbstractBTreePartition.this.metadata);
            }
        };
    }

    @Override
    public UnfilteredRowIterator unfilteredIterator() {
        return this.unfilteredIterator(ColumnFilter.selection(this.columns()), Slices.ALL, false);
    }

    @Override
    public UnfilteredRowIterator unfilteredIterator(ColumnFilter selection, Slices slices, boolean reversed) {
        return this.unfilteredIterator(this.holder(), selection, slices, reversed);
    }

    public UnfilteredRowIterator unfilteredIterator(Holder current, ColumnFilter selection, Slices slices, boolean reversed) {
        Row staticRow = this.staticRow(current, selection, false);
        if (slices.size() == 0) {
            DeletionTime partitionDeletion = current.deletionInfo.getPartitionDeletion();
            return UnfilteredRowIterators.noRowsIterator(this.metadata, this.partitionKey(), staticRow, partitionDeletion, reversed);
        }
        return slices.size() == 1 ? this.sliceIterator(selection, slices.get(0), reversed, current, staticRow) : new SlicesIterator(selection, slices, reversed, current, staticRow);
    }

    private UnfilteredRowIterator sliceIterator(ColumnFilter selection, Slice slice, boolean reversed, Holder current, Row staticRow) {
        ClusteringBound start = slice.start() == ClusteringBound.BOTTOM ? null : slice.start();
        ClusteringBound end = slice.end() == ClusteringBound.TOP ? null : slice.end();
        BTreeSearchIterator rowIter = BTree.slice(current.tree, this.metadata.comparator, start, true, end, true, BTree.Dir.desc(reversed));
        Iterator<RangeTombstone> deleteIter = current.deletionInfo.rangeIterator(slice, reversed);
        return this.merge(rowIter, deleteIter, selection, reversed, current, staticRow);
    }

    private RowAndDeletionMergeIterator merge(Iterator<Row> rowIter, Iterator<RangeTombstone> deleteIter, ColumnFilter selection, boolean reversed, Holder current, Row staticRow) {
        return new RowAndDeletionMergeIterator(this.metadata, this.partitionKey(), current.deletionInfo.getPartitionDeletion(), selection, staticRow, reversed, current.stats, rowIter, deleteIter, this.canHaveShadowedData());
    }

    protected static Holder build(UnfilteredRowIterator iterator, int initialRowCapacity) {
        return AbstractBTreePartition.build(iterator, initialRowCapacity, true, null);
    }

    protected static Holder build(UnfilteredRowIterator iterator, int initialRowCapacity, boolean ordered, BTree.Builder.QuickResolver<Row> quickResolver) {
        CFMetaData metadata = iterator.metadata();
        PartitionColumns columns = iterator.columns();
        boolean reversed = iterator.isReverseOrder();
        BTree.Builder<Clusterable> builder = BTree.builder(metadata.comparator, initialRowCapacity);
        builder.auto(!ordered);
        builder.setQuickResolver(quickResolver);
        MutableDeletionInfo.Builder deletionBuilder = MutableDeletionInfo.builder(iterator.partitionLevelDeletion(), metadata.comparator, reversed);
        while (iterator.hasNext()) {
            Unfiltered unfiltered = (Unfiltered)iterator.next();
            if (unfiltered.kind() == Unfiltered.Kind.ROW) {
                builder.add((Row)unfiltered);
                continue;
            }
            deletionBuilder.add((RangeTombstoneMarker)unfiltered);
        }
        if (reversed) {
            builder.reverse();
        }
        return new Holder(columns, builder.build(), deletionBuilder.build(), iterator.staticRow(), iterator.stats());
    }

    protected static Holder build(RowIterator rows, DeletionInfo deletion, boolean buildEncodingStats, int initialRowCapacity) {
        CFMetaData metadata = rows.metadata();
        PartitionColumns columns = rows.columns();
        boolean reversed = rows.isReverseOrder();
        BTree.Builder<Clusterable> builder = BTree.builder(metadata.comparator, initialRowCapacity);
        builder.auto(false);
        while (rows.hasNext()) {
            builder.add((Clusterable)rows.next());
        }
        if (reversed) {
            builder.reverse();
        }
        Row staticRow = rows.staticRow();
        Object[] tree = builder.build();
        EncodingStats stats = buildEncodingStats ? EncodingStats.Collector.collect(staticRow, BTree.iterator(tree), deletion) : EncodingStats.NO_STATS;
        return new Holder(columns, tree, deletion, staticRow, stats);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("[%s.%s] key=%s partition_deletion=%s columns=%s", this.metadata.ksName, this.metadata.cfName, this.metadata.getKeyValidator().getString(this.partitionKey().getKey()), this.partitionLevelDeletion(), this.columns()));
        if (this.staticRow() != Rows.EMPTY_STATIC_ROW) {
            sb.append("\n    ").append(this.staticRow().toString(this.metadata, true));
        }
        try (UnfilteredRowIterator iter = this.unfilteredIterator();){
            while (iter.hasNext()) {
                sb.append("\n    ").append(((Unfiltered)iter.next()).toString(this.metadata, true));
            }
        }
        return sb.toString();
    }

    public int rowCount() {
        return BTree.size(this.holder().tree);
    }

    @Override
    public Iterator<Row> iterator() {
        return BTree.iterator(this.holder().tree);
    }

    public Row lastRow() {
        Object[] tree = this.holder().tree;
        if (BTree.isEmpty(tree)) {
            return null;
        }
        return (Row)BTree.findByIndex(tree, BTree.size(tree) - 1);
    }

    public class SlicesIterator
    extends AbstractIterator {
        private final Slices slices;
        private int idx;
        private Iterator<Unfiltered> currentSlice;

        private SlicesIterator(ColumnFilter selection, Slices slices, boolean isReversed, Holder current, Row staticRow) {
            super(current, staticRow, selection, isReversed);
            this.slices = slices;
        }

        @Override
        protected Unfiltered computeNext() {
            while (true) {
                if (this.currentSlice == null) {
                    if (this.idx >= this.slices.size()) {
                        return (Unfiltered)this.endOfData();
                    }
                    int sliceIdx = this.isReverseOrder ? this.slices.size() - this.idx - 1 : this.idx;
                    this.currentSlice = AbstractBTreePartition.this.sliceIterator(this.selection, this.slices.get(sliceIdx), this.isReverseOrder, this.current, Rows.EMPTY_STATIC_ROW);
                    ++this.idx;
                }
                if (this.currentSlice.hasNext()) {
                    return this.currentSlice.next();
                }
                this.currentSlice = null;
            }
        }
    }

    private abstract class AbstractIterator
    extends AbstractUnfilteredRowIterator {
        final Holder current;
        final ColumnFilter selection;

        private AbstractIterator(Holder current, Row staticRow, ColumnFilter selection, boolean isReversed) {
            super(AbstractBTreePartition.this.metadata, AbstractBTreePartition.this.partitionKey(), current.deletionInfo.getPartitionDeletion(), selection.fetchedColumns(), staticRow, isReversed, current.stats);
            this.current = current;
            this.selection = selection;
        }
    }

    protected static final class Holder {
        final PartitionColumns columns;
        final DeletionInfo deletionInfo;
        final Object[] tree;
        final Row staticRow;
        final EncodingStats stats;

        Holder(PartitionColumns columns, Object[] tree, DeletionInfo deletionInfo, Row staticRow, EncodingStats stats) {
            this.columns = columns;
            this.tree = tree;
            this.deletionInfo = deletionInfo;
            this.staticRow = staticRow == null ? Rows.EMPTY_STATIC_ROW : staticRow;
            this.stats = stats;
        }
    }
}

