/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.transform;

import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.Transformation;

public final class RTBoundValidator
extends Transformation<UnfilteredRowIterator> {
    private final Stage stage;
    private final boolean enforceIsClosed;

    private RTBoundValidator(Stage stage, boolean enforceIsClosed) {
        this.stage = stage;
        this.enforceIsClosed = enforceIsClosed;
    }

    public static UnfilteredPartitionIterator validate(UnfilteredPartitionIterator partitions, Stage stage, boolean enforceIsClosed) {
        return Transformation.apply(partitions, new RTBoundValidator(stage, enforceIsClosed));
    }

    public static UnfilteredRowIterator validate(UnfilteredRowIterator partition, Stage stage, boolean enforceIsClosed) {
        return Transformation.apply(partition, new RowsTransformation(stage, partition.metadata(), partition.isReverseOrder(), enforceIsClosed));
    }

    @Override
    public UnfilteredRowIterator applyToPartition(UnfilteredRowIterator partition) {
        return Transformation.apply(partition, new RowsTransformation(this.stage, partition.metadata(), partition.isReverseOrder(), this.enforceIsClosed));
    }

    private static final class RowsTransformation
    extends Transformation {
        private final Stage stage;
        private final CFMetaData metadata;
        private final boolean isReverseOrder;
        private final boolean enforceIsClosed;
        private DeletionTime openMarkerDeletionTime;

        private RowsTransformation(Stage stage, CFMetaData metadata, boolean isReverseOrder, boolean enforceIsClosed) {
            this.stage = stage;
            this.metadata = metadata;
            this.isReverseOrder = isReverseOrder;
            this.enforceIsClosed = enforceIsClosed;
        }

        @Override
        public RangeTombstoneMarker applyToMarker(RangeTombstoneMarker marker) {
            if (null == this.openMarkerDeletionTime) {
                if (marker.isClose(this.isReverseOrder)) {
                    throw this.ise("unexpected end bound or boundary " + marker.toString(this.metadata));
                }
            } else {
                if (!marker.isClose(this.isReverseOrder)) {
                    throw this.ise("start bound followed by another start bound " + marker.toString(this.metadata));
                }
                DeletionTime deletionTime = marker.closeDeletionTime(this.isReverseOrder);
                if (!deletionTime.equals(this.openMarkerDeletionTime)) {
                    throw this.ise("open marker and close marker have different deletion times");
                }
                this.openMarkerDeletionTime = null;
            }
            if (marker.isOpen(this.isReverseOrder)) {
                this.openMarkerDeletionTime = marker.openDeletionTime(this.isReverseOrder);
            }
            return marker;
        }

        @Override
        public void onPartitionClose() {
            if (this.enforceIsClosed && null != this.openMarkerDeletionTime) {
                throw this.ise("expected all RTs to be closed, but the last one is open");
            }
        }

        private IllegalStateException ise(String why) {
            String message = String.format("%s UnfilteredRowIterator for %s.%s has an illegal RT bounds sequence: %s", new Object[]{this.stage, this.metadata.ksName, this.metadata.cfName, why});
            throw new IllegalStateException(message);
        }
    }

    public static enum Stage {
        MEMTABLE,
        SSTABLE,
        MERGED,
        PURGED,
        PROCESSED;

    }
}

