/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import java.nio.ByteBuffer;

public enum BufferType {
    ON_HEAP{

        @Override
        public ByteBuffer allocate(int size) {
            return ByteBuffer.allocate(size);
        }
    }
    ,
    OFF_HEAP{

        @Override
        public ByteBuffer allocate(int size) {
            return ByteBuffer.allocateDirect(size);
        }
    };


    public abstract ByteBuffer allocate(int var1);

    public static BufferType typeOf(ByteBuffer buffer) {
        return buffer.isDirect() ? OFF_HEAP : ON_HEAP;
    }
}

