/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.fn;

import java.math.BigDecimal;
import java.util.List;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.KV;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.shared.AggregationType;
import org.apache.hop.beam.core.util.JsonRowMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByFn
extends DoFn<KV<HopRow, Iterable<HopRow>>, HopRow> {
    private String counterName;
    private String groupRowMetaJson;
    private String subjectRowMetaJson;
    private String[] aggregations;
    private List<String> transformPluginClasses;
    private List<String> xpPluginClasses;
    private static final Logger LOG = LoggerFactory.getLogger(GroupByFn.class);
    private transient IRowMeta groupRowMeta;
    private transient IRowMeta subjectRowMeta;
    private transient AggregationType[] aggregationTypes = null;
    private transient Counter initCounter;
    private transient Counter readCounter;
    private transient Counter writtenCounter;
    private transient Counter errorCounter;

    public GroupByFn() {
    }

    public GroupByFn(String counterName, String groupRowMetaJson, List<String> transformPluginClasses, List<String> xpPluginClasses, String subjectRowMetaJson, String[] aggregations) {
        this.counterName = counterName;
        this.groupRowMetaJson = groupRowMetaJson;
        this.transformPluginClasses = transformPluginClasses;
        this.xpPluginClasses = xpPluginClasses;
        this.subjectRowMetaJson = subjectRowMetaJson;
        this.aggregations = aggregations;
    }

    @DoFn.Setup
    public void setUp() {
        try {
            this.readCounter = Metrics.counter((String)"read", (String)this.counterName);
            this.writtenCounter = Metrics.counter((String)"written", (String)this.counterName);
            this.errorCounter = Metrics.counter((String)"error", (String)this.counterName);
            BeamHop.init(this.transformPluginClasses, this.xpPluginClasses);
            this.groupRowMeta = JsonRowMeta.fromJson(this.groupRowMetaJson);
            this.subjectRowMeta = JsonRowMeta.fromJson(this.subjectRowMetaJson);
            this.aggregationTypes = new AggregationType[this.aggregations.length];
            for (int i = 0; i < this.aggregationTypes.length; ++i) {
                this.aggregationTypes[i] = AggregationType.getTypeFromName(this.aggregations[i]);
            }
            Metrics.counter((String)"init", (String)this.counterName).inc();
        }
        catch (Exception e) {
            this.errorCounter.inc();
            LOG.error("Error setup of grouping by ", (Throwable)e);
            throw new RuntimeException("Unable setup of group by ", e);
        }
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext processContext) {
        try {
            int i;
            KV inputElement = (KV)processContext.element();
            HopRow groupHopRow = (HopRow)inputElement.getKey();
            Object[] groupRow = groupHopRow.getRow();
            Object[] results = new Object[this.aggregationTypes.length];
            long[] counts = new long[this.aggregationTypes.length];
            for (int i2 = 0; i2 < results.length; ++i2) {
                results[i2] = null;
                counts[i2] = 0L;
            }
            Iterable subjectHopRows = (Iterable)inputElement.getValue();
            for (HopRow subjectHopRow : subjectHopRows) {
                Object[] subjectRow = subjectHopRow.getRow();
                this.readCounter.inc();
                for (int i3 = 0; i3 < this.aggregationTypes.length; ++i3) {
                    IValueMeta subjectValueMeta = this.subjectRowMeta.getValueMeta(i3);
                    Object subject = subjectRow[i3];
                    Object result = results[i3];
                    block1 : switch (this.aggregationTypes[i3]) {
                        case AVERAGE: {
                            if (!subjectValueMeta.isNull(subject)) {
                                int n = i3;
                                counts[n] = counts[n] + 1L;
                            }
                        }
                        case SUM: {
                            if (result == null) {
                                result = subject;
                                break;
                            }
                            switch (subjectValueMeta.getType()) {
                                case 5: {
                                    result = (Long)result + (Long)subject;
                                    break block1;
                                }
                                case 1: {
                                    result = (Double)result + (Double)subject;
                                    break block1;
                                }
                            }
                            throw new HopException("SUM aggregation not yet implemented for field and data type : " + subjectValueMeta.toString());
                        }
                        case COUNT_ALL: {
                            if (subject == null) break;
                            if (result == null) {
                                result = 1L;
                                break;
                            }
                            result = (Long)result + 1L;
                            break;
                        }
                        case MIN: {
                            if (subjectValueMeta.isNull(result)) {
                                result = subject;
                                break;
                            }
                            if (subjectValueMeta.compare(subject, result) >= 0) break;
                            result = subject;
                            break;
                        }
                        case MAX: {
                            if (subjectValueMeta.isNull(result)) {
                                result = subject;
                                break;
                            }
                            if (subjectValueMeta.compare(subject, result) <= 0) break;
                            result = subject;
                            break;
                        }
                        case FIRST_INCL_NULL: {
                            if (counts[i3] != 0L) break;
                            int n = i3;
                            counts[n] = counts[n] + 1L;
                            result = subject;
                            break;
                        }
                        case LAST_INCL_NULL: {
                            result = subject;
                            break;
                        }
                        case FIRST: {
                            if (subjectValueMeta.isNull(subject) || counts[i3] != 0L) break;
                            int n = i3;
                            counts[n] = counts[n] + 1L;
                            result = subject;
                            break;
                        }
                        case LAST: {
                            if (subjectValueMeta.isNull(subject)) break;
                            result = subject;
                            break;
                        }
                        default: {
                            throw new HopException("Sorry, aggregation type yet: " + this.aggregationTypes[i3].name() + " isn't implemented yet");
                        }
                    }
                    results[i3] = result;
                }
            }
            block28: for (int i4 = 0; i4 < results.length; ++i4) {
                IValueMeta subjectValueMeta = this.subjectRowMeta.getValueMeta(i4);
                switch (this.aggregationTypes[i4]) {
                    case AVERAGE: {
                        switch (subjectValueMeta.getType()) {
                            case 1: {
                                double dbl = (Double)results[i4];
                                if (counts[i4] != 0L) {
                                    dbl /= (double)counts[i4];
                                }
                                results[i4] = dbl;
                                continue block28;
                            }
                            case 5: {
                                long lng = (Long)results[i4];
                                if (counts[i4] != 0L) {
                                    lng /= counts[i4];
                                }
                                results[i4] = lng;
                                continue block28;
                            }
                            case 6: {
                                BigDecimal bd = (BigDecimal)results[i4];
                                if (counts[i4] != 0L) {
                                    bd = bd.divide(BigDecimal.valueOf(counts[i4]));
                                }
                                results[i4] = bd;
                            }
                        }
                        throw new HopException("Unable to calculate average on data type : " + subjectValueMeta.getTypeDesc());
                    }
                }
            }
            Object[] resultRow = RowDataUtil.allocateRowData((int)(this.groupRowMeta.size() + this.subjectRowMeta.size()));
            int index = 0;
            for (i = 0; i < this.groupRowMeta.size(); ++i) {
                resultRow[index++] = groupRow[i];
            }
            for (i = 0; i < this.subjectRowMeta.size(); ++i) {
                resultRow[index++] = results[i];
            }
            processContext.output((Object)new HopRow(resultRow));
            this.writtenCounter.inc();
        }
        catch (Exception e) {
            this.errorCounter.inc();
            LOG.error("Error grouping by ", (Throwable)e);
            throw new RuntimeException("Unable to split row into group and subject ", e);
        }
    }

    public String[] getAggregations() {
        return this.aggregations;
    }

    public void setAggregations(String[] aggregations) {
        this.aggregations = aggregations;
    }
}

