/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.util;

import org.apache.hop.beam.core.HopRow;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.core.xml.XmlHandlerCache;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HopBeamUtil {
    private static Object object = new Object();

    public static final String createTargetTupleId(String transformName, String targetTransformName) {
        return transformName + " - TARGET - " + targetTransformName;
    }

    public static final String createMainOutputTupleId(String transformName) {
        return transformName + " - OUTPUT";
    }

    public static final String createInfoTupleId(String transformName, String infoTransformName) {
        return infoTransformName + " - INFO - " + transformName;
    }

    public static final String createMainInputTupleId(String transformName) {
        return transformName + " - INPUT";
    }

    public static final HopRow copyHopRow(HopRow hopRow, IRowMeta rowMeta) throws HopException {
        Object[] newRow = RowDataUtil.createResizedCopy((Object[])hopRow.getRow(), (int)rowMeta.size());
        return new HopRow(newRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadTransformMetadataFromXml(String transformName, ITransformMeta iTransformMeta, String iTransformXml, IHopMetadataProvider metadataProvider) throws HopException {
        Object object = HopBeamUtil.object;
        synchronized (object) {
            Document transformDocument = XmlHandler.loadXmlString((String)iTransformXml);
            if (transformDocument == null) {
                throw new HopException("Unable to load transform XML document from : " + iTransformXml);
            }
            Node transformNode = XmlHandler.getSubNode((Node)transformDocument, (String)"transform");
            if (transformNode == null) {
                throw new HopException("Unable to find XML tag transform from : " + iTransformXml);
            }
            try {
                iTransformMeta.loadXml(transformNode, metadataProvider);
            }
            catch (Exception e) {
                throw new HopException("There was an error loading transform metadata information (loadXml) for transform '" + transformName + "'", (Throwable)e);
            }
            finally {
                XmlHandlerCache.getInstance().clear();
            }
        }
    }
}

