/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.util;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JsonRowMeta {
    public static String toJson(IRowMeta rowMeta) throws HopException {
        JSONObject jRowMeta = new JSONObject();
        JSONArray jValues = new JSONArray();
        jRowMeta.put((Object)"values", (Object)jValues);
        for (int v = 0; v < rowMeta.size(); ++v) {
            IValueMeta valueMeta = rowMeta.getValueMeta(v);
            JSONObject jValue = new JSONObject();
            valueMeta.storeMetaInJson(jValue);
            jValues.add((Object)jValue);
        }
        return jRowMeta.toJSONString();
    }

    public static IRowMeta fromJson(String rowMetaJson) throws ParseException, HopPluginException {
        JSONParser parser = new JSONParser();
        JSONObject jRowMeta = (JSONObject)parser.parse(rowMetaJson);
        RowMeta rowMeta = new RowMeta();
        JSONArray jValues = (JSONArray)jRowMeta.get((Object)"values");
        for (int v = 0; v < jValues.size(); ++v) {
            JSONObject jValue = (JSONObject)jValues.get(v);
            IValueMeta valueMeta = ValueMetaFactory.loadValueMetaFromJson((JSONObject)jValue);
            rowMeta.addValueMeta(valueMeta);
        }
        return rowMeta;
    }
}

