/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.recovery;

import java.util.function.Predicate;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.io.network.api.writer.ChannelSelector;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.runtime.streamrecord.StreamElementSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

class RecordFilter<T>
implements Predicate<StreamRecord<T>> {
    private final ChannelSelector<SerializationDelegate<StreamRecord<T>>> partitioner;
    private final SerializationDelegate<StreamRecord<T>> delegate;
    private final int subtaskIndex;

    public RecordFilter(ChannelSelector<SerializationDelegate<StreamRecord<T>>> partitioner, TypeSerializer<T> inputSerializer, int subtaskIndex) {
        this.partitioner = partitioner;
        this.delegate = new SerializationDelegate(new StreamElementSerializer<T>(inputSerializer));
        this.subtaskIndex = subtaskIndex;
    }

    public static <T> Predicate<StreamRecord<T>> all() {
        return record -> true;
    }

    @Override
    public boolean test(StreamRecord<T> streamRecord) {
        this.delegate.setInstance(streamRecord);
        return this.partitioner.selectChannel(this.delegate) == this.subtaskIndex;
    }
}

