/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.Materializations;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.nullness.qual.Nullable;

public class InMemoryMultimapSideInputView<K, V>
implements Materializations.MultimapView<K, V> {
    private static final Materializations.MultimapView EMPTY = new Materializations.MultimapView(){

        public Iterable get() {
            return Collections.emptyList();
        }

        public Iterable get(@Nullable Object k) {
            return Collections.emptyList();
        }
    };
    private final Coder<K> keyCoder;
    private final Map<Object, KV<K, List<V>>> structuralKeyToValuesMap;

    public static <K, V> Materializations.MultimapView<K, V> fromIterable(Coder<K> keyCoder, Iterable<KV<K, V>> values) {
        HashMap<Object, KV<Object, List<KV>>> data = new HashMap<Object, KV<Object, List<KV>>>();
        for (KV value : values) {
            KV keyedValues = data.computeIfAbsent(keyCoder.structuralValue(value.getKey()), o -> KV.of(value.getKey(), new ArrayList()));
            ((List)keyedValues.getValue()).add(value.getValue());
        }
        return new InMemoryMultimapSideInputView<K, V>(keyCoder, data);
    }

    public static <K, V> Materializations.MultimapView<K, V> empty() {
        return EMPTY;
    }

    private InMemoryMultimapSideInputView(Coder<K> keyCoder, Map<Object, KV<K, List<V>>> data) {
        this.keyCoder = keyCoder;
        this.structuralKeyToValuesMap = data;
    }

    @Override
    public Iterable<K> get() {
        return Iterables.unmodifiableIterable((Iterable)FluentIterable.from(this.structuralKeyToValuesMap.values()).transform(kListKV -> kListKV.getKey()));
    }

    @Override
    public Iterable<V> get(K k) {
        KV<K, List<V>> records = this.structuralKeyToValuesMap.get(this.keyCoder.structuralValue(k));
        if (records == null) {
            return Collections.emptyList();
        }
        return records.getValue();
    }
}

