/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction.renderer;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.renderer.PortablePipelineDotRenderer;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.values.PValue;

public class PipelineDotRenderer
implements Pipeline.PipelineVisitor {
    private final StringBuilder dotBuilder = new StringBuilder();
    private final Map<PValue, Integer> valueToProducerNodeId = new HashMap<PValue, Integer>();
    private int indent;
    private int nextNodeId;

    public static String toDotString(Pipeline pipeline) {
        PipelineDotRenderer visitor = new PipelineDotRenderer();
        visitor.begin();
        pipeline.traverseTopologically(visitor);
        visitor.end();
        return visitor.dotBuilder.toString();
    }

    public static String toDotString(RunnerApi.Pipeline pipeline) {
        return PortablePipelineDotRenderer.toDotString(pipeline);
    }

    private PipelineDotRenderer() {
    }

    @Override
    public void enterPipeline(Pipeline p) {
    }

    @Override
    public void leavePipeline(Pipeline pipeline) {
    }

    @Override
    public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
        this.writeLine("subgraph cluster_%d {", this.nextNodeId++);
        this.enterBlock();
        this.writeLine("label = \"%s\"", PipelineDotRenderer.escapeString(node.getFullName()));
        return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
    }

    @Override
    public void leaveCompositeTransform(TransformHierarchy.Node node) {
        this.exitBlock();
        this.writeLine("}", new Object[0]);
    }

    @Override
    public void visitPrimitiveTransform(TransformHierarchy.Node node) {
        int nodeId = this.nextNodeId++;
        this.writeLine("%d [label=\"%s\"]", nodeId, PipelineDotRenderer.escapeString(node.getTransform().getName()));
        node.getOutputs().values().forEach(x -> this.valueToProducerNodeId.put((PValue)x, nodeId));
        node.getInputs().forEach((key, value) -> {
            int producerId = this.valueToProducerNodeId.get(value);
            String style = "solid";
            if (node.getTransform().getAdditionalInputs().containsKey(key)) {
                style = "dashed";
            }
            this.writeLine("%d -> %d [style=%s label=\"%s\"]", producerId, nodeId, style, "");
        });
    }

    @Override
    public void visitValue(PValue value, TransformHierarchy.Node producer) {
    }

    private void begin() {
        this.writeLine("digraph {", new Object[0]);
        this.enterBlock();
        this.writeLine("rankdir=LR", new Object[0]);
    }

    private void end() {
        this.exitBlock();
        this.writeLine("}", new Object[0]);
    }

    private void enterBlock() {
        this.indent += 4;
    }

    private void exitBlock() {
        this.indent -= 4;
    }

    @FormatMethod
    private void writeLine(@FormatString String format, Object ... args) {
        if (this.indent != 0) {
            this.dotBuilder.append(String.format("%-" + this.indent + "s", ""));
        }
        this.dotBuilder.append(String.format(format, args));
        this.dotBuilder.append(System.lineSeparator());
    }

    private static String escapeString(String x) {
        return x.replace("\"", "\\\"");
    }
}

