/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.IdentityHashMap;
import org.apache.beam.runners.direct.AbstractModelEnforcement;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.ModelEnforcement;
import org.apache.beam.runners.direct.ModelEnforcementFactory;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.IllegalMutationException;
import org.apache.beam.sdk.util.MutationDetector;
import org.apache.beam.sdk.util.MutationDetectors;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;

class ImmutabilityEnforcementFactory
implements ModelEnforcementFactory {
    ImmutabilityEnforcementFactory() {
    }

    public static ModelEnforcementFactory create() {
        return new ImmutabilityEnforcementFactory();
    }

    @Override
    public <T> ModelEnforcement<T> forBundle(CommittedBundle<T> input, AppliedPTransform<?, ?, ?> consumer) {
        if (ImmutabilityEnforcementFactory.isReadTransform(consumer)) {
            return NoopReadEnforcement.INSTANCE;
        }
        return new ImmutabilityCheckingEnforcement(input, consumer);
    }

    static boolean isReadTransform(AppliedPTransform<?, ?, ?> consumer) {
        IsReadVisitor visitor = new IsReadVisitor((PTransform)consumer.getTransform());
        consumer.getPipeline().traverseTopologically(visitor);
        return visitor.isRead();
    }

    private static class ImmutabilityCheckingEnforcement<T>
    extends AbstractModelEnforcement<T> {
        private final AppliedPTransform<?, ?, ?> transform;
        private final IdentityHashMap<WindowedValue<T>, MutationDetector> mutationElements;
        private final Coder<T> coder;

        private ImmutabilityCheckingEnforcement(CommittedBundle<T> input, AppliedPTransform<?, ?, ?> transform) {
            this.transform = transform;
            this.coder = ((PCollection)input.getPCollection()).getCoder();
            this.mutationElements = new IdentityHashMap();
        }

        @Override
        public void beforeElement(WindowedValue<T> element) {
            try {
                this.mutationElements.put(element, MutationDetectors.forValueWithCoder(element.getValue(), this.coder));
            }
            catch (CoderException e) {
                throw UserCodeException.wrap(e);
            }
        }

        @Override
        public void afterElement(WindowedValue<T> element) {
            this.verifyUnmodified(this.mutationElements.get(element));
        }

        @Override
        public void afterFinish(CommittedBundle<T> input, TransformResult<T> result, Iterable<? extends CommittedBundle<?>> outputs) {
            for (MutationDetector detector : this.mutationElements.values()) {
                this.verifyUnmodified(detector);
            }
        }

        private void verifyUnmodified(MutationDetector detector) {
            try {
                detector.verifyUnmodified();
            }
            catch (IllegalMutationException e) {
                throw new IllegalMutationException(String.format("PTransform %s illegaly mutated value %s of class %s. Input values must not be mutated in any way.", this.transform.getFullName(), e.getSavedValue(), e.getSavedValue().getClass()), e.getSavedValue(), e.getNewValue());
            }
        }
    }

    private static class NoopReadEnforcement<T>
    extends AbstractModelEnforcement<T> {
        private static final NoopReadEnforcement INSTANCE = new NoopReadEnforcement();

        private NoopReadEnforcement() {
        }
    }

    private static class IsReadVisitor
    extends Pipeline.PipelineVisitor.Defaults {
        private final PTransform<?, ?> transform;
        private boolean isRead;
        private boolean isInsideRead;

        private IsReadVisitor(PTransform<?, ?> transform) {
            this.transform = transform;
        }

        @Override
        public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
            if (node.getTransform() instanceof Read.Bounded || node.getTransform() instanceof Read.Unbounded) {
                this.isInsideRead = true;
            }
            if (this.isInsideRead && node.getTransform() == this.transform) {
                this.isRead = true;
            }
            return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }

        @Override
        public void leaveCompositeTransform(TransformHierarchy.Node node) {
            if (node.getTransform() instanceof Read.Bounded || node.getTransform() instanceof Read.Unbounded) {
                this.isInsideRead = false;
            }
        }

        @Override
        public void visitPrimitiveTransform(TransformHierarchy.Node node) {
            if (this.isInsideRead && node.getTransform() == this.transform) {
                this.isRead = true;
            }
        }

        private boolean isRead() {
            return this.isRead;
        }
    }
}

