/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.azure.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.vfs.azure.config.AzureConfig;

public class AzureConfigSingleton {
    private static AzureConfigSingleton configSingleton;
    private AzureConfig azureConfig;

    private AzureConfigSingleton() {
        Object configObject = HopConfig.getInstance().getConfigMap().get("azure");
        if (configObject == null) {
            this.azureConfig = new AzureConfig();
        } else {
            try {
                ObjectMapper mapper = new ObjectMapper();
                this.azureConfig = (AzureConfig)mapper.readValue(new Gson().toJson(configObject), AzureConfig.class);
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Error reading Azure configuration, check property 'azure' in the Hop config json file", (Throwable)e);
                this.azureConfig = new AzureConfig();
            }
        }
        HopConfig.getInstance().getConfigMap().put("azure", this.azureConfig);
    }

    public static AzureConfigSingleton getInstance() {
        return configSingleton;
    }

    public static AzureConfig getConfig() {
        if (configSingleton == null) {
            configSingleton = new AzureConfigSingleton();
        }
        return AzureConfigSingleton.configSingleton.azureConfig;
    }

    public static void saveConfig() throws HopException {
        HopConfig.getInstance().saveOption("azure", (Object)AzureConfigSingleton.configSingleton.azureConfig);
        HopConfig.getInstance().saveToFile();
    }
}

