/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hop.workflow.actions.mysqlbulkload;

import java.util.Arrays;
import java.util.List;
import org.apache.hop.junit.rules.RestoreHopEngineEnvironment;
import org.apache.hop.workflow.action.loadsave.WorkflowActionLoadSaveTestSupport;
import org.junit.ClassRule;

public class WorkflowActionMysqlBulkLoadLoadSaveTest
    extends WorkflowActionLoadSaveTestSupport<ActionMysqlBulkLoad> {
  @ClassRule public static RestoreHopEngineEnvironment env = new RestoreHopEngineEnvironment();

  @Override
  protected Class<ActionMysqlBulkLoad> getActionClass() {
    return ActionMysqlBulkLoad.class;
  }

  @Override
  protected List<String> listAttributes() {
    return Arrays.asList(
        "schemaname",
        "tablename",
        "filename",
        "separator",
        "enclosed",
        "escaped",
        "linestarted",
        "lineterminated",
        "replacedata",
        "ignorelines",
        "listattribut",
        "localInfile",
        "prorityvalue",
        "addFileToResult",
        "database");
  }
}
