/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.mail;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.activation.URLDataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.SendFailedException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.gui.WorkflowTracker;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.ActionResult;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.w3c.dom.Node;

@Action(id="MAIL", name="i18n::ActionMail.Name", description="i18n::ActionMail.Description", image="Mail.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Mail", keywords={"i18n::ActionMail.keyword"}, documentationUrl="/workflow/actions/mail.html")
public class ActionMail
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionMail.class;
    private String server;
    private String destination;
    private String destinationCc;
    private String destinationBCc;
    private String replyAddress;
    private String replyName;
    private String subject;
    private boolean includeDate;
    private String contactPerson;
    private String contactPhone;
    private String comment;
    private boolean includingFiles;
    private int[] fileType;
    private boolean zipFiles;
    private String zipFilename;
    private boolean usingAuthentication;
    private boolean usexoauth2;
    private String authenticationUser;
    private String authenticationPassword;
    private boolean onlySendComment;
    private boolean useHTML;
    private boolean usingSecureAuthentication;
    private boolean usePriority;
    private String port;
    private String priority;
    private String importance;
    private String sensitivity;
    private String secureConnectionType;
    private String encoding;
    private String replyToAddresses;
    public String[] embeddedimages;
    public String[] contentids;

    public ActionMail(String n) {
        super(n, "");
        this.allocate(0);
    }

    public ActionMail() {
        this("");
        this.allocate(0);
    }

    public void allocate(int nrFileTypes) {
        this.fileType = new int[nrFileTypes];
    }

    public void allocateImages(int nrImages) {
        this.embeddedimages = new String[nrImages];
        this.contentids = new String[nrImages];
    }

    public Object clone() {
        ActionMail je = (ActionMail)super.clone();
        if (this.fileType != null) {
            int nrFileTypes = this.fileType.length;
            je.allocate(nrFileTypes);
            System.arraycopy(this.fileType, 0, je.fileType, 0, nrFileTypes);
        }
        if (this.embeddedimages != null) {
            int nrImages = this.embeddedimages.length;
            je.allocateImages(nrImages);
            System.arraycopy(this.embeddedimages, 0, je.embeddedimages, 0, nrImages);
            System.arraycopy(this.contentids, 0, je.contentids, 0, nrImages);
        }
        return je;
    }

    public String getXml() {
        int i;
        StringBuilder retval = new StringBuilder(600);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"server", (String)this.server));
        retval.append("      ").append(XmlHandler.addTagValue((String)"port", (String)this.port));
        retval.append("      ").append(XmlHandler.addTagValue((String)"destination", (String)this.destination));
        retval.append("      ").append(XmlHandler.addTagValue((String)"destinationCc", (String)this.destinationCc));
        retval.append("      ").append(XmlHandler.addTagValue((String)"destinationBCc", (String)this.destinationBCc));
        retval.append("      ").append(XmlHandler.addTagValue((String)"replyto", (String)this.replyAddress));
        retval.append("      ").append(XmlHandler.addTagValue((String)"replytoname", (String)this.replyName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"subject", (String)this.subject));
        retval.append("      ").append(XmlHandler.addTagValue((String)"include_date", (boolean)this.includeDate));
        retval.append("      ").append(XmlHandler.addTagValue((String)"contact_person", (String)this.contactPerson));
        retval.append("      ").append(XmlHandler.addTagValue((String)"contact_phone", (String)this.contactPhone));
        retval.append("      ").append(XmlHandler.addTagValue((String)"comment", (String)this.comment));
        retval.append("      ").append(XmlHandler.addTagValue((String)"include_files", (boolean)this.includingFiles));
        retval.append("      ").append(XmlHandler.addTagValue((String)"zip_files", (boolean)this.zipFiles));
        retval.append("      ").append(XmlHandler.addTagValue((String)"zip_name", (String)this.zipFilename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"use_auth", (boolean)this.usingAuthentication));
        retval.append("      ").append(XmlHandler.addTagValue((String)"usexoauth2", (boolean)this.usexoauth2));
        retval.append("      ").append(XmlHandler.addTagValue((String)"use_secure_auth", (boolean)this.usingSecureAuthentication));
        retval.append("      ").append(XmlHandler.addTagValue((String)"auth_user", (String)this.authenticationUser));
        retval.append("      ").append(XmlHandler.addTagValue((String)"auth_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.authenticationPassword)));
        retval.append("      ").append(XmlHandler.addTagValue((String)"only_comment", (boolean)this.onlySendComment));
        retval.append("      ").append(XmlHandler.addTagValue((String)"use_HTML", (boolean)this.useHTML));
        retval.append("      ").append(XmlHandler.addTagValue((String)"use_Priority", (boolean)this.usePriority));
        retval.append("      ").append(XmlHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("      ").append(XmlHandler.addTagValue((String)"priority", (String)this.priority));
        retval.append("      ").append(XmlHandler.addTagValue((String)"importance", (String)this.importance));
        retval.append("      ").append(XmlHandler.addTagValue((String)"sensitivity", (String)this.sensitivity));
        retval.append("      ").append(XmlHandler.addTagValue((String)"secureconnectiontype", (String)this.secureConnectionType));
        retval.append("      ").append(XmlHandler.addTagValue((String)"replyToAddresses", (String)this.replyToAddresses));
        retval.append("      <filetypes>");
        if (this.fileType != null) {
            for (i = 0; i < this.fileType.length; ++i) {
                retval.append("        ").append(XmlHandler.addTagValue((String)"filetype", (String)ResultFile.getTypeCode((int)this.fileType[i])));
            }
        }
        retval.append("      </filetypes>");
        retval.append("      <embeddedimages>").append(Const.CR);
        if (this.embeddedimages != null) {
            for (i = 0; i < this.embeddedimages.length; ++i) {
                retval.append("        <embeddedimage>").append(Const.CR);
                retval.append("          ").append(XmlHandler.addTagValue((String)"image_name", (String)this.embeddedimages[i]));
                retval.append("          ").append(XmlHandler.addTagValue((String)"content_id", (String)this.contentids[i]));
                retval.append("        </embeddedimage>").append(Const.CR);
            }
        }
        retval.append("      </embeddedimages>").append(Const.CR);
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.setServer(XmlHandler.getTagValue((Node)entrynode, (String)"server"));
            this.setPort(XmlHandler.getTagValue((Node)entrynode, (String)"port"));
            this.setDestination(XmlHandler.getTagValue((Node)entrynode, (String)"destination"));
            this.setDestinationCc(XmlHandler.getTagValue((Node)entrynode, (String)"destinationCc"));
            this.setDestinationBCc(XmlHandler.getTagValue((Node)entrynode, (String)"destinationBCc"));
            this.setReplyAddress(XmlHandler.getTagValue((Node)entrynode, (String)"replyto"));
            this.setReplyName(XmlHandler.getTagValue((Node)entrynode, (String)"replytoname"));
            this.setSubject(XmlHandler.getTagValue((Node)entrynode, (String)"subject"));
            this.setIncludeDate("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"include_date")));
            this.setContactPerson(XmlHandler.getTagValue((Node)entrynode, (String)"contact_person"));
            this.setContactPhone(XmlHandler.getTagValue((Node)entrynode, (String)"contact_phone"));
            this.setComment(XmlHandler.getTagValue((Node)entrynode, (String)"comment"));
            this.setIncludingFiles("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"include_files")));
            this.setUsingAuthentication("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"use_auth")));
            this.setUsingSecureAuthentication("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"use_secure_auth")));
            this.setUseXOAUTH2("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"usexoauth2")));
            this.setAuthenticationUser(XmlHandler.getTagValue((Node)entrynode, (String)"auth_user"));
            this.setAuthenticationPassword(Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)entrynode, (String)"auth_password")));
            this.setOnlySendComment("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"only_comment")));
            this.setUseHTML("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"use_HTML")));
            this.setUsePriority("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"use_Priority")));
            this.setEncoding(XmlHandler.getTagValue((Node)entrynode, (String)"encoding"));
            this.setPriority(XmlHandler.getTagValue((Node)entrynode, (String)"priority"));
            this.setImportance(XmlHandler.getTagValue((Node)entrynode, (String)"importance"));
            this.setSensitivity(XmlHandler.getTagValue((Node)entrynode, (String)"sensitivity"));
            this.setSecureConnectionType(XmlHandler.getTagValue((Node)entrynode, (String)"secureconnectiontype"));
            Node ftsnode = XmlHandler.getSubNode((Node)entrynode, (String)"filetypes");
            int nrTypes = XmlHandler.countNodes((Node)ftsnode, (String)"filetype");
            this.allocate(nrTypes);
            for (int i = 0; i < nrTypes; ++i) {
                Node ftnode = XmlHandler.getSubNodeByNr((Node)ftsnode, (String)"filetype", (int)i);
                this.fileType[i] = ResultFile.getType((String)XmlHandler.getNodeValue((Node)ftnode));
            }
            this.setZipFiles("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"zip_files")));
            this.setZipFilename(XmlHandler.getTagValue((Node)entrynode, (String)"zip_name"));
            this.setReplyToAddresses(XmlHandler.getTagValue((Node)entrynode, (String)"replyToAddresses"));
            Node images = XmlHandler.getSubNode((Node)entrynode, (String)"embeddedimages");
            int nrImages = XmlHandler.countNodes((Node)images, (String)"embeddedimage");
            this.allocateImages(nrImages);
            for (int i = 0; i < nrImages; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)images, (String)"embeddedimage", (int)i);
                this.embeddedimages[i] = XmlHandler.getTagValue((Node)fnode, (String)"image_name");
                this.contentids[i] = XmlHandler.getTagValue((Node)fnode, (String)"content_id");
            }
        }
        catch (HopException xe) {
            throw new HopXmlException("Unable to load action of type 'mail' from XML node", (Throwable)xe);
        }
    }

    public void setServer(String s) {
        this.server = s;
    }

    public String getServer() {
        return this.server;
    }

    public void setDestination(String dest) {
        this.destination = dest;
    }

    public void setDestinationCc(String destCc) {
        this.destinationCc = destCc;
    }

    public void setDestinationBCc(String destBCc) {
        this.destinationBCc = destBCc;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getDestinationCc() {
        return this.destinationCc;
    }

    public String getDestinationBCc() {
        return this.destinationBCc;
    }

    public void setReplyAddress(String reply) {
        this.replyAddress = reply;
    }

    public String getReplyAddress() {
        return this.replyAddress;
    }

    public void setReplyName(String replyname) {
        this.replyName = replyname;
    }

    public String getReplyName() {
        return this.replyName;
    }

    public void setSubject(String subj) {
        this.subject = subj;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setIncludeDate(boolean incl) {
        this.includeDate = incl;
    }

    public boolean getIncludeDate() {
        return this.includeDate;
    }

    public void setContactPerson(String person) {
        this.contactPerson = person;
    }

    public String getContactPerson() {
        return this.contactPerson;
    }

    public void setContactPhone(String phone) {
        this.contactPhone = phone;
    }

    public String getContactPhone() {
        return this.contactPhone;
    }

    public void setComment(String comm) {
        this.comment = comm;
    }

    public String getComment() {
        return this.comment;
    }

    public int[] getFileType() {
        return this.fileType;
    }

    public void setFileType(int[] fileType) {
        this.fileType = fileType;
    }

    public boolean isIncludingFiles() {
        return this.includingFiles;
    }

    public void setIncludingFiles(boolean includeFiles) {
        this.includingFiles = includeFiles;
    }

    public String getZipFilename() {
        return this.zipFilename;
    }

    public void setZipFilename(String zipFilename) {
        this.zipFilename = zipFilename;
    }

    public boolean isZipFiles() {
        return this.zipFiles;
    }

    public void setZipFiles(boolean zipFiles) {
        this.zipFiles = zipFiles;
    }

    public String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    public void setAuthenticationPassword(String authenticationPassword) {
        this.authenticationPassword = authenticationPassword;
    }

    public void setUseXOAUTH2(boolean usexoauth2) {
        this.usexoauth2 = usexoauth2;
    }

    public boolean isUseXOAUTH2() {
        return this.usexoauth2;
    }

    public String getAuthenticationUser() {
        return this.authenticationUser;
    }

    public void setAuthenticationUser(String authenticationUser) {
        this.authenticationUser = authenticationUser;
    }

    public boolean isUsingAuthentication() {
        return this.usingAuthentication;
    }

    public void setUsingAuthentication(boolean usingAuthentication) {
        this.usingAuthentication = usingAuthentication;
    }

    public boolean isOnlySendComment() {
        return this.onlySendComment;
    }

    public void setOnlySendComment(boolean onlySendComment) {
        this.onlySendComment = onlySendComment;
    }

    public boolean isUseHTML() {
        return this.useHTML;
    }

    public void setUseHTML(boolean useHTML) {
        this.useHTML = useHTML;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getSecureConnectionType() {
        return this.secureConnectionType;
    }

    public void setSecureConnectionType(String secureConnectionType) {
        this.secureConnectionType = secureConnectionType;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setReplyToAddresses(String replyToAddresses) {
        this.replyToAddresses = replyToAddresses;
    }

    public String getReplyToAddresses() {
        return this.replyToAddresses;
    }

    public void setUsePriority(boolean usePriority) {
        this.usePriority = usePriority;
    }

    public boolean isUsePriority() {
        return this.usePriority;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setImportance(String importance) {
        this.importance = importance;
    }

    public String getImportance() {
        return this.importance;
    }

    public String getSensitivity() {
        return this.sensitivity;
    }

    public void setSensitivity(String sensitivity) {
        this.sensitivity = sensitivity;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result result, int nr) {
        File masterZipfile = null;
        Properties props = new Properties();
        if (Utils.isEmpty((CharSequence)this.server)) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionMail.Error.HostNotSpecified", (String[])new String[0]));
            result.setNrErrors(1L);
            result.setResult(false);
            return result;
        }
        String protocol = "smtp";
        if (this.usingSecureAuthentication) {
            if (this.usexoauth2) {
                props.put("mail.smtp.auth.mechanisms", "XOAUTH2");
            }
            if (this.secureConnectionType.equals("TLS")) {
                props.put("mail.smtp.starttls.enable", "true");
            } else if (this.secureConnectionType.equals("TLS 1.2")) {
                props.put("mail.smtp.starttls.enable", "true");
                props.put("mail.smtp.ssl.protocols", "TLSv1.2");
            } else {
                protocol = "smtps";
                props.put("mail.smtps.quitwait", "false");
            }
        }
        props.put("mail." + protocol + ".host", this.resolve(this.server));
        if (!Utils.isEmpty((CharSequence)this.port)) {
            props.put("mail." + protocol + ".port", this.resolve(this.port));
        }
        if (this.log.isDebug()) {
            props.put("mail.debug", "true");
        }
        if (this.usingAuthentication) {
            props.put("mail." + protocol + ".auth", "true");
        }
        Session session = Session.getInstance((Properties)props);
        session.setDebug(this.log.isDebug());
        try {
            List resultFiles;
            WorkflowTracker workflowTracker;
            String realSubject;
            String realBCc;
            int i;
            InternetAddress[] address;
            Object senderAddress;
            MimeMessage msg = new MimeMessage(session);
            if (this.usePriority) {
                String priorityInt = "1";
                if (this.priority.equals("low")) {
                    priorityInt = "3";
                }
                if (this.priority.equals("normal")) {
                    priorityInt = "2";
                }
                msg.setHeader("X-Priority", priorityInt);
                msg.setHeader("Importance", this.importance);
                msg.setHeader("Sensitivity", this.sensitivity);
            }
            if (!Utils.isEmpty((CharSequence)(senderAddress = this.resolve(this.replyAddress)))) {
                String senderName = this.resolve(this.replyName);
                if (!Utils.isEmpty((CharSequence)senderName)) {
                    senderAddress = senderName + "<" + (String)senderAddress + ">";
                }
            } else {
                throw new MessagingException(BaseMessages.getString(PKG, (String)"ActionMail.Error.ReplyEmailNotFilled", (String[])new String[0]));
            }
            msg.setFrom((Address)new InternetAddress((String)senderAddress));
            String replyToAddress = this.resolve(this.replyToAddresses);
            if (!Utils.isEmpty((CharSequence)replyToAddress)) {
                String[] replyAddressList = this.resolve(replyToAddress).split(" ");
                address = new InternetAddress[replyAddressList.length];
                for (i = 0; i < replyAddressList.length; ++i) {
                    address[i] = new InternetAddress(replyAddressList[i]);
                }
                msg.setReplyTo((Address[])address);
            }
            String[] destinations = this.resolve(this.destination).split(" ");
            address = new InternetAddress[destinations.length];
            for (i = 0; i < destinations.length; ++i) {
                address[i] = new InternetAddress(destinations[i]);
            }
            msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            String realCC = this.resolve(this.getDestinationCc());
            if (!Utils.isEmpty((CharSequence)realCC)) {
                String[] destinationsCc = realCC.split(" ");
                InternetAddress[] addressCc = new InternetAddress[destinationsCc.length];
                for (int i2 = 0; i2 < destinationsCc.length; ++i2) {
                    addressCc[i2] = new InternetAddress(destinationsCc[i2]);
                }
                msg.setRecipients(Message.RecipientType.CC, (Address[])addressCc);
            }
            if (!Utils.isEmpty((CharSequence)(realBCc = this.resolve(this.getDestinationBCc())))) {
                String[] destinationsBCc = realBCc.split(" ");
                InternetAddress[] addressBCc = new InternetAddress[destinationsBCc.length];
                for (int i3 = 0; i3 < destinationsBCc.length; ++i3) {
                    addressBCc[i3] = new InternetAddress(destinationsBCc[i3]);
                }
                msg.setRecipients(Message.RecipientType.BCC, (Address[])addressBCc);
            }
            if (!Utils.isEmpty((CharSequence)(realSubject = this.resolve(this.subject)))) {
                msg.setSubject(realSubject);
            }
            msg.setSentDate(new Date());
            StringBuilder messageText = new StringBuilder();
            String endRow = this.isUseHTML() ? "<br>" : Const.CR;
            String realComment = this.resolve(this.comment);
            if (!Utils.isEmpty((CharSequence)realComment)) {
                messageText.append(realComment).append(Const.CR).append(Const.CR);
            }
            if (!this.onlySendComment) {
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.Workflow", (String[])new String[0])).append(endRow);
                messageText.append("-----").append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.JobName", (String[])new String[0]) + "    : ").append(this.parentWorkflow.getWorkflowMeta().getName()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.Action", (String[])new String[0]) + "   : ").append(this.getName()).append(endRow);
                messageText.append(Const.CR);
            }
            if (this.includeDate) {
                messageText.append(endRow).append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.MsgDate", (String[])new String[0]) + ": ").append(XmlHandler.date2string((Date)new Date())).append(endRow).append(endRow);
            }
            if (!this.onlySendComment && result != null) {
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.PreviousResult", (String[])new String[0]) + ":").append(endRow);
                messageText.append("-----------------").append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.ActionNr", (String[])new String[0]) + "         : ").append(result.getEntryNr()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.Errors", (String[])new String[0]) + "               : ").append(result.getNrErrors()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.LinesRead", (String[])new String[0]) + "           : ").append(result.getNrLinesRead()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.LinesWritten", (String[])new String[0]) + "        : ").append(result.getNrLinesWritten()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.LinesInput", (String[])new String[0]) + "          : ").append(result.getNrLinesInput()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.LinesOutput", (String[])new String[0]) + "         : ").append(result.getNrLinesOutput()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.LinesUpdated", (String[])new String[0]) + "        : ").append(result.getNrLinesUpdated()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.LinesRejected", (String[])new String[0]) + "       : ").append(result.getNrLinesRejected()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.Status", (String[])new String[0]) + "  : ").append(result.getExitStatus()).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.Result", (String[])new String[0]) + "               : ").append(result.getResult()).append(endRow);
                messageText.append(endRow);
            }
            if (!(this.onlySendComment || Utils.isEmpty((CharSequence)this.resolve(this.contactPerson)) && Utils.isEmpty((CharSequence)this.resolve(this.contactPhone)))) {
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.ContactInfo", (String[])new String[0]) + " :").append(endRow);
                messageText.append("---------------------").append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.PersonToContact", (String[])new String[0]) + " : ").append(this.resolve(this.contactPerson)).append(endRow);
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.Tel", (String[])new String[0]) + "  : ").append(this.resolve(this.contactPhone)).append(endRow);
                messageText.append(endRow);
            }
            if (!this.onlySendComment && (workflowTracker = this.parentWorkflow.getWorkflowTracker()) != null) {
                messageText.append(BaseMessages.getString(PKG, (String)"ActionMail.Log.Comment.PathToJobentry", (String[])new String[0]) + ":").append(endRow);
                messageText.append("------------------------").append(endRow);
                this.addBacktracking(workflowTracker, messageText);
                if (this.isUseHTML()) {
                    messageText.replace(0, messageText.length(), messageText.toString().replace(Const.CR, endRow));
                }
            }
            MimeMultipart parts = new MimeMultipart();
            MimeBodyPart part1 = new MimeBodyPart();
            int nrattachedFiles = 0;
            if (this.useHTML) {
                if (!Utils.isEmpty((CharSequence)this.getEncoding())) {
                    part1.setContent((Object)messageText.toString(), "text/html; charset=" + this.getEncoding());
                } else {
                    part1.setContent((Object)messageText.toString(), "text/html; charset=ISO-8859-1");
                }
            } else {
                part1.setText(messageText.toString());
            }
            parts.addBodyPart((BodyPart)part1);
            if (this.includingFiles && result != null && (resultFiles = result.getResultFilesList()) != null && !resultFiles.isEmpty()) {
                boolean found;
                if (!this.zipFiles) {
                    for (Object resultFile : resultFiles) {
                        FileObject file = resultFile.getFile();
                        if (file == null || !file.exists()) continue;
                        found = false;
                        for (int i4 = 0; i4 < this.fileType.length; ++i4) {
                            if (this.fileType[i4] != resultFile.getType()) continue;
                            found = true;
                        }
                        if (!found) continue;
                        MimeBodyPart files = new MimeBodyPart();
                        URLDataSource fds = new URLDataSource(file.getURL());
                        files.setDataHandler(new DataHandler((DataSource)fds));
                        files.setFileName(file.getName().getBaseName());
                        files.addHeader("Content-Transfer-Encoding", "base64");
                        parts.addBodyPart((BodyPart)files);
                        ++nrattachedFiles;
                        this.logBasic("Added file '" + fds.getName() + "' to the mail message.");
                    }
                } else {
                    masterZipfile = new File(System.getProperty("java.io.tmpdir") + Const.FILE_SEPARATOR + this.resolve(this.zipFilename));
                    ZipOutputStream zipOutputStream = null;
                    try {
                        zipOutputStream = new ZipOutputStream(new FileOutputStream(masterZipfile));
                        for (ResultFile resultFile : resultFiles) {
                            found = false;
                            for (int i5 = 0; i5 < this.fileType.length; ++i5) {
                                if (this.fileType[i5] != resultFile.getType()) continue;
                                found = true;
                            }
                            if (!found) continue;
                            FileObject file = resultFile.getFile();
                            ZipEntry zipEntry = new ZipEntry(file.getName().getBaseName());
                            zipOutputStream.putNextEntry(zipEntry);
                            try (BufferedInputStream inputStream = new BufferedInputStream(HopVfs.getInputStream((FileObject)file));){
                                int c;
                                while ((c = inputStream.read()) >= 0) {
                                    zipOutputStream.write(c);
                                }
                            }
                            zipOutputStream.closeEntry();
                            ++nrattachedFiles;
                            this.logBasic("Added file '" + file.getName().getURI() + "' to the mail message in a zip archive.");
                        }
                    }
                    catch (Exception e) {
                        this.logError("Error zipping attachement files into file [" + masterZipfile.getPath() + "] : " + e.toString());
                        this.logError(Const.getStackTracker((Throwable)e));
                        result.setNrErrors(1L);
                    }
                    finally {
                        if (zipOutputStream != null) {
                            try {
                                zipOutputStream.finish();
                                zipOutputStream.close();
                            }
                            catch (IOException e) {
                                this.logError("Unable to close attachement zip file archive : " + e.toString());
                                this.logError(Const.getStackTracker((Throwable)e));
                                result.setNrErrors(1L);
                            }
                        }
                    }
                    if (result.getNrErrors() == 0L) {
                        MimeBodyPart files = new MimeBodyPart();
                        FileDataSource fds = new FileDataSource(masterZipfile);
                        files.setDataHandler(new DataHandler((DataSource)fds));
                        files.setFileName(fds.getName());
                        parts.addBodyPart((BodyPart)files);
                    }
                }
            }
            int nrEmbeddedImages = 0;
            if (this.embeddedimages != null && this.embeddedimages.length > 0) {
                FileObject imageFile = null;
                for (int i6 = 0; i6 < this.embeddedimages.length; ++i6) {
                    String realImageFile = this.resolve(this.embeddedimages[i6]);
                    String realcontenID = this.resolve(this.contentids[i6]);
                    if (messageText.indexOf("cid:" + realcontenID) < 0) {
                        if (!this.log.isDebug()) continue;
                        this.log.logDebug("Image [" + realImageFile + "] is not used in message body!");
                        continue;
                    }
                    try {
                        boolean found = false;
                        imageFile = HopVfs.getFileObject((String)realImageFile);
                        if (imageFile.exists() && imageFile.getType() == FileType.FILE) {
                            found = true;
                        } else {
                            this.log.logError("We can not find [" + realImageFile + "] or it is not a file");
                        }
                        if (!found) continue;
                        MimeBodyPart messageBodyPart = new MimeBodyPart();
                        URLDataSource fds = new URLDataSource(imageFile.getURL());
                        messageBodyPart.setDataHandler(new DataHandler((DataSource)fds));
                        messageBodyPart.setHeader("Content-ID", "<" + realcontenID + ">");
                        parts.addBodyPart((BodyPart)messageBodyPart);
                        ++nrEmbeddedImages;
                        this.log.logBasic("Image '" + fds.getName() + "' was embedded in message.");
                        continue;
                    }
                    catch (Exception e) {
                        this.log.logError("Error embedding image [" + realImageFile + "] in message : " + e.toString());
                        this.log.logError(Const.getStackTracker((Throwable)e));
                        result.setNrErrors(1L);
                        continue;
                    }
                    finally {
                        if (imageFile != null) {
                            try {
                                imageFile.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
            if (nrEmbeddedImages > 0 && nrattachedFiles == 0) {
                parts.setSubType("related");
            }
            msg.setContent((Multipart)parts);
            try (Transport transport = null;){
                transport = session.getTransport(protocol);
                String authPass = this.getPassword(this.authenticationPassword);
                if (this.usingAuthentication) {
                    if (!Utils.isEmpty((CharSequence)this.port)) {
                        transport.connect(this.resolve(Const.NVL((String)this.server, (String)"")), Integer.parseInt(this.resolve(Const.NVL((String)this.port, (String)""))), this.resolve(Const.NVL((String)this.authenticationUser, (String)"")), authPass);
                    } else {
                        transport.connect(this.resolve(Const.NVL((String)this.server, (String)"")), this.resolve(Const.NVL((String)this.authenticationUser, (String)"")), authPass);
                    }
                } else {
                    transport.connect();
                }
                transport.sendMessage((Message)msg, msg.getAllRecipients());
            }
        }
        catch (IOException e) {
            this.logError("Problem while sending message: " + e.toString());
            result.setNrErrors(1L);
        }
        catch (MessagingException mex) {
            this.logError("Problem while sending message: " + mex.toString());
            result.setNrErrors(1L);
            Throwable ex = mex;
            do {
                Address[] validSent;
                Address[] validUnsent;
                if (!(ex instanceof SendFailedException)) continue;
                SendFailedException sfex = (SendFailedException)ex;
                Address[] invalid = sfex.getInvalidAddresses();
                if (invalid != null) {
                    this.logError("    ** Invalid Addresses");
                    for (int i = 0; i < invalid.length; ++i) {
                        this.logError("         " + invalid[i]);
                        result.setNrErrors(1L);
                    }
                }
                if ((validUnsent = sfex.getValidUnsentAddresses()) != null) {
                    this.logError("    ** ValidUnsent Addresses");
                    for (int i = 0; i < validUnsent.length; ++i) {
                        this.logError("         " + validUnsent[i]);
                        result.setNrErrors(1L);
                    }
                }
                if ((validSent = sfex.getValidSentAddresses()) == null) continue;
                for (int i = 0; i < validSent.length; ++i) {
                    this.logError("         " + validSent[i]);
                    result.setNrErrors(1L);
                }
            } while ((ex = ex instanceof MessagingException ? ex.getNextException() : null) != null);
        }
        finally {
            if (masterZipfile != null && masterZipfile.exists()) {
                masterZipfile.delete();
            }
        }
        if (result.getNrErrors() > 0L) {
            result.setResult(false);
        } else {
            result.setResult(true);
        }
        return result;
    }

    private void addBacktracking(WorkflowTracker workflowTracker, StringBuilder messageText) {
        this.addBacktracking(workflowTracker, messageText, 0);
    }

    private void addBacktracking(WorkflowTracker workflowTracker, StringBuilder messageText, int level) {
        int nr = workflowTracker.nrWorkflowTrackers();
        messageText.append(Const.rightPad((String)" ", (int)(level * 2)));
        messageText.append(Const.NVL((String)workflowTracker.getWorkflowName(), (String)"-"));
        ActionResult jer = workflowTracker.getActionResult();
        if (jer != null) {
            messageText.append(" : ");
            if (jer.getActionName() != null) {
                messageText.append(" : ");
                messageText.append(jer.getActionName());
            }
            if (jer.getResult() != null) {
                messageText.append(" : ");
                messageText.append("[" + jer.getResult().toString() + "]");
            }
            if (jer.getReason() != null) {
                messageText.append(" : ");
                messageText.append(jer.getReason());
            }
            if (jer.getComment() != null) {
                messageText.append(" : ");
                messageText.append(jer.getComment());
            }
            if (jer.getLogDate() != null) {
                messageText.append(" (");
                messageText.append(XmlHandler.date2string((Date)jer.getLogDate()));
                messageText.append(')');
            }
        }
        messageText.append(Const.CR);
        for (int i = 0; i < nr; ++i) {
            WorkflowTracker jt = workflowTracker.getWorkflowTracker(i);
            this.addBacktracking(jt, messageText, level + 1);
        }
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return true;
    }

    public boolean isUsingSecureAuthentication() {
        return this.usingSecureAuthentication;
    }

    public void setUsingSecureAuthentication(boolean usingSecureAuthentication) {
        this.usingSecureAuthentication = usingSecureAuthentication;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        String realServername = this.resolve(this.server);
        ResourceReference reference = new ResourceReference((IResourceHolder)this);
        reference.getEntries().add(new ResourceEntry(realServername, ResourceEntry.ResourceType.SERVER));
        references.add(reference);
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "server", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "replyAddress", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.emailValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "destination", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        if (this.usingAuthentication) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "authenticationUser", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "authenticationPassword", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator()}));
        }
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "port", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.integerValidator()}));
    }

    public String getPassword(String authPassword) {
        return Encr.decryptPasswordOptionallyEncrypted((String)this.resolve(Const.NVL((String)authPassword, (String)"")));
    }
}

