/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.cloud.bigquery.storage.v1.StorageError;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.RetryManager;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StorageApiFinalizeWritesDoFn
extends DoFn<KV<String, String>, Void> {
    private static final Logger LOG = LoggerFactory.getLogger(StorageApiFinalizeWritesDoFn.class);
    private final Counter finalizeOperationsSent = Metrics.counter(StorageApiFinalizeWritesDoFn.class, (String)"finalizeOperationsSent");
    private final Counter finalizeOperationsSucceeded = Metrics.counter(StorageApiFinalizeWritesDoFn.class, (String)"finalizeOperationsSucceeded");
    private final Counter finalizeOperationsFailed = Metrics.counter(StorageApiFinalizeWritesDoFn.class, (String)"finalizeOperationsFailed");
    private final Counter batchCommitOperationsSent = Metrics.counter(StorageApiFinalizeWritesDoFn.class, (String)"batchCommitOperationsSent");
    private final Counter batchCommitOperationsSucceeded = Metrics.counter(StorageApiFinalizeWritesDoFn.class, (String)"batchCommitOperationsSucceeded");
    private final Counter batchCommitOperationsFailed = Metrics.counter(StorageApiFinalizeWritesDoFn.class, (String)"batchCommitOperationsFailed");
    private Map<String, Collection<String>> commitStreams;
    private final BigQueryServices bqServices;
    private transient @Nullable BigQueryServices.DatasetService datasetService;

    public StorageApiFinalizeWritesDoFn(BigQueryServices bqServices) {
        this.bqServices = bqServices;
        this.commitStreams = Maps.newHashMap();
        this.datasetService = null;
    }

    private BigQueryServices.DatasetService getDatasetService(PipelineOptions pipelineOptions) throws IOException {
        if (this.datasetService == null) {
            this.datasetService = this.bqServices.getDatasetService((BigQueryOptions)pipelineOptions.as(BigQueryOptions.class));
        }
        return this.datasetService;
    }

    @DoFn.Teardown
    public void onTeardown() {
        try {
            if (this.datasetService != null) {
                this.datasetService.close();
                this.datasetService = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DoFn.StartBundle
    public void startBundle() throws IOException {
        this.commitStreams = Maps.newHashMap();
    }

    @DoFn.ProcessElement
    public void process(PipelineOptions pipelineOptions, @DoFn.Element KV<String, String> element) throws Exception {
        String tableId = (String)element.getKey();
        String streamId = (String)element.getValue();
        BigQueryServices.DatasetService datasetService = this.getDatasetService(pipelineOptions);
        RetryManager retryManager = new RetryManager(Duration.standardSeconds((long)1L), Duration.standardMinutes((long)1L), 3);
        retryManager.addOperation(c -> {
            this.finalizeOperationsSent.inc();
            return datasetService.finalizeWriteStream(streamId);
        }, contexts -> {
            RetryManager.Operation.Context firstContext = (RetryManager.Operation.Context)Preconditions.checkArgumentNotNull((Object)((RetryManager.Operation.Context)Iterables.getFirst((Iterable)contexts, null)));
            LOG.error("Finalize of stream " + streamId + " failed with " + firstContext.getError());
            this.finalizeOperationsFailed.inc();
            return RetryManager.RetryType.RETRY_ALL_OPERATIONS;
        }, c -> {
            LOG.info("Finalize of stream " + streamId + " finished with " + c.getResult());
            this.finalizeOperationsSucceeded.inc();
            this.commitStreams.computeIfAbsent(tableId, d -> Lists.newArrayList()).add(streamId);
        }, new RetryManager.Operation.Context());
        retryManager.run(true);
    }

    @DoFn.FinishBundle
    public void finishBundle(PipelineOptions pipelineOptions) throws Exception {
        BigQueryServices.DatasetService datasetService = this.getDatasetService(pipelineOptions);
        for (Map.Entry<String, Collection<String>> entry : this.commitStreams.entrySet()) {
            String tableId = entry.getKey();
            Collection<String> streamNames = entry.getValue();
            HashSet alreadyCommittedStreams = Sets.newHashSet();
            RetryManager retryManager = new RetryManager(Duration.standardSeconds((long)1L), Duration.standardMinutes((long)1L), 3);
            retryManager.addOperation(c -> {
                Iterable streamsToCommit = Iterables.filter((Iterable)streamNames, s -> !alreadyCommittedStreams.contains(s));
                this.batchCommitOperationsSent.inc();
                return datasetService.commitWriteStreams(tableId, streamsToCommit);
            }, contexts -> {
                RetryManager.Operation.Context firstContext = (RetryManager.Operation.Context)Preconditions.checkArgumentNotNull((Object)((RetryManager.Operation.Context)Iterables.getFirst((Iterable)contexts, null)));
                LOG.error("BatchCommit failed. tableId " + tableId + " streamNames " + streamNames + " error: " + firstContext.getError());
                this.batchCommitOperationsFailed.inc();
                return RetryManager.RetryType.RETRY_ALL_OPERATIONS;
            }, c -> {
                LOG.info("BatchCommit succeeded for tableId " + tableId + " response " + c.getResult());
                this.batchCommitOperationsSucceeded.inc();
            }, response -> {
                if (!response.hasCommitTime()) {
                    for (StorageError storageError : response.getStreamErrorsList()) {
                        if (storageError.getCode() != StorageError.StorageErrorCode.STREAM_ALREADY_COMMITTED) continue;
                        alreadyCommittedStreams.add(storageError.getEntity());
                    }
                    Iterable streamsToCommit = Iterables.filter((Iterable)streamNames, s -> !alreadyCommittedStreams.contains(s));
                    return Iterables.isEmpty((Iterable)streamsToCommit);
                }
                return true;
            }, new RetryManager.Operation.Context());
            retryManager.run(true);
        }
    }
}

