/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.statistics.impl;

import java.time.Duration;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;

final class PairedDurationTrackerFactory
implements DurationTrackerFactory {
    private final DurationTrackerFactory local;
    private final DurationTrackerFactory global;

    PairedDurationTrackerFactory(DurationTrackerFactory local, DurationTrackerFactory global) {
        this.local = local;
        this.global = global;
    }

    @Override
    public DurationTracker trackDuration(String key, long count) {
        return new PairedDurationTracker(this.global.trackDuration(key, count), this.local.trackDuration(key, count));
    }

    private static final class PairedDurationTracker
    implements DurationTracker {
        private final DurationTracker firstDuration;
        private final DurationTracker secondDuration;

        private PairedDurationTracker(DurationTracker firstDuration, DurationTracker secondDuration) {
            this.firstDuration = firstDuration;
            this.secondDuration = secondDuration;
        }

        @Override
        public void failed() {
            this.firstDuration.failed();
            this.secondDuration.failed();
        }

        @Override
        public void close() {
            this.firstDuration.close();
            this.secondDuration.close();
        }

        @Override
        public Duration asDuration() {
            return this.firstDuration.asDuration();
        }
    }
}

