/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.propertyinput;

import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.propertyinput.PropertyInput;
import org.apache.hop.pipeline.transforms.propertyinput.PropertyInputData;
import org.apache.hop.pipeline.transforms.propertyinput.PropertyInputField;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.w3c.dom.Node;

@Transform(id="PropertyInput", image="propertyinput.svg", name="i18n::PropertyInput.Name", description="i18n::PropertyInput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::PropertyInputMeta.keyword"}, documentationUrl="/pipeline/transforms/propertyinput.html")
public class PropertyInputMeta
extends BaseTransformMeta<PropertyInput, PropertyInputData> {
    private static final Class<?> PKG = PropertyInputMeta.class;
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final String YES = "Y";
    public static final String[] type_trimCode = new String[]{"none", "left", "right", "both"};
    public static final String[] columnCode = new String[]{"key", "value"};
    public static final String[] fileTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"PropertyInputMeta.FileType.Property", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PropertyInputMeta.FileType.Ini", (String[])new String[0])};
    public static final String[] fileTypeCode = new String[]{"property", "ini"};
    public static final int FILE_TYPE_PROPERTY = 0;
    public static final int FILE_TYPE_INI = 1;
    private String encoding;
    private String fileType;
    private String[] fileName;
    private String[] fileMask;
    private String[] excludeFileMask;
    private boolean includeFilename;
    private String[] fileRequired;
    private String[] includeSubFolders;
    private boolean resetRowNumber;
    private boolean resolvevaluevariable;
    private String filenameField;
    private boolean includeRowNumber;
    private String rowNumberField;
    private long rowLimit;
    private PropertyInputField[] inputFields;
    private boolean filefield;
    private boolean isaddresult;
    private String dynamicFilenameField;
    private boolean includeIniSection;
    private String iniSectionField;
    private String section;
    private String shortFileFieldName;
    private String pathFieldName;
    private String hiddenFieldName;
    private String lastModificationTimeFieldName;
    private String uriNameFieldName;
    private String rootUriNameFieldName;
    private String extensionFieldName;
    private String sizeFieldName;

    public String getExtensionField() {
        return this.extensionFieldName;
    }

    public void setExtensionField(String field) {
        this.extensionFieldName = field;
    }

    public String getSizeField() {
        return this.sizeFieldName;
    }

    public void setSizeField(String field) {
        this.sizeFieldName = field;
    }

    public String getShortFileNameField() {
        return this.shortFileFieldName;
    }

    public void setShortFileNameField(String field) {
        this.shortFileFieldName = field;
    }

    public String getPathField() {
        return this.pathFieldName;
    }

    public void setPathField(String field) {
        this.pathFieldName = field;
    }

    public String isHiddenField() {
        return this.hiddenFieldName;
    }

    public void setIsHiddenField(String field) {
        this.hiddenFieldName = field;
    }

    public String getLastModificationDateField() {
        return this.lastModificationTimeFieldName;
    }

    public void setLastModificationDateField(String field) {
        this.lastModificationTimeFieldName = field;
    }

    public String getUriField() {
        return this.uriNameFieldName;
    }

    public void setUriField(String field) {
        this.uriNameFieldName = field;
    }

    public String getRootUriField() {
        return this.rootUriNameFieldName;
    }

    public void setRootUriField(String field) {
        this.rootUriNameFieldName = field;
    }

    public PropertyInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(PropertyInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public String[] getExcludeFileMask() {
        return this.excludeFileMask;
    }

    public void setExcludeFileMask(String[] excludeFileMask) {
        this.excludeFileMask = excludeFileMask;
    }

    public String[] getFileRequired() {
        return this.fileRequired;
    }

    public void setFileRequired(String[] fileRequiredin) {
        this.fileRequired = new String[fileRequiredin.length];
        for (int i = 0; i < fileRequiredin.length; ++i) {
            this.fileRequired[i] = this.getRequiredFilesCode(fileRequiredin[i]);
        }
    }

    public String[] getIncludeSubFolders() {
        return this.includeSubFolders;
    }

    public void setIncludeSubFolders(String[] includeSubFoldersin) {
        for (int i = 0; i < includeSubFoldersin.length; ++i) {
            this.includeSubFolders[i] = this.getRequiredFilesCode(includeSubFoldersin[i]);
        }
    }

    public String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    public String getRequiredFilesDesc(String tt) {
        if (tt == null) {
            return RequiredFilesDesc[0];
        }
        if (tt.equals(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public String getDynamicFilenameField() {
        return this.dynamicFilenameField;
    }

    public void setDynamicFilenameField(String dynamicFilenameField) {
        this.dynamicFilenameField = dynamicFilenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public boolean includeFilename() {
        return this.includeFilename;
    }

    public void setIncludeFilename(boolean includeFilename) {
        this.includeFilename = includeFilename;
    }

    public static String getFileTypeCode(int i) {
        if (i < 0 || i >= fileTypeCode.length) {
            return fileTypeCode[0];
        }
        return fileTypeCode[i];
    }

    public static int getFileTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < fileTypeDesc.length; ++i) {
            if (!fileTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return PropertyInputMeta.getFileTypeByCode(tt);
    }

    public static int getFileTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < fileTypeCode.length; ++i) {
            if (!fileTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static String getFileTypeDesc(int i) {
        if (i < 0 || i >= fileTypeDesc.length) {
            return fileTypeDesc[0];
        }
        return fileTypeDesc[i];
    }

    public void setFileType(String filetype) {
        this.fileType = filetype;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setIncludeIniSection(boolean includeIniSection) {
        this.includeIniSection = includeIniSection;
    }

    public boolean includeIniSection() {
        return this.includeIniSection;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setINISectionField(String iniSectionField) {
        this.iniSectionField = iniSectionField;
    }

    public String getINISectionField() {
        return this.iniSectionField;
    }

    public void setSection(String section) {
        this.section = section;
    }

    public String getSection() {
        return this.section;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public boolean isFileField() {
        return this.filefield;
    }

    public void setFileField(boolean filefield) {
        this.filefield = filefield;
    }

    public boolean resetRowNumber() {
        return this.resetRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public void setAddResultFile(boolean isaddresult) {
        this.isaddresult = isaddresult;
    }

    public boolean isAddResultFile() {
        return this.isaddresult;
    }

    public void setResetRowNumber(boolean resetRowNumber) {
        this.resetRowNumber = resetRowNumber;
    }

    public void setResolveValueVariable(boolean resolvevaluevariable) {
        this.resolvevaluevariable = resolvevaluevariable;
    }

    public boolean isResolveValueVariable() {
        return this.resolvevaluevariable;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public Object clone() {
        PropertyInputMeta retval = (PropertyInputMeta)((Object)super.clone());
        int nrFiles = this.fileName.length;
        int nrFields = this.inputFields.length;
        retval.allocate(nrFiles, nrFields);
        System.arraycopy(this.fileName, 0, retval.fileName, 0, nrFiles);
        System.arraycopy(this.fileMask, 0, retval.fileMask, 0, nrFiles);
        System.arraycopy(this.excludeFileMask, 0, retval.excludeFileMask, 0, nrFiles);
        System.arraycopy(this.fileRequired, 0, retval.fileRequired, 0, nrFiles);
        System.arraycopy(this.includeSubFolders, 0, retval.includeSubFolders, 0, nrFiles);
        for (int i = 0; i < nrFields; ++i) {
            if (this.inputFields[i] == null) continue;
            retval.inputFields[i] = (PropertyInputField)this.inputFields[i].clone();
        }
        return retval;
    }

    public String getXml() {
        int i;
        StringBuilder retval = new StringBuilder(500);
        retval.append("    ").append(XmlHandler.addTagValue((String)"file_type", (String)this.fileType));
        retval.append("    ").append(XmlHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    ").append(XmlHandler.addTagValue((String)"include", (boolean)this.includeFilename));
        retval.append("    ").append(XmlHandler.addTagValue((String)"include_field", (String)this.filenameField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"filename_Field", (String)this.dynamicFilenameField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    ").append(XmlHandler.addTagValue((String)"isaddresult", (boolean)this.isaddresult));
        retval.append("    ").append(XmlHandler.addTagValue((String)"filefield", (boolean)this.filefield));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"resetrownumber", (boolean)this.resetRowNumber));
        retval.append("    ").append(XmlHandler.addTagValue((String)"resolvevaluevariable", (boolean)this.resolvevaluevariable));
        retval.append("    ").append(XmlHandler.addTagValue((String)"ini_section", (boolean)this.includeIniSection));
        retval.append("    ").append(XmlHandler.addTagValue((String)"ini_section_field", (String)this.iniSectionField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"section", (String)this.section));
        retval.append("    <file>").append(Const.CR);
        for (i = 0; i < this.fileName.length; ++i) {
            retval.append("      ").append(XmlHandler.addTagValue((String)"name", (String)this.fileName[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"exclude_filemask", (String)this.excludeFileMask[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"filemask", (String)this.fileMask[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"file_required", (String)this.fileRequired[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"include_subfolders", (String)this.includeSubFolders[i]));
        }
        retval.append("    </file>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (i = 0; i < this.inputFields.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"name", (String)this.inputFields[i].getName()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"column", (String)this.inputFields[i].getColumnCode()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"type", (String)this.inputFields[i].getTypeDesc()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"format", (String)this.inputFields[i].getFormat()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"length", (int)this.inputFields[i].getLength()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"precision", (int)this.inputFields[i].getPrecision()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"currency", (String)this.inputFields[i].getCurrencySymbol()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"decimal", (String)this.inputFields[i].getDecimalSymbol()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"group", (String)this.inputFields[i].getGroupSymbol()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"trim_type", (String)this.inputFields[i].getTrimTypeCode()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"repeat", (boolean)this.inputFields[i].isRepeated()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    ").append(XmlHandler.addTagValue((String)"limit", (long)this.rowLimit));
        retval.append("    ").append(XmlHandler.addTagValue((String)"shortFileFieldName", (String)this.shortFileFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"pathFieldName", (String)this.pathFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"hiddenFieldName", (String)this.hiddenFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"lastModificationTimeFieldName", (String)this.lastModificationTimeFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"uriNameFieldName", (String)this.uriNameFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rootUriNameFieldName", (String)this.rootUriNameFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"extensionFieldName", (String)this.extensionFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"sizeFieldName", (String)this.sizeFieldName));
        return retval.toString();
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            int i;
            this.fileType = XmlHandler.getTagValue((Node)transformNode, (String)"file_type");
            this.encoding = XmlHandler.getTagValue((Node)transformNode, (String)"encoding");
            this.includeFilename = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"include"));
            this.filenameField = XmlHandler.getTagValue((Node)transformNode, (String)"include_field");
            this.includeRowNumber = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"rownum"));
            String addresult = XmlHandler.getTagValue((Node)transformNode, (String)"isaddresult");
            this.isaddresult = Utils.isEmpty((CharSequence)addresult) ? true : YES.equalsIgnoreCase(addresult);
            this.section = XmlHandler.getTagValue((Node)transformNode, (String)"section");
            this.iniSectionField = XmlHandler.getTagValue((Node)transformNode, (String)"ini_section_field");
            this.includeIniSection = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"ini_section"));
            this.filefield = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"filefield"));
            this.rowNumberField = XmlHandler.getTagValue((Node)transformNode, (String)"rownum_field");
            this.dynamicFilenameField = XmlHandler.getTagValue((Node)transformNode, (String)"filename_Field");
            this.resetRowNumber = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"resetrownumber"));
            this.resolvevaluevariable = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"resolvevaluevariable"));
            Node filenode = XmlHandler.getSubNode((Node)transformNode, (String)"file");
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrFiles = XmlHandler.countNodes((Node)filenode, (String)"name");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFiles, nrFields);
            for (i = 0; i < nrFiles; ++i) {
                Node filenamenode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                Node excludefilemasknode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"exclude_filemask", (int)i);
                Node fileRequirednode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
                Node includeSubFoldersnode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"include_subfolders", (int)i);
                this.fileName[i] = XmlHandler.getNodeValue((Node)filenamenode);
                this.fileMask[i] = XmlHandler.getNodeValue((Node)filemasknode);
                this.excludeFileMask[i] = XmlHandler.getNodeValue((Node)excludefilemasknode);
                this.fileRequired[i] = XmlHandler.getNodeValue((Node)fileRequirednode);
                this.includeSubFolders[i] = XmlHandler.getNodeValue((Node)includeSubFoldersnode);
            }
            for (i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.inputFields[i] = new PropertyInputField();
                this.inputFields[i].setName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
                this.inputFields[i].setColumn(PropertyInputMeta.getColumnByCode(XmlHandler.getTagValue((Node)fnode, (String)"column")));
                this.inputFields[i].setType(ValueMetaFactory.getIdForValueMeta((String)XmlHandler.getTagValue((Node)fnode, (String)"type")));
                this.inputFields[i].setLength(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                this.inputFields[i].setPrecision(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
                String srepeat = XmlHandler.getTagValue((Node)fnode, (String)"repeat");
                this.inputFields[i].setTrimType(PropertyInputMeta.getTrimTypeByCode(XmlHandler.getTagValue((Node)fnode, (String)"trim_type")));
                if (srepeat != null) {
                    this.inputFields[i].setRepeated(YES.equalsIgnoreCase(srepeat));
                } else {
                    this.inputFields[i].setRepeated(false);
                }
                this.inputFields[i].setFormat(XmlHandler.getTagValue((Node)fnode, (String)"format"));
                this.inputFields[i].setCurrencySymbol(XmlHandler.getTagValue((Node)fnode, (String)"currency"));
                this.inputFields[i].setDecimalSymbol(XmlHandler.getTagValue((Node)fnode, (String)"decimal"));
                this.inputFields[i].setGroupSymbol(XmlHandler.getTagValue((Node)fnode, (String)"group"));
            }
            this.rowLimit = Const.toLong((String)XmlHandler.getTagValue((Node)transformNode, (String)"limit"), (long)0L);
            this.shortFileFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"shortFileFieldName");
            this.pathFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"pathFieldName");
            this.hiddenFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"hiddenFieldName");
            this.lastModificationTimeFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"lastModificationTimeFieldName");
            this.uriNameFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"uriNameFieldName");
            this.rootUriNameFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"rootUriNameFieldName");
            this.extensionFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"extensionFieldName");
            this.sizeFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"sizeFieldName");
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    public void allocate(int nrfiles, int nrFields) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
        this.excludeFileMask = new String[nrfiles];
        this.fileRequired = new String[nrfiles];
        this.includeSubFolders = new String[nrfiles];
        this.inputFields = new PropertyInputField[nrFields];
    }

    public void setDefault() {
        int i;
        this.shortFileFieldName = null;
        this.pathFieldName = null;
        this.hiddenFieldName = null;
        this.lastModificationTimeFieldName = null;
        this.uriNameFieldName = null;
        this.rootUriNameFieldName = null;
        this.extensionFieldName = null;
        this.sizeFieldName = null;
        this.fileType = fileTypeCode[0];
        this.section = "";
        this.encoding = DEFAULT_ENCODING;
        this.includeIniSection = false;
        this.iniSectionField = "";
        this.resolvevaluevariable = false;
        this.isaddresult = true;
        this.filefield = false;
        this.includeFilename = false;
        this.filenameField = "";
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.dynamicFilenameField = "";
        int nrFiles = 0;
        int nrFields = 0;
        this.allocate(nrFiles, nrFields);
        for (i = 0; i < nrFiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
            this.excludeFileMask[i] = "";
            this.fileRequired[i] = RequiredFilesCode[0];
            this.includeSubFolders[i] = RequiredFilesCode[0];
        }
        for (i = 0; i < nrFields; ++i) {
            this.inputFields[i] = new PropertyInputField("field" + (i + 1));
        }
        this.rowLimit = 0L;
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaString v;
        IValueMeta v2;
        for (int i = 0; i < this.inputFields.length; ++i) {
            PropertyInputField field = this.inputFields[i];
            int type = field.getType();
            if (type == 0) {
                type = 2;
            }
            try {
                v2 = ValueMetaFactory.createValueMeta((String)variables.resolve(field.getName()), (int)type);
                v2.setLength(field.getLength());
                v2.setPrecision(field.getPrecision());
                v2.setOrigin(name);
                v2.setConversionMask(field.getFormat());
                v2.setDecimalSymbol(field.getDecimalSymbol());
                v2.setGroupingSymbol(field.getGroupSymbol());
                v2.setCurrencySymbol(field.getCurrencySymbol());
                r.addValueMeta(v2);
                continue;
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
        String realFilenameField = variables.resolve(this.filenameField);
        if (this.includeFilename && !Utils.isEmpty((CharSequence)realFilenameField)) {
            ValueMetaString v3 = new ValueMetaString(realFilenameField);
            v3.setLength(500);
            v3.setPrecision(-1);
            v3.setOrigin(name);
            r.addValueMeta((IValueMeta)v3);
        }
        String realRowNumberField = variables.resolve(this.rowNumberField);
        if (this.includeRowNumber && !Utils.isEmpty((CharSequence)realRowNumberField)) {
            v2 = new ValueMetaInteger(realRowNumberField);
            v2.setLength(10, 0);
            v2.setOrigin(name);
            r.addValueMeta(v2);
        }
        String realSectionField = variables.resolve(this.iniSectionField);
        if (this.includeIniSection && !Utils.isEmpty((CharSequence)realSectionField)) {
            v = new ValueMetaString(realSectionField);
            v.setLength(500);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.getShortFileNameField() != null && this.getShortFileNameField().length() > 0) {
            v = new ValueMetaString(variables.resolve(this.getShortFileNameField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.getExtensionField() != null && this.getExtensionField().length() > 0) {
            v = new ValueMetaString(variables.resolve(this.getExtensionField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.getPathField() != null && this.getPathField().length() > 0) {
            v = new ValueMetaString(variables.resolve(this.getPathField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.getSizeField() != null && this.getSizeField().length() > 0) {
            v = new ValueMetaInteger(variables.resolve(this.getSizeField()));
            v.setOrigin(name);
            v.setLength(9);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.isHiddenField() != null && this.isHiddenField().length() > 0) {
            v = new ValueMetaBoolean(variables.resolve(this.isHiddenField()));
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.getLastModificationDateField() != null && this.getLastModificationDateField().length() > 0) {
            v = new ValueMetaDate(variables.resolve(this.getLastModificationDateField()));
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.getUriField() != null && this.getUriField().length() > 0) {
            v = new ValueMetaString(variables.resolve(this.getUriField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.getRootUriField() != null && this.getRootUriField().length() > 0) {
            v = new ValueMetaString(variables.resolve(this.getRootUriField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
    }

    public static final int getTrimTypeByCode(String tt) {
        if (tt != null) {
            for (int i = 0; i < type_trimCode.length; ++i) {
                if (!type_trimCode[i].equalsIgnoreCase(tt)) continue;
                return i;
            }
        }
        return 0;
    }

    public static final int getColumnByCode(String tt) {
        if (tt != null) {
            for (int i = 0; i < columnCode.length; ++i) {
                if (!columnCode[i].equalsIgnoreCase(tt)) continue;
                return i;
            }
        }
        return 0;
    }

    public FileInputList getFiles(IVariables variables) {
        boolean[] subdirs = new boolean[this.fileName.length];
        return FileInputList.createFileList((IVariables)variables, (String[])this.fileName, (String[])this.fileMask, (String[])this.excludeFileMask, (String[])this.fileRequired, (boolean[])subdirs);
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PropertyInputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PropertyInputMeta.CheckResult.NoInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        FileInputList fileInputList = this.getFiles(variables);
        if (fileInputList == null || fileInputList.getFiles().size() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PropertyInputMeta.CheckResult.NoFiles", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PropertyInputMeta.CheckResult.FilesOk", (String[])new String[]{"" + fileInputList.getFiles().size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            if (!this.filefield) {
                for (int i = 0; i < this.fileName.length; ++i) {
                    FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(this.fileName[i]));
                    this.fileName[i] = iResourceNaming.nameResource(fileObject, variables, Utils.isEmpty((CharSequence)this.fileMask[i]));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }
}

