/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis.serde;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.ClasspathPropertiesFileCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.EC2ContainerCredentialsProviderWrapper;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.PropertiesFileCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.Map;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.commons.lang3.reflect.FieldUtils;

class AwsModule
extends SimpleModule {
    private static final String AWS_ACCESS_KEY_ID = "awsAccessKeyId";
    private static final String AWS_SECRET_KEY = "awsSecretKey";
    private static final String SESSION_TOKEN = "sessionToken";
    private static final String CREDENTIALS_FILE_PATH = "credentialsFilePath";

    AwsModule() {
        super("AwsModule");
        this.setMixInAnnotation(AWSCredentialsProvider.class, AWSCredentialsProviderMixin.class);
    }

    private static class AWSCredentialsProviderSerializer
    extends JsonSerializer<AWSCredentialsProvider> {
        private static final ImmutableSet<Object> SINGLETON_CREDENTIAL_PROVIDERS = ImmutableSet.of(DefaultAWSCredentialsProviderChain.class, EnvironmentVariableCredentialsProvider.class, SystemPropertiesCredentialsProvider.class, ProfileCredentialsProvider.class, EC2ContainerCredentialsProviderWrapper.class);

        private AWSCredentialsProviderSerializer() {
        }

        public void serialize(AWSCredentialsProvider credentialsProvider, JsonGenerator jsonGenerator, SerializerProvider serializers) throws IOException {
            serializers.defaultSerializeValue((Object)credentialsProvider, jsonGenerator);
        }

        public void serializeWithType(AWSCredentialsProvider credentialsProvider, JsonGenerator jsonGenerator, SerializerProvider serializers, TypeSerializer typeSerializer) throws IOException {
            typeSerializer.writeTypePrefixForObject((Object)credentialsProvider, jsonGenerator);
            Class<?> providerClass = credentialsProvider.getClass();
            if (providerClass.equals(AWSStaticCredentialsProvider.class)) {
                AWSCredentials credentials = credentialsProvider.getCredentials();
                if (credentials.getClass().equals(BasicSessionCredentials.class)) {
                    BasicSessionCredentials sessionCredentials = (BasicSessionCredentials)credentials;
                    jsonGenerator.writeStringField(AwsModule.AWS_ACCESS_KEY_ID, sessionCredentials.getAWSAccessKeyId());
                    jsonGenerator.writeStringField(AwsModule.AWS_SECRET_KEY, sessionCredentials.getAWSSecretKey());
                    jsonGenerator.writeStringField(AwsModule.SESSION_TOKEN, sessionCredentials.getSessionToken());
                } else {
                    jsonGenerator.writeStringField(AwsModule.AWS_ACCESS_KEY_ID, credentials.getAWSAccessKeyId());
                    jsonGenerator.writeStringField(AwsModule.AWS_SECRET_KEY, credentials.getAWSSecretKey());
                }
            } else if (providerClass.equals(PropertiesFileCredentialsProvider.class)) {
                jsonGenerator.writeStringField(AwsModule.CREDENTIALS_FILE_PATH, this.readProviderField(credentialsProvider, AwsModule.CREDENTIALS_FILE_PATH));
            } else if (providerClass.equals(ClasspathPropertiesFileCredentialsProvider.class)) {
                jsonGenerator.writeStringField(AwsModule.CREDENTIALS_FILE_PATH, this.readProviderField(credentialsProvider, AwsModule.CREDENTIALS_FILE_PATH));
            } else if (!SINGLETON_CREDENTIAL_PROVIDERS.contains(credentialsProvider.getClass())) {
                throw new IllegalArgumentException("Unsupported AWS credentials provider type " + credentialsProvider.getClass());
            }
            typeSerializer.writeTypeSuffixForObject((Object)credentialsProvider, jsonGenerator);
        }

        private String readProviderField(AWSCredentialsProvider provider, String fieldName) throws IOException {
            try {
                return (String)Preconditions.checkNotNull((Object)FieldUtils.readField((Object)provider, (String)fieldName, (boolean)true));
            }
            catch (IllegalAccessException | IllegalArgumentException | NullPointerException e) {
                throw new IOException(String.format("Failed to access private field '%s' of AWS credential provider type '%s' with reflection", fieldName, provider.getClass().getSimpleName()), e);
            }
        }
    }

    private static class AWSCredentialsProviderDeserializer
    extends JsonDeserializer<AWSCredentialsProvider> {
        private AWSCredentialsProviderDeserializer() {
        }

        public AWSCredentialsProvider deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            return (AWSCredentialsProvider)context.readValue(jsonParser, AWSCredentialsProvider.class);
        }

        public AWSCredentialsProvider deserializeWithType(JsonParser jsonParser, DeserializationContext context, TypeDeserializer typeDeserializer) throws IOException {
            String typeNameKey;
            Map asMap = (Map)Preconditions.checkNotNull((Object)((Map)jsonParser.readValueAs((TypeReference)new TypeReference<Map<String, String>>(){})));
            String typeName = this.getNotNull(asMap, typeNameKey = typeDeserializer.getPropertyName(), "unknown");
            if (this.hasName(AWSStaticCredentialsProvider.class, typeName)) {
                boolean isSession = asMap.containsKey(AwsModule.SESSION_TOKEN);
                if (isSession) {
                    return new AWSStaticCredentialsProvider((AWSCredentials)new BasicSessionCredentials(this.getNotNull(asMap, AwsModule.AWS_ACCESS_KEY_ID, typeName), this.getNotNull(asMap, AwsModule.AWS_SECRET_KEY, typeName), this.getNotNull(asMap, AwsModule.SESSION_TOKEN, typeName)));
                }
                return new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.getNotNull(asMap, AwsModule.AWS_ACCESS_KEY_ID, typeName), this.getNotNull(asMap, AwsModule.AWS_SECRET_KEY, typeName)));
            }
            if (this.hasName(PropertiesFileCredentialsProvider.class, typeName)) {
                return new PropertiesFileCredentialsProvider(this.getNotNull(asMap, AwsModule.CREDENTIALS_FILE_PATH, typeName));
            }
            if (this.hasName(ClasspathPropertiesFileCredentialsProvider.class, typeName)) {
                return new ClasspathPropertiesFileCredentialsProvider(this.getNotNull(asMap, AwsModule.CREDENTIALS_FILE_PATH, typeName));
            }
            if (this.hasName(DefaultAWSCredentialsProviderChain.class, typeName)) {
                return DefaultAWSCredentialsProviderChain.getInstance();
            }
            if (this.hasName(EnvironmentVariableCredentialsProvider.class, typeName)) {
                return new EnvironmentVariableCredentialsProvider();
            }
            if (this.hasName(SystemPropertiesCredentialsProvider.class, typeName)) {
                return new SystemPropertiesCredentialsProvider();
            }
            if (this.hasName(ProfileCredentialsProvider.class, typeName)) {
                return new ProfileCredentialsProvider();
            }
            if (this.hasName(EC2ContainerCredentialsProviderWrapper.class, typeName)) {
                return new EC2ContainerCredentialsProviderWrapper();
            }
            throw new IOException(String.format("AWS credential provider type '%s' is not supported", typeName));
        }

        private String getNotNull(Map<String, String> map, String key, String typeName) {
            return (String)Preconditions.checkNotNull((Object)map.get(key), (String)"AWS credentials provider type '%s' is missing '%s'", (Object)typeName, (Object)key);
        }

        private boolean hasName(Class<? extends AWSCredentialsProvider> clazz, String typeName) {
            return typeName.equals(clazz.getSimpleName());
        }
    }

    @JsonDeserialize(using=AWSCredentialsProviderDeserializer.class)
    @JsonSerialize(using=AWSCredentialsProviderSerializer.class)
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
    private static class AWSCredentialsProviderMixin {
        private AWSCredentialsProviderMixin() {
        }
    }
}

