/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.restore;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.base.array.BytePrimitiveArraySerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.runtime.state.FullSnapshotUtil;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupsStateHandle;
import org.apache.flink.runtime.state.KeyedBackendSerializationProxy;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.RestoreOperation;
import org.apache.flink.runtime.state.SnappyStreamCompressionDecorator;
import org.apache.flink.runtime.state.StateSerializerProvider;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.runtime.state.StreamCompressionDecorator;
import org.apache.flink.runtime.state.UncompressedStreamCompressionDecorator;
import org.apache.flink.runtime.state.restore.KeyGroup;
import org.apache.flink.runtime.state.restore.KeyGroupEntry;
import org.apache.flink.runtime.state.restore.SavepointRestoreResult;
import org.apache.flink.runtime.state.restore.ThrowingIterator;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StateMigrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class FullSnapshotRestoreOperation<K>
implements RestoreOperation<ThrowingIterator<SavepointRestoreResult>> {
    private static final Logger LOG = LoggerFactory.getLogger(FullSnapshotRestoreOperation.class);
    private final KeyGroupRange keyGroupRange;
    private final ClassLoader userCodeClassLoader;
    private final Collection<KeyedStateHandle> restoreStateHandles;
    private final StateSerializerProvider<K> keySerializerProvider;
    private boolean isKeySerializerCompatibilityChecked;

    public FullSnapshotRestoreOperation(KeyGroupRange keyGroupRange, ClassLoader userCodeClassLoader, Collection<KeyedStateHandle> restoreStateHandles, StateSerializerProvider<K> keySerializerProvider) {
        this.keyGroupRange = keyGroupRange;
        this.userCodeClassLoader = userCodeClassLoader;
        this.restoreStateHandles = restoreStateHandles.stream().filter(Objects::nonNull).collect(Collectors.toList());
        this.keySerializerProvider = keySerializerProvider;
    }

    @Override
    public ThrowingIterator<SavepointRestoreResult> restore() throws IOException, StateMigrationException {
        return new ThrowingIterator<SavepointRestoreResult>(){
            private final Iterator<KeyedStateHandle> keyedStateHandlesIterator;
            {
                this.keyedStateHandlesIterator = FullSnapshotRestoreOperation.this.restoreStateHandles.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.keyedStateHandlesIterator.hasNext();
            }

            @Override
            public SavepointRestoreResult next() throws IOException, StateMigrationException {
                KeyedStateHandle keyedStateHandle = this.keyedStateHandlesIterator.next();
                if (!(keyedStateHandle instanceof KeyGroupsStateHandle)) {
                    throw StateUtil.unexpectedStateHandleException(KeyGroupsStateHandle.class, keyedStateHandle.getClass());
                }
                KeyGroupsStateHandle groupsStateHandle = (KeyGroupsStateHandle)keyedStateHandle;
                return FullSnapshotRestoreOperation.this.restoreKeyGroupsInStateHandle(groupsStateHandle);
            }

            @Override
            public void close() {
            }
        };
    }

    private SavepointRestoreResult restoreKeyGroupsInStateHandle(@Nonnull KeyGroupsStateHandle keyedStateHandle) throws IOException, StateMigrationException {
        FSDataInputStream currentStateHandleInStream;
        KeyedBackendSerializationProxy<K> serializationProxy = this.readMetaData((DataInputView)new DataInputViewStreamWrapper((InputStream)(currentStateHandleInStream = keyedStateHandle.openInputStream())));
        KeyGroupsIterator groupsIterator = new KeyGroupsIterator(this.keyGroupRange, keyedStateHandle, currentStateHandleInStream, serializationProxy.isUsingKeyGroupCompression() ? SnappyStreamCompressionDecorator.INSTANCE : UncompressedStreamCompressionDecorator.INSTANCE);
        return new SavepointRestoreResult(serializationProxy.getStateMetaInfoSnapshots(), groupsIterator);
    }

    private KeyedBackendSerializationProxy<K> readMetaData(DataInputView dataInputView) throws IOException, StateMigrationException {
        KeyedBackendSerializationProxy serializationProxy = new KeyedBackendSerializationProxy(this.userCodeClassLoader);
        serializationProxy.read(dataInputView);
        if (!this.isKeySerializerCompatibilityChecked) {
            TypeSerializer<K> currentSerializer = this.keySerializerProvider.currentSchemaSerializer();
            TypeSerializerSchemaCompatibility<K> keySerializerSchemaCompat = this.keySerializerProvider.setPreviousSerializerSnapshotForRestoredState(serializationProxy.getKeySerializerSnapshot());
            if (keySerializerSchemaCompat.isCompatibleAfterMigration() || keySerializerSchemaCompat.isIncompatible()) {
                throw new StateMigrationException("The new key serializer (" + currentSerializer + ") must be compatible with the previous key serializer (" + this.keySerializerProvider.previousSchemaSerializer() + ").");
            }
            this.isKeySerializerCompatibilityChecked = true;
        }
        return serializationProxy;
    }

    private static class KeyGroupEntriesIterator
    implements ThrowingIterator<KeyGroupEntry> {
        private final DataInputViewStreamWrapper kgInputView;
        private Integer currentKvStateId;

        private KeyGroupEntriesIterator(@Nonnull DataInputViewStreamWrapper kgInputView) throws IOException {
            this.kgInputView = kgInputView;
            this.currentKvStateId = 0xFFFF & kgInputView.readShort();
        }

        private KeyGroupEntriesIterator() {
            this.kgInputView = null;
            this.currentKvStateId = null;
        }

        @Override
        public boolean hasNext() {
            return this.currentKvStateId != null;
        }

        @Override
        public KeyGroupEntry next() throws IOException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            byte[] key = BytePrimitiveArraySerializer.INSTANCE.deserialize((DataInputView)this.kgInputView);
            byte[] value = BytePrimitiveArraySerializer.INSTANCE.deserialize((DataInputView)this.kgInputView);
            int entryStateId = this.currentKvStateId;
            if (FullSnapshotUtil.hasMetaDataFollowsFlag(key)) {
                FullSnapshotUtil.clearMetaDataFollowsFlag(key);
                this.currentKvStateId = 0xFFFF & this.kgInputView.readShort();
                if (65535 == this.currentKvStateId) {
                    this.currentKvStateId = null;
                }
            }
            return new KeyGroupEntry(entryStateId, key, value);
        }

        @Override
        public void close() throws IOException {
            if (this.kgInputView != null) {
                this.kgInputView.close();
            }
        }
    }

    private static class KeyGroupsIterator
    implements ThrowingIterator<KeyGroup> {
        @Nonnull
        private final KeyGroupRange keyGroupRange;
        @Nonnull
        private final Iterator<Tuple2<Integer, Long>> keyGroups;
        @Nonnull
        private final FSDataInputStream currentStateHandleInStream;
        @Nonnull
        private final StreamCompressionDecorator keygroupStreamCompressionDecorator;
        @Nonnull
        private final KeyGroupsStateHandle currentKeyGroupsStateHandle;

        private KeyGroupsIterator(@Nonnull KeyGroupRange keyGroupRange, @Nonnull KeyGroupsStateHandle currentKeyGroupsStateHandle, @Nonnull FSDataInputStream currentStateHandleInStream, @Nonnull StreamCompressionDecorator keygroupStreamCompressionDecorator) {
            this.keyGroupRange = keyGroupRange;
            this.keyGroups = currentKeyGroupsStateHandle.getGroupRangeOffsets().iterator();
            this.currentStateHandleInStream = currentStateHandleInStream;
            this.keygroupStreamCompressionDecorator = keygroupStreamCompressionDecorator;
            this.currentKeyGroupsStateHandle = currentKeyGroupsStateHandle;
            LOG.info("Starting to restore from state handle: {}.", (Object)currentKeyGroupsStateHandle);
        }

        @Override
        public boolean hasNext() {
            return this.keyGroups.hasNext();
        }

        @Override
        public KeyGroup next() throws IOException {
            Tuple2<Integer, Long> keyGroupOffset = this.keyGroups.next();
            int keyGroup = (Integer)keyGroupOffset.f0;
            Preconditions.checkState((boolean)this.keyGroupRange.contains(keyGroup), (Object)"The key group must belong to the backend");
            long offset = (Long)keyGroupOffset.f1;
            if (0L != offset) {
                this.currentStateHandleInStream.seek(offset);
                InputStream compressedKgIn = this.keygroupStreamCompressionDecorator.decorateWithCompression((InputStream)this.currentStateHandleInStream);
                DataInputViewStreamWrapper compressedKgInputView = new DataInputViewStreamWrapper(compressedKgIn);
                return new KeyGroup(keyGroup, new KeyGroupEntriesIterator(compressedKgInputView));
            }
            return new KeyGroup(keyGroup, new KeyGroupEntriesIterator());
        }

        @Override
        public void close() throws IOException {
            this.currentStateHandleInStream.close();
            LOG.info("Finished restoring from state handle: {}.", (Object)this.currentKeyGroupsStateHandle);
        }
    }
}

