/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.transport;

import java.io.IOException;
import java.io.InputStream;

public class LimitingInputStream
extends InputStream {
    private int maxSize;
    private int size;
    private InputStream in;

    public LimitingInputStream(int maxSize, InputStream in) {
        this.in = in;
        this.maxSize = maxSize;
    }

    private void checkSizeLimit() throws IOException {
        if (this.size > this.maxSize) {
            throw new IOException("Exceeded max size limit of " + this.maxSize + " with response size " + this.size);
        }
    }

    @Override
    public int read() throws IOException {
        int result = this.in.read();
        ++this.size;
        this.checkSizeLimit();
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int len = this.in.read(b);
        this.size += len;
        this.checkSizeLimit();
        return len;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int length = this.in.read(b, off, len);
        this.size += length;
        this.checkSizeLimit();
        return length;
    }

    @Override
    public long skip(long n) throws IOException {
        long len = this.in.skip(n);
        this.size = (int)((long)this.size + len);
        this.checkSizeLimit();
        return len;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }
}

