/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.wsdl;

import com.sforce.ws.ConnectionException;
import com.sforce.ws.wsdl.ComplexType;
import com.sforce.ws.wsdl.Element;
import com.sforce.ws.wsdl.Schema;
import com.sforce.ws.wsdl.SimpleType;
import com.sforce.ws.wsdl.WsdlNode;
import com.sforce.ws.wsdl.WsdlParseException;
import com.sforce.ws.wsdl.WsdlParser;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class Types
extends WsdlNode {
    private HashMap<String, Schema> schemas = new HashMap();

    public String toString() {
        return "Types{schemas=" + this.schemas + '}';
    }

    public void read(WsdlParser parser) throws WsdlParseException {
        int eventType = parser.getEventType();
        while (true) {
            String namespace;
            String name;
            if (eventType == 2) {
                name = parser.getName();
                namespace = parser.getNamespace();
                if ("schema".equals(name)) {
                    if (!"http://www.w3.org/2001/XMLSchema".equals(namespace)) {
                        throw new WsdlParseException("Unsupport schema version: " + namespace + ". It must be: " + "http://www.w3.org/2001/XMLSchema");
                    }
                    Schema schema = new Schema();
                    schema.read(parser);
                    this.schemas.put(schema.getTargetNamespace(), schema);
                }
            } else if (eventType == 3) {
                name = parser.getName();
                namespace = parser.getNamespace();
                if ("types".equals(name) && "http://schemas.xmlsoap.org/wsdl/".equals(namespace)) {
                    break;
                }
            } else if (eventType == 1) {
                throw new WsdlParseException("Failed to find end tag for 'types'");
            }
            eventType = parser.next();
        }
        try {
            this.updateElementRef();
        }
        catch (ConnectionException e) {
            throw new WsdlParseException(e.getMessage(), e);
        }
    }

    private void updateElementRef() throws WsdlParseException, ConnectionException {
        for (Schema s : this.getSchemas()) {
            this.checkGlobalElements(s);
            for (ComplexType ctype : s.getComplexTypes()) {
                if (ctype.getContent() == null) continue;
                Iterator<Element> elementIt = ctype.getContent().getElements();
                while (elementIt.hasNext()) {
                    Element element = elementIt.next();
                    if (element.getRef() == null) continue;
                    Element targetElement = this.getElement(element.getRef());
                    element.setName(targetElement.getName());
                    element.setType(targetElement.getType());
                }
            }
        }
    }

    private void checkGlobalElements(Schema s) throws WsdlParseException {
        Iterator<Element> elementIt = s.getGlobalElements();
        while (elementIt.hasNext()) {
            Element e = elementIt.next();
            if (e.getRef() == null) continue;
            throw new WsdlParseException("Global element can not use ref: " + e.getRef());
        }
    }

    public Collection<Schema> getSchemas() {
        return this.schemas.values();
    }

    public Element getElement(QName element) throws ConnectionException {
        Schema schema = this.getSchema(element);
        Element el = schema.getGlobalElement(element.getLocalPart());
        if (el == null) {
            throw new ConnectionException("Unable to find element for " + element);
        }
        return el;
    }

    private Schema getSchema(QName element) throws ConnectionException {
        Schema schema = this.schemas.get(element.getNamespaceURI());
        if (schema == null) {
            throw new ConnectionException("Unable to find schema for element; " + element);
        }
        return schema;
    }

    public SimpleType getSimpleTypeAllowNull(QName type) {
        Schema schema = this.schemas.get(type.getNamespaceURI());
        if (schema == null) {
            return null;
        }
        return schema.getSimpleType(type.getLocalPart());
    }

    public ComplexType getComplexType(QName type) throws ConnectionException {
        Schema schema = this.getSchema(type);
        ComplexType ct = schema.getComplexType(type.getLocalPart());
        if (ct == null) {
            throw new ConnectionException("Unable to find complexType for " + type);
        }
        return ct;
    }

    public ComplexType getComplexTypeAllowNull(QName type) {
        Schema schema = this.schemas.get(type.getNamespaceURI());
        if (schema == null) {
            return null;
        }
        return schema.getComplexType(type.getLocalPart());
    }
}

