/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.stub;

import com.google.api.core.ApiAsyncFunction;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.retrying.ExponentialPollAlgorithm;
import com.google.api.gax.retrying.NonCancellableFuture;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.RetryingExecutor;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.admin.v2.CheckConsistencyRequest;
import com.google.bigtable.admin.v2.CheckConsistencyResponse;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenRequest;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenResponse;
import com.google.bigtable.admin.v2.TableName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;

class AwaitReplicationCallable
extends UnaryCallable<TableName, Void> {
    private final UnaryCallable<GenerateConsistencyTokenRequest, GenerateConsistencyTokenResponse> generateCallable;
    private final UnaryCallable<CheckConsistencyRequest, CheckConsistencyResponse> checkCallable;
    private final RetryingExecutor<CheckConsistencyResponse> executor;

    static AwaitReplicationCallable create(UnaryCallable<GenerateConsistencyTokenRequest, GenerateConsistencyTokenResponse> generateCallable, UnaryCallable<CheckConsistencyRequest, CheckConsistencyResponse> checkCallable, ClientContext clientContext, RetrySettings pollingSettings) {
        RetryAlgorithm retryAlgorithm = new RetryAlgorithm((ResultRetryAlgorithm)new PollResultAlgorithm(), (TimedRetryAlgorithm)new ExponentialPollAlgorithm(pollingSettings, clientContext.getClock()));
        ScheduledRetryingExecutor retryingExecutor = new ScheduledRetryingExecutor(retryAlgorithm, clientContext.getExecutor());
        return new AwaitReplicationCallable(generateCallable, checkCallable, (RetryingExecutor<CheckConsistencyResponse>)retryingExecutor);
    }

    @VisibleForTesting
    AwaitReplicationCallable(UnaryCallable<GenerateConsistencyTokenRequest, GenerateConsistencyTokenResponse> generateCallable, UnaryCallable<CheckConsistencyRequest, CheckConsistencyResponse> checkCallable, RetryingExecutor<CheckConsistencyResponse> executor) {
        this.generateCallable = generateCallable;
        this.checkCallable = checkCallable;
        this.executor = executor;
    }

    public ApiFuture<Void> futureCall(final TableName tableName, final ApiCallContext context) {
        ApiFuture<GenerateConsistencyTokenResponse> tokenFuture = this.generateToken(tableName, context);
        return ApiFutures.transformAsync(tokenFuture, (ApiAsyncFunction)new ApiAsyncFunction<GenerateConsistencyTokenResponse, Void>(){

            public ApiFuture<Void> apply(GenerateConsistencyTokenResponse input) {
                CheckConsistencyRequest request = CheckConsistencyRequest.newBuilder().setName(tableName.toString()).setConsistencyToken(input.getConsistencyToken()).build();
                return AwaitReplicationCallable.this.pollToken(request, context);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private ApiFuture<GenerateConsistencyTokenResponse> generateToken(TableName tableName, ApiCallContext context) {
        GenerateConsistencyTokenRequest generateRequest = GenerateConsistencyTokenRequest.newBuilder().setName(tableName.toString()).build();
        return this.generateCallable.futureCall((Object)generateRequest, context);
    }

    private ApiFuture<Void> pollToken(CheckConsistencyRequest request, ApiCallContext context) {
        AttemptCallable<CheckConsistencyRequest, CheckConsistencyResponse> attemptCallable = new AttemptCallable<CheckConsistencyRequest, CheckConsistencyResponse>(this.checkCallable, request, context);
        RetryingFuture retryingFuture = this.executor.createFuture(attemptCallable);
        attemptCallable.setExternalFuture((RetryingFuture<CheckConsistencyResponse>)retryingFuture);
        attemptCallable.call();
        return ApiFutures.transform((ApiFuture)retryingFuture, (ApiFunction)new ApiFunction<CheckConsistencyResponse, Void>(){

            public Void apply(CheckConsistencyResponse input) {
                return null;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private static class PollResultAlgorithm
    implements ResultRetryAlgorithm<CheckConsistencyResponse> {
        private PollResultAlgorithm() {
        }

        public TimedAttemptSettings createNextAttempt(Throwable prevThrowable, CheckConsistencyResponse prevResponse, TimedAttemptSettings prevSettings) {
            return null;
        }

        public boolean shouldRetry(Throwable prevThrowable, CheckConsistencyResponse prevResponse) throws CancellationException {
            return prevResponse != null && !prevResponse.getConsistent();
        }
    }

    private static class AttemptCallable<RequestT, ResponseT>
    implements Callable<ResponseT> {
        private final UnaryCallable<RequestT, ResponseT> callable;
        private final RequestT request;
        private volatile RetryingFuture<ResponseT> externalFuture;
        private volatile ApiCallContext callContext;

        AttemptCallable(UnaryCallable<RequestT, ResponseT> callable, RequestT request, ApiCallContext callContext) {
            this.callable = callable;
            this.request = request;
            this.callContext = callContext;
        }

        void setExternalFuture(RetryingFuture<ResponseT> externalFuture) {
            this.externalFuture = externalFuture;
        }

        @Override
        public ResponseT call() {
            try {
                this.externalFuture.setAttemptFuture((ApiFuture)new NonCancellableFuture());
                if (this.externalFuture.isDone()) {
                    return null;
                }
                ApiFuture internalFuture = this.callable.futureCall(this.request, this.callContext);
                this.externalFuture.setAttemptFuture(internalFuture);
            }
            catch (Throwable e) {
                this.externalFuture.setAttemptFuture(ApiFutures.immediateFailedFuture((Throwable)e));
            }
            return null;
        }
    }
}

