/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.compress.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.hop.core.compress.CompressionInputStream;
import org.apache.hop.core.compress.ICompressionProvider;

public class GzipCompressionInputStream
extends CompressionInputStream {
    public GzipCompressionInputStream(InputStream in, ICompressionProvider provider) throws IOException {
        super(GzipCompressionInputStream.getDelegate(in), provider);
    }

    protected static GZIPInputStream getDelegate(InputStream in) throws IOException {
        GZIPInputStream delegate = null;
        delegate = in instanceof GZIPInputStream ? (GZIPInputStream)in : new GZIPInputStream(in);
        return delegate;
    }

    @Override
    public void close() throws IOException {
        GZIPInputStream gis = (GZIPInputStream)this.delegate;
        gis.close();
    }

    @Override
    public int read() throws IOException {
        GZIPInputStream gis = (GZIPInputStream)this.delegate;
        return gis.read();
    }
}

