/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.pmml;

import org.kie.api.pmml.PMMLConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLImplementationsUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PMMLImplementationsUtil.class);
    private static final String LEGACY_IMPL = "org.kie.pmml.assembler.PMMLAssemblerService";
    private static final String TRUSTY_IMPL = "org.kie.pmml.evaluator.assembler.service.PMMLAssemblerService";
    private static final String JPMML_IMPL = "org.kie.dmn.jpmml.DMNjPMMLInvocationEvaluator";

    public static PMMLConstants toEnable(ClassLoader classLoader) {
        boolean isLegacyPresent = PMMLImplementationsUtil.isImplementationPresent(LEGACY_IMPL, classLoader);
        boolean isTrustyPresent = PMMLImplementationsUtil.isImplementationPresent(TRUSTY_IMPL, classLoader);
        if (!isLegacyPresent && !isTrustyPresent) {
            return PMMLConstants.LEGACY;
        }
        return PMMLImplementationsUtil.getPMMLConstants(isLegacyPresent, isTrustyPresent);
    }

    protected static PMMLConstants getPMMLConstants(boolean isLegacyPresent, boolean isTrustyPresent) {
        String sysProp = System.getProperty(PMMLConstants.KIE_PMML_IMPLEMENTATION.getName());
        if (sysProp != null) {
            return PMMLImplementationsUtil.getFromPropertyAndClasspath(PMMLConstants.byName((String)sysProp), isLegacyPresent, isTrustyPresent);
        }
        return PMMLImplementationsUtil.getFromClassPath(isLegacyPresent, isTrustyPresent);
    }

    protected static PMMLConstants getFromPropertyAndClasspath(PMMLConstants pmmlConstants, boolean isLegacyPresent, boolean isTrustyPresent) {
        switch (pmmlConstants) {
            case LEGACY: {
                return PMMLImplementationsUtil.returnImplementation(PMMLConstants.LEGACY, isLegacyPresent);
            }
            case NEW: {
                return PMMLImplementationsUtil.returnImplementation(PMMLConstants.NEW, isTrustyPresent);
            }
        }
        throw new IllegalArgumentException("Unmanaged PMMLConstants " + pmmlConstants);
    }

    protected static PMMLConstants getFromClassPath(boolean isLegacyPresent, boolean isTrustyPresent) {
        if (isTrustyPresent) {
            return PMMLImplementationsUtil.returnImplementation(PMMLConstants.NEW, true);
        }
        return PMMLImplementationsUtil.returnImplementation(PMMLConstants.LEGACY, isLegacyPresent);
    }

    protected static PMMLConstants returnImplementation(PMMLConstants toReturn, boolean isPresent) {
        if (isPresent) {
            LOGGER.info("Using {} implementation", (Object)toReturn);
            return toReturn;
        }
        throw new IllegalArgumentException(String.format("Required %s PMML implementation missing in Classpath", toReturn));
    }

    private static boolean isImplementationPresent(String implementationFullName, ClassLoader classLoader) {
        try {
            classLoader.loadClass(implementationFullName);
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    public static boolean isjPMMLAvailableToClassLoader(ClassLoader classLoader) {
        try {
            classLoader.loadClass(JPMML_IMPL);
            LOGGER.info("jpmml libraries available on classpath");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

