/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.typeinfo;

import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class BaseCharTypeInfo
extends PrimitiveTypeInfo {
    private static final long serialVersionUID = 1L;
    private int length;

    public BaseCharTypeInfo() {
    }

    public BaseCharTypeInfo(String typeName) {
        super(typeName);
    }

    public BaseCharTypeInfo(String typeName, int length) {
        super(typeName);
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public String getQualifiedName() {
        return this.getQualifiedName(this.typeName, this.length);
    }

    protected String getQualifiedName(String typeName, int length) {
        return typeName + '(' + length + ')';
    }

    @Override
    public void setTypeName(String typeName) {
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.length;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BaseCharTypeInfo other = (BaseCharTypeInfo)obj;
        return this.length == other.length;
    }
}

