/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.helpers;

import java.io.IOException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.CoderUtils;

public final class CoderHelpers {
    private CoderHelpers() {
    }

    public static <T> byte[] toByteArray(T value, Coder<T> coder) {
        try {
            return CoderUtils.encodeToByteArray(coder, value);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error encoding value: " + value, e);
        }
    }

    public static <T> T fromByteArray(byte[] serialized, Coder<T> coder) {
        try {
            return (T)CoderUtils.decodeFromByteArray(coder, (byte[])serialized);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error decoding bytes for coder: " + coder, e);
        }
    }
}

