/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.helpers;

import java.lang.reflect.Constructor;
import org.apache.beam.runners.spark.structuredstreaming.translation.utils.ScalaInterop;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke;
import org.apache.spark.sql.catalyst.expressions.objects.NewInstance;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.types.DataType;
import scala.Option;
import scala.reflect.ClassTag;

public class EncoderFactory {
    private static final Constructor<StaticInvoke> STATIC_INVOKE_CONSTRUCTOR = StaticInvoke.class.getConstructors()[0];
    private static final Constructor<Invoke> INVOKE_CONSTRUCTOR = Invoke.class.getConstructors()[0];
    private static final Constructor<NewInstance> NEW_INSTANCE_CONSTRUCTOR = NewInstance.class.getConstructors()[0];

    static <T> ExpressionEncoder<T> create(Expression serializer, Expression deserializer, Class<? super T> clazz) {
        return new ExpressionEncoder(serializer, deserializer, ClassTag.apply(clazz));
    }

    static Expression invokeIfNotNull(Class<?> cls, String fun, DataType type, Expression ... args) {
        return EncoderFactory.invoke(cls, fun, type, true, args);
    }

    static Expression invoke(Class<?> cls, String fun, DataType type, Expression ... args) {
        return EncoderFactory.invoke(cls, fun, type, false, args);
    }

    private static Expression invoke(Class<?> cls, String fun, DataType type, boolean propagateNull, Expression ... args) {
        try {
            switch (STATIC_INVOKE_CONSTRUCTOR.getParameterCount()) {
                case 6: {
                    return (Expression)STATIC_INVOKE_CONSTRUCTOR.newInstance(cls, type, fun, ScalaInterop.seqOf(args), propagateNull, true);
                }
                case 8: {
                    return (Expression)STATIC_INVOKE_CONSTRUCTOR.newInstance(cls, type, fun, ScalaInterop.seqOf(args), ScalaInterop.emptyList(), propagateNull, true, true);
                }
            }
            throw new RuntimeException("Unsupported version of Spark");
        }
        catch (IllegalArgumentException | ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    static Expression invoke(Expression obj, String fun, DataType type, boolean nullable, Expression ... args) {
        try {
            switch (STATIC_INVOKE_CONSTRUCTOR.getParameterCount()) {
                case 6: {
                    return (Expression)INVOKE_CONSTRUCTOR.newInstance(obj, fun, type, ScalaInterop.seqOf(args), false, nullable);
                }
                case 8: {
                    return (Expression)INVOKE_CONSTRUCTOR.newInstance(obj, fun, type, ScalaInterop.seqOf(args), ScalaInterop.emptyList(), false, nullable, true);
                }
            }
            throw new RuntimeException("Unsupported version of Spark");
        }
        catch (IllegalArgumentException | ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    static Expression newInstance(Class<?> cls, DataType type, Expression ... args) {
        try {
            switch (NEW_INSTANCE_CONSTRUCTOR.getParameterCount()) {
                case 5: {
                    return (Expression)NEW_INSTANCE_CONSTRUCTOR.newInstance(cls, ScalaInterop.seqOf(args), true, type, Option.empty());
                }
                case 6: {
                    return (Expression)NEW_INSTANCE_CONSTRUCTOR.newInstance(cls, ScalaInterop.seqOf(args), ScalaInterop.emptyList(), true, type, Option.empty());
                }
            }
            throw new RuntimeException("Unsupported version of Spark");
        }
        catch (IllegalArgumentException | ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }
}

